/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.services;

import ghidra.app.plugin.core.debug.mapping.DebuggerTargetTraceMapper;
import ghidra.app.plugin.core.debug.service.model.DebuggerModelServiceProxyPlugin;
import ghidra.app.plugin.core.debug.service.model.launch.DebuggerProgramLaunchOffer;
import ghidra.app.services.ActionSource;
import ghidra.app.services.TraceRecorder;
import ghidra.dbg.DebuggerModelFactory;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetThread;
import ghidra.framework.plugintool.ServiceInfo;
import ghidra.program.model.listing.Program;
import ghidra.trace.model.Trace;
import ghidra.trace.model.thread.TraceThread;
import ghidra.util.datastruct.CollectionChangeListener;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;

@ServiceInfo(defaultProvider={DebuggerModelServiceProxyPlugin.class}, description="Service for managing debug sessions and connections")
public interface DebuggerModelService {
    public Set<DebuggerModelFactory> getModelFactories();

    public Set<DebuggerObjectModel> getModels();

    public CompletableFuture<Void> closeAllModels();

    public Collection<TraceRecorder> getTraceRecorders();

    public boolean addModel(DebuggerObjectModel var1);

    public boolean removeModel(DebuggerObjectModel var1);

    public TraceRecorder recordTarget(TargetObject var1, DebuggerTargetTraceMapper var2, ActionSource var3) throws IOException;

    public TraceRecorder recordTargetBestOffer(TargetObject var1);

    public TraceRecorder recordTargetPromptOffers(TargetObject var1);

    public TraceRecorder recordTargetAndActivateTrace(TargetObject var1, DebuggerTargetTraceMapper var2) throws IOException;

    public TraceRecorder getRecorder(TargetObject var1);

    public TraceRecorder getRecorderForSuccessor(TargetObject var1);

    public TraceRecorder getRecorder(Trace var1);

    public TargetObject getTarget(Trace var1);

    public Trace getTrace(TargetObject var1);

    public TargetThread getTargetThread(TraceThread var1);

    public TraceThread getTraceThread(TargetThread var1);

    public TraceThread getTraceThread(TargetObject var1, TargetThread var2);

    public void activateModel(DebuggerObjectModel var1);

    public DebuggerObjectModel getCurrentModel();

    public TargetObject getTargetFocus(TargetObject var1);

    public void addFactoriesChangedListener(CollectionChangeListener<DebuggerModelFactory> var1);

    public void removeFactoriesChangedListener(CollectionChangeListener<DebuggerModelFactory> var1);

    public void addModelsChangedListener(CollectionChangeListener<DebuggerObjectModel> var1);

    public void removeModelsChangedListener(CollectionChangeListener<DebuggerObjectModel> var1);

    public void addTraceRecordersChangedListener(CollectionChangeListener<TraceRecorder> var1);

    public void removeTraceRecordersChangedListener(CollectionChangeListener<TraceRecorder> var1);

    public Stream<DebuggerProgramLaunchOffer> getProgramLaunchOffers(Program var1);

    public CompletableFuture<DebuggerObjectModel> showConnectDialog();

    public CompletableFuture<DebuggerObjectModel> showConnectDialog(Program var1);

    public CompletableFuture<DebuggerObjectModel> showConnectDialog(DebuggerModelFactory var1);
}

