/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.workflow;

import ghidra.app.plugin.core.debug.workflow.AbstractMapDebuggerBot;
import ghidra.app.services.DebuggerBotInfo;
import ghidra.app.services.DebuggerStaticMappingService;
import ghidra.app.services.MapProposal;
import ghidra.app.services.RegionMapProposal;
import ghidra.framework.options.annotation.HelpInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Program;
import ghidra.trace.model.Trace;
import ghidra.trace.model.memory.TraceMemoryRegion;
import ghidra.trace.util.TraceChangeType;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

@DebuggerBotInfo(description="Map regions to open programs", details="Monitors open traces and programs, attempting to map regions by \"best\" match.", help=@HelpInfo(anchor="map_regions"), enabledByDefault=false)
public class MapRegionsDebuggerBot
extends AbstractMapDebuggerBot {
    @Override
    protected Collection<TraceChangeType<?, ?>> getChangeTypes() {
        return List.of(Trace.TraceMemoryRegionChangeType.ADDED);
    }

    @Override
    protected void doAnalysis(PluginTool tool, Trace trace, Set<Program> programs, TaskMonitor monitor) throws CancelledException {
        DebuggerStaticMappingService mappingService = (DebuggerStaticMappingService)tool.getService(DebuggerStaticMappingService.class);
        if (mappingService != null) {
            Map<Collection<TraceMemoryRegion>, RegionMapProposal> maps = mappingService.proposeRegionMaps(trace.getMemoryManager().getAllRegions(), programs);
            Collection<RegionMapProposal.RegionMapEntry> entries = MapProposal.flatten(maps.values());
            entries = MapProposal.removeOverlapping(entries);
            mappingService.addRegionMappings(entries, monitor, false);
        }
    }
}

