/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.stack;

import ghidra.app.plugin.core.debug.DebuggerCoordinates;
import ghidra.app.plugin.core.debug.stack.AbstractUnwoundFrame;
import ghidra.app.plugin.core.debug.stack.SavedRegisterMap;
import ghidra.app.plugin.core.debug.stack.StackUnwindWarning;
import ghidra.app.plugin.core.debug.stack.StackUnwindWarningSet;
import ghidra.app.plugin.core.debug.stack.StackUnwinder;
import ghidra.app.plugin.core.debug.stack.UnwindException;
import ghidra.framework.plugintool.PluginTool;
import ghidra.pcode.exec.DebuggerPcodeUtils;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Function;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.util.ProgramLocation;
import ghidra.trace.model.DefaultTraceLocation;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.TraceLocation;
import ghidra.trace.model.bookmark.TraceBookmark;
import ghidra.trace.model.listing.TraceData;
import ghidra.trace.model.symbol.TraceReference;
import ghidra.trace.util.TraceRegisterUtils;
import ghidra.util.Msg;

public class ListingUnwoundFrame
extends AbstractUnwoundFrame<DebuggerPcodeUtils.WatchValue> {
    private final TraceData frame;
    private final int level;
    private final Address pcVal;
    private final Function function;
    private final Address base;
    private SavedRegisterMap registerMap;

    public static boolean isFrame(TraceData data) {
        DataType type = data.getDataType();
        return type.getCategoryPath().equals((Object)StackUnwinder.FRAMES_PATH);
    }

    private static Integer getLevel(TraceData data) {
        String comment = data.getComment(1);
        if (comment == null) {
            return null;
        }
        String[] parts = comment.split("\\s+");
        if (parts.length == 0) {
            return null;
        }
        try {
            return Integer.parseInt(parts[0]);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public ListingUnwoundFrame(PluginTool tool, DebuggerCoordinates coordinates, TraceData frame) {
        super(tool, coordinates, DebuggerPcodeUtils.buildWatchState(tool, coordinates.frame(0)));
        if (!ListingUnwoundFrame.isFrame(frame)) {
            throw new IllegalArgumentException("frame does not appear to represent a frame");
        }
        this.frame = frame;
        this.level = this.loadLevel();
        this.pcVal = this.loadProgramCounter();
        this.function = this.loadFunction();
        this.base = this.loadBasePointer();
    }

    @Override
    public boolean isFake() {
        return false;
    }

    public TraceData getData() {
        return this.frame;
    }

    @Override
    protected Address applyBase(long offset) {
        return this.base.add(offset);
    }

    private int loadLevel() {
        Integer l = ListingUnwoundFrame.getLevel(this.frame);
        if (l == null) {
            throw new IllegalStateException("Frame has no comment indicating its level");
        }
        return l;
    }

    private Address loadProgramCounter() {
        for (Reference ref : this.frame.getReferenceIteratorTo()) {
            if (ref.getReferenceType() != RefType.DATA || ref.getOperandIndex() != -1) continue;
            return ref.getFromAddress();
        }
        throw new UnwindException("The program counter reference is missing for the frame!");
    }

    private Function loadFunction() {
        ProgramLocation staticLoc = this.mappingService.getOpenMappedLocation((TraceLocation)new DefaultTraceLocation(this.frame.getTrace(), null, Lifespan.at((long)this.coordinates.getSnap()), this.pcVal));
        if (staticLoc == null) {
            throw new UnwindException("The program containing the frame's function is unavailable, or the mappings have changed.");
        }
        Function function = staticLoc.getProgram().getFunctionManager().getFunctionContaining(staticLoc.getAddress());
        if (function == null) {
            throw new UnwindException("The function for the frame is no longer present in the mapped program.");
        }
        return function;
    }

    private Address loadBasePointer() {
        for (TraceReference ref : this.frame.getOperandReferences(0)) {
            if (ref.getReferenceType() != RefType.DATA) continue;
            return ref.getToAddress();
        }
        return null;
    }

    @Override
    public String getDescription() {
        return this.frame.getComment(1);
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public Address getProgramCounter() {
        return this.pcVal;
    }

    @Override
    public Function getFunction() {
        return this.function;
    }

    @Override
    public Address getBasePointer() {
        return this.base;
    }

    @Override
    protected Address computeAddressOfReturnAddress() {
        int numComponents = this.frame.getNumComponents();
        for (int i = 0; i < numComponents; ++i) {
            TraceData component = this.frame.getComponent(i);
            if (!"return_address".equals(component.getFieldName())) continue;
            return component.getMinAddress();
        }
        return null;
    }

    @Override
    public Address getReturnAddress() {
        int numComponents = this.frame.getNumComponents();
        for (int i = 0; i < numComponents; ++i) {
            Object value;
            TraceData component = this.frame.getComponent(i);
            if (!"return_address".equals(component.getFieldName()) || !((value = component.getValue()) instanceof Address)) continue;
            Address returnAddress = (Address)value;
            return returnAddress;
        }
        return null;
    }

    @Override
    public StackUnwindWarningSet getWarnings() {
        StackUnwindWarningSet warnings = new StackUnwindWarningSet();
        for (TraceBookmark bookmark : this.frame.getTrace().getBookmarkManager().getBookmarksAt(this.frame.getStartSnap(), this.frame.getMinAddress())) {
            String comment;
            if (!bookmark.getTypeString().equals("Warning") || (comment = bookmark.getComment()) == null) continue;
            for (String line : comment.split("\n")) {
                warnings.add(new StackUnwindWarning.CustomStackUnwindWarning(line));
            }
        }
        return warnings;
    }

    @Override
    public Exception getError() {
        return null;
    }

    @Override
    protected synchronized SavedRegisterMap computeRegisterMap() {
        if (this.registerMap != null) {
            return this.registerMap;
        }
        TraceData[] innerFrames = new TraceData[this.level];
        for (TraceData inner : this.trace.getCodeManager().definedData().get(this.viewSnap, this.frame.getMinAddress(), false)) {
            Integer il;
            if (inner == this.frame) continue;
            if (!ListingUnwoundFrame.isFrame(inner) || (il = ListingUnwoundFrame.getLevel(inner)) == null) break;
            innerFrames[il.intValue()] = inner;
        }
        this.registerMap = new SavedRegisterMap();
        for (TraceData inner : innerFrames) {
            ListingUnwoundFrame.mapSavedRegisters(this.language, inner, this.registerMap);
        }
        return this.registerMap;
    }

    protected static void mapSavedRegisters(Language language, TraceData frame, SavedRegisterMap map) {
        int numComponents = frame.getNumComponents();
        for (int i = 0; i < numComponents; ++i) {
            TraceData component = frame.getComponent(i);
            String name = component.getFieldName();
            if (!name.startsWith("saved_")) continue;
            String regName = name.substring("saved_".length());
            Register register = language.getRegister(regName);
            if (register == null) {
                Msg.warn(ListingUnwoundFrame.class, (Object)("Unknown register name in saved_register field: " + regName));
                continue;
            }
            map.put(TraceRegisterUtils.rangeForRegister((Register)register), component.getRange());
        }
    }

    public TraceData getComponentContaining(Address address) {
        return this.frame.getComponentContaining((int)address.subtract(this.frame.getMinAddress()));
    }
}

