/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.model;

import ghidra.app.plugin.core.debug.mapping.DebuggerMemoryMapper;
import ghidra.app.plugin.core.debug.service.model.interfaces.AbstractRecorderMemory;
import ghidra.dbg.target.TargetMemory;
import ghidra.dbg.target.TargetMemoryRegion;
import ghidra.dbg.target.TargetObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSpace;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;

public class RecorderSimpleMemory
implements AbstractRecorderMemory {
    private static final int BLOCK_SIZE = 4096;
    private static final long BLOCK_MASK = -4096L;
    protected final NavigableMap<Address, TargetMemoryRegion> byMin = new TreeMap<Address, TargetMemoryRegion>();
    protected TargetMemory memory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMemory(TargetMemory memory) {
        RecorderSimpleMemory recorderSimpleMemory = this;
        synchronized (recorderSimpleMemory) {
            if (this.memory == null) {
                this.memory = memory;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRegion(TargetMemoryRegion region, TargetMemory memory) {
        RecorderSimpleMemory recorderSimpleMemory = this;
        synchronized (recorderSimpleMemory) {
            if (this.memory == null) {
                this.memory = memory;
            }
            this.byMin.put(region.getRange().getMinAddress(), region);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMemory(TargetMemory invalid) {
        RecorderSimpleMemory recorderSimpleMemory = this;
        synchronized (recorderSimpleMemory) {
            if (this.memory == invalid) {
                this.memory = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeRegion(TargetObject invalid) {
        if (!(invalid instanceof TargetMemoryRegion)) {
            return false;
        }
        RecorderSimpleMemory recorderSimpleMemory = this;
        synchronized (recorderSimpleMemory) {
            TargetMemoryRegion invRegion = (TargetMemoryRegion)invalid;
            this.byMin.remove(invRegion.getRange().getMinAddress());
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<byte[]> readMemory(Address address, int length) {
        RecorderSimpleMemory recorderSimpleMemory = this;
        synchronized (recorderSimpleMemory) {
            if (this.memory != null) {
                return this.memory.readMemory(address, length);
            }
            return CompletableFuture.completedFuture(new byte[0]);
        }
    }

    @Override
    public CompletableFuture<Void> writeMemory(Address address, byte[] data) {
        RecorderSimpleMemory recorderSimpleMemory = this;
        synchronized (recorderSimpleMemory) {
            if (this.memory != null) {
                return this.memory.writeMemory(address, data);
            }
            throw new IllegalArgumentException("read starts outside any address space");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddressSet getAccessibleMemory(Predicate<TargetMemory> pred, DebuggerMemoryMapper memMapper) {
        RecorderSimpleMemory recorderSimpleMemory = this;
        synchronized (recorderSimpleMemory) {
            AddressSet accessible = new AddressSet();
            if (memMapper != null) {
                for (Map.Entry ent : this.byMin.entrySet()) {
                    AddressRange traceRange = memMapper.targetToTraceTruncated(((TargetMemoryRegion)ent.getValue()).getRange());
                    if (traceRange == null) continue;
                    accessible.add(traceRange);
                }
            }
            return accessible;
        }
    }

    @Override
    public AddressRange alignAndLimitToFloor(Address address, int length) {
        Map.Entry<Address, TargetMemoryRegion> floor = this.findChainedFloor(address);
        if (floor == null) {
            return null;
        }
        return this.align(address, length).intersect(floor.getValue().getRange());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map.Entry<Address, TargetMemoryRegion> findChainedFloor(Address address) {
        RecorderSimpleMemory recorderSimpleMemory = this;
        synchronized (recorderSimpleMemory) {
            return this.byMin.floorEntry(address);
        }
    }

    protected AddressRange align(Address address, int length) {
        AddressSpace space = address.getAddressSpace();
        long offset = address.getOffset();
        Address start = space.getAddress(offset & 0xFFFFFFFFFFFFF000L);
        Address end = space.getAddress((offset + (long)length - 1L & 0xFFFFFFFFFFFFF000L) + 4096L - 1L);
        return new AddressRangeImpl(start, end);
    }
}

