/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.model;

import ghidra.app.plugin.core.debug.mapping.DebuggerMemoryMapper;
import ghidra.app.plugin.core.debug.mapping.DebuggerRegisterMapper;
import ghidra.app.plugin.core.debug.mapping.DefaultDebuggerTargetTraceMapper;
import ghidra.app.plugin.core.debug.service.model.DebuggerModelServicePlugin;
import ghidra.app.plugin.core.debug.service.model.DefaultBreakpointRecorder;
import ghidra.app.plugin.core.debug.service.model.DefaultMemoryRecorder;
import ghidra.app.plugin.core.debug.service.model.DefaultModuleRecorder;
import ghidra.app.plugin.core.debug.service.model.DefaultProcessRecorder;
import ghidra.app.plugin.core.debug.service.model.DefaultThreadRecorder;
import ghidra.app.plugin.core.debug.service.model.DefaultTimeRecorder;
import ghidra.app.plugin.core.debug.service.model.PermanentTransactionExecutor;
import ghidra.app.plugin.core.debug.service.model.RecorderPermanentTransaction;
import ghidra.app.plugin.core.debug.service.model.RecorderThreadMap;
import ghidra.app.plugin.core.debug.service.model.TraceObjectManager;
import ghidra.app.plugin.core.debug.service.model.interfaces.AbstractRecorderMemory;
import ghidra.app.plugin.core.debug.service.model.interfaces.ManagedStackRecorder;
import ghidra.app.plugin.core.debug.service.model.interfaces.ManagedThreadRecorder;
import ghidra.app.plugin.core.debug.service.model.record.DataTypeRecorder;
import ghidra.app.plugin.core.debug.service.model.record.SymbolRecorder;
import ghidra.app.services.TraceRecorder;
import ghidra.app.services.TraceRecorderListener;
import ghidra.async.AsyncLazyValue;
import ghidra.async.AsyncUtils;
import ghidra.dbg.agent.AbstractDebuggerObjectModel;
import ghidra.dbg.error.DebuggerModelAccessException;
import ghidra.dbg.target.TargetActiveScope;
import ghidra.dbg.target.TargetBreakpointLocation;
import ghidra.dbg.target.TargetBreakpointSpec;
import ghidra.dbg.target.TargetBreakpointSpecContainer;
import ghidra.dbg.target.TargetDataTypeNamespace;
import ghidra.dbg.target.TargetExecutionStateful;
import ghidra.dbg.target.TargetFocusScope;
import ghidra.dbg.target.TargetMemoryRegion;
import ghidra.dbg.target.TargetModule;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetRegisterBank;
import ghidra.dbg.target.TargetSection;
import ghidra.dbg.target.TargetStackFrame;
import ghidra.dbg.target.TargetSymbolNamespace;
import ghidra.dbg.target.TargetThread;
import ghidra.dbg.util.PathUtils;
import ghidra.framework.model.UndoableDomainObject;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.trace.model.Trace;
import ghidra.trace.model.breakpoint.TraceBreakpoint;
import ghidra.trace.model.breakpoint.TraceBreakpointKind;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.model.memory.TraceMemoryRegion;
import ghidra.trace.model.modules.TraceModule;
import ghidra.trace.model.modules.TraceSection;
import ghidra.trace.model.stack.TraceStackFrame;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.model.time.TraceSnapshot;
import ghidra.util.Msg;
import ghidra.util.datastruct.ListenerSet;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;

public class DefaultTraceRecorder
implements TraceRecorder {
    static final int POOL_SIZE = Math.min(16, Runtime.getRuntime().availableProcessors());
    protected final DebuggerModelServicePlugin plugin;
    protected final PluginTool tool;
    protected final TargetObject target;
    protected final Trace trace;
    final RecorderThreadMap threadMap = new RecorderThreadMap();
    TraceObjectManager objectManager;
    DefaultBreakpointRecorder breakpointRecorder;
    DataTypeRecorder datatypeRecorder;
    DefaultMemoryRecorder memoryRecorder;
    DefaultModuleRecorder moduleRecorder;
    DefaultProcessRecorder processRecorder;
    SymbolRecorder symbolRecorder;
    DefaultTimeRecorder timeRecorder;
    protected final PermanentTransactionExecutor parTx;
    protected final Executor privateQueue = Executors.newSingleThreadExecutor((ThreadFactory)new BasicThreadFactory.Builder().namingPattern("DTR-EventQueue-%d").build());
    protected final AsyncLazyValue<Void> lazyInit = new AsyncLazyValue(this::doInit);
    private boolean valid = true;
    protected TargetObject curFocus;

    public DefaultTraceRecorder(DebuggerModelServicePlugin plugin, Trace trace, TargetObject target, DefaultDebuggerTargetTraceMapper mapper) {
        trace.addConsumer((Object)this);
        this.plugin = plugin;
        this.tool = plugin.getTool();
        this.trace = trace;
        this.target = target;
        this.parTx = new PermanentTransactionExecutor((UndoableDomainObject)trace, "TraceRecorder(par): " + target.getJoinedPath("."), POOL_SIZE, 100);
        this.processRecorder = new DefaultProcessRecorder(this);
        this.breakpointRecorder = new DefaultBreakpointRecorder(this);
        this.datatypeRecorder = new DataTypeRecorder(this);
        this.memoryRecorder = new DefaultMemoryRecorder(this);
        this.moduleRecorder = new DefaultModuleRecorder(this);
        this.symbolRecorder = new SymbolRecorder(this);
        this.timeRecorder = new DefaultTimeRecorder(this);
        this.objectManager = new TraceObjectManager(target, mapper, this);
    }

    @Override
    public TargetObject getTargetObject(TraceObject obj) {
        return null;
    }

    @Override
    public TraceObject getTraceObject(TargetObject obj) {
        return null;
    }

    @Override
    public TargetBreakpointLocation getTargetBreakpoint(TraceBreakpoint bpt) {
        return this.objectManager.getTargetBreakpoint(bpt);
    }

    @Override
    public TargetMemoryRegion getTargetMemoryRegion(TraceMemoryRegion region) {
        return this.objectManager.getTargetMemoryRegion(region);
    }

    @Override
    public TargetModule getTargetModule(TraceModule module) {
        return this.objectManager.getTargetModule(module);
    }

    @Override
    public TargetSection getTargetSection(TraceSection section) {
        return this.objectManager.getTargetSection(section);
    }

    @Override
    public List<TargetBreakpointSpecContainer> collectBreakpointContainers(TargetThread thread) {
        ArrayList<TargetBreakpointSpecContainer> result = new ArrayList<TargetBreakpointSpecContainer>();
        this.objectManager.onBreakpointContainers(thread, result::add);
        return result;
    }

    @Override
    public List<TargetBreakpointLocation> collectBreakpoints(TargetThread thread) {
        return this.objectManager.collectBreakpoints(thread);
    }

    @Override
    public Set<TraceBreakpointKind> getSupportedBreakpointKinds() {
        HashSet<TargetBreakpointSpec.TargetBreakpointKind> tKinds = new HashSet<TargetBreakpointSpec.TargetBreakpointKind>();
        this.objectManager.onBreakpointContainers(null, cont -> tKinds.addAll((Collection<TargetBreakpointSpec.TargetBreakpointKind>)cont.getSupportedBreakpointKinds()));
        return TraceRecorder.targetToTraceBreakpointKinds(tKinds);
    }

    @Override
    public TraceBreakpoint getTraceBreakpoint(TargetBreakpointLocation bpt) {
        return this.breakpointRecorder.getTraceBreakpoint(bpt);
    }

    @Override
    public TraceMemoryRegion getTraceMemoryRegion(TargetMemoryRegion region) {
        return this.memoryRecorder.getTraceMemoryRegion(region);
    }

    @Override
    public TraceModule getTraceModule(TargetModule module) {
        return this.moduleRecorder.getTraceModule(module);
    }

    @Override
    public TraceSection getTraceSection(TargetSection section) {
        return this.moduleRecorder.getTraceSection(section);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ManagedThreadRecorder computeIfAbsent(TargetThread thread) {
        AbstractDebuggerObjectModel model = (AbstractDebuggerObjectModel)thread.getModel();
        Object object = model.lock;
        synchronized (object) {
            if (!this.threadMap.byTargetThread.containsKey(thread) && this.objectManager.hasObject((TargetObject)thread)) {
                this.createTraceThread(thread);
            }
            return this.threadMap.get(thread);
        }
    }

    public TraceThread createTraceThread(TargetThread thread) {
        String path = PathUtils.toString((List)thread.getPath());
        RecorderPermanentTransaction tid = RecorderPermanentTransaction.start((UndoableDomainObject)this.trace, path + " created");
        try {
            TraceThread tthread = this.trace.getThreadManager().createThread(path, thread.getShortDisplay(), this.getSnap());
            this.threadMap.put(new DefaultThreadRecorder(this, this.objectManager.getMapper(), thread, tthread));
            TraceThread traceThread = tthread;
            if (tid != null) {
                tid.close();
            }
            return traceThread;
        }
        catch (Throwable throwable) {
            try {
                if (tid != null) {
                    try {
                        tid.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (DuplicateNameException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    @Override
    public TargetThread getTargetThread(TraceThread thread) {
        DefaultThreadRecorder rec = this.getThreadRecorder(thread);
        return rec == null ? null : rec.getTargetThread();
    }

    @Override
    public TargetExecutionStateful.TargetExecutionState getTargetThreadState(TargetThread thread) {
        DefaultThreadRecorder rec = (DefaultThreadRecorder)this.getThreadRecorder(thread);
        return rec == null ? null : rec.state;
    }

    @Override
    public TargetExecutionStateful.TargetExecutionState getTargetThreadState(TraceThread thread) {
        DefaultThreadRecorder rec = this.getThreadRecorder(thread);
        return rec == null ? null : rec.state;
    }

    @Override
    public Set<TargetRegisterBank> getTargetRegisterBanks(TraceThread thread, int frameLevel) {
        DefaultThreadRecorder rec = this.getThreadRecorder(thread);
        return rec.getTargetRegisterBank(thread, frameLevel);
    }

    @Override
    public TargetStackFrame getTargetStackFrame(TraceThread thread, int frameLevel) {
        DefaultThreadRecorder rec = this.getThreadRecorder(thread);
        if (rec == null) {
            return null;
        }
        return rec.getStackRecorder().getTargetStackFrame(frameLevel);
    }

    @Override
    public TraceThread getTraceThread(TargetThread thread) {
        ManagedThreadRecorder rec = this.getThreadRecorder(thread);
        return rec == null ? null : rec.getTraceThread();
    }

    @Override
    public TraceThread getTraceThreadForSuccessor(TargetObject successor) {
        ManagedThreadRecorder rec = this.getThreadRecorderForSuccessor(successor);
        return rec == null ? null : rec.getTraceThread();
    }

    @Override
    public TraceStackFrame getTraceStackFrame(TargetStackFrame frame) {
        return this.getTraceStackFrameForSuccessor((TargetObject)frame);
    }

    @Override
    public TraceStackFrame getTraceStackFrameForSuccessor(TargetObject successor) {
        ManagedThreadRecorder rec = this.getThreadRecorderForSuccessor(successor);
        if (rec == null) {
            return null;
        }
        ManagedStackRecorder stackRecorder = rec.getStackRecorder();
        int level = stackRecorder.getSuccessorFrameLevel(successor);
        return stackRecorder.getTraceStackFrame(rec.getTraceThread(), level);
    }

    @Override
    public CompletableFuture<Void> readMemoryBlocks(AddressSetView set, TaskMonitor monitor) {
        if (set.isEmpty()) {
            return AsyncUtils.NIL;
        }
        return this.memoryRecorder.captureProcessMemory(set, monitor);
    }

    @Override
    public CompletableFuture<Void> captureDataTypes(TargetDataTypeNamespace namespace, TaskMonitor monitor) {
        if (!this.valid) {
            return AsyncUtils.NIL;
        }
        return this.datatypeRecorder.captureDataTypes(namespace, monitor);
    }

    @Override
    public CompletableFuture<Void> captureDataTypes(TraceModule module, TaskMonitor monitor) {
        TargetModule targetModule = this.getTargetModule(module);
        if (targetModule == null) {
            Msg.error((Object)this, (Object)("Module " + module + " is not loaded"));
            return AsyncUtils.NIL;
        }
        return this.datatypeRecorder.captureDataTypes(targetModule, monitor);
    }

    @Override
    public CompletableFuture<Void> captureSymbols(TargetSymbolNamespace namespace, TaskMonitor monitor) {
        if (!this.valid) {
            return AsyncUtils.NIL;
        }
        return this.symbolRecorder.captureSymbols(namespace, monitor);
    }

    @Override
    public CompletableFuture<Void> captureSymbols(TraceModule module, TaskMonitor monitor) {
        TargetModule targetModule = this.getTargetModule(module);
        if (targetModule == null) {
            Msg.error((Object)this, (Object)("Module " + module + " is not loaded"));
            return AsyncUtils.NIL;
        }
        return this.symbolRecorder.captureSymbols(targetModule, monitor);
    }

    @Override
    public CompletableFuture<Void> captureThreadRegisters(TracePlatform platform, TraceThread thread, int frameLevel, Set<Register> registers) {
        DefaultThreadRecorder rec = this.getThreadRecorder(thread);
        return rec.captureThreadRegisters(thread, frameLevel, registers).thenApply(__ -> null);
    }

    @Override
    public CompletableFuture<Void> init() {
        return this.lazyInit.request();
    }

    protected CompletableFuture<Void> doInit() {
        this.timeRecorder.createSnapshot("Started recording" + PathUtils.toString((List)this.target.getPath()) + " in " + this.target.getModel(), null, null);
        return this.objectManager.init();
    }

    @Override
    public long getSnap() {
        return this.timeRecorder.getSnap();
    }

    @Override
    public TraceSnapshot forceSnapshot() {
        return this.timeRecorder.forceSnapshot();
    }

    @Override
    public boolean isRecording() {
        return this.valid;
    }

    @Override
    public void stopRecording() {
        this.invalidate();
        ((TraceRecorderListener)this.getListeners().fire).recordingStopped(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invalidate() {
        this.objectManager.disposeModelListeners();
        DefaultTraceRecorder defaultTraceRecorder = this;
        synchronized (defaultTraceRecorder) {
            if (!this.valid) {
                return;
            }
            this.valid = false;
            this.trace.release((Object)this);
        }
    }

    @Override
    public boolean isSupportsFocus() {
        return this.findFocusScope() != null;
    }

    @Override
    public boolean isSupportsActivation() {
        return this.findActiveScope() != null;
    }

    protected TargetFocusScope findFocusScope() {
        List path = this.target.getModel().getRootSchema().searchForSuitable(TargetFocusScope.class, this.target.getPath());
        if (path == null) {
            return null;
        }
        return (TargetFocusScope)this.target.getModel().getModelObject(path);
    }

    protected TargetActiveScope findActiveScope() {
        List path = this.target.getModel().getRootSchema().searchForSuitable(TargetActiveScope.class, this.target.getPath());
        if (path == null) {
            return null;
        }
        return (TargetActiveScope)this.target.getModel().getModelObject(path);
    }

    @Override
    public TargetObject getFocus() {
        if (this.curFocus == null) {
            TargetFocusScope focusScope = this.findFocusScope();
            if (focusScope == null) {
                return null;
            }
            TargetObject focus = focusScope.getFocus();
            if (focus == null || !PathUtils.isAncestor((List)this.getTarget().getPath(), (List)focus.getPath())) {
                return null;
            }
            this.curFocus = focus;
        }
        return this.curFocus;
    }

    public void setCurrentFocus(TargetObject focused) {
        this.curFocus = focused;
    }

    @Override
    public CompletableFuture<Boolean> requestFocus(TargetObject focus) {
        if (!this.isSupportsFocus()) {
            return CompletableFuture.failedFuture(new IllegalArgumentException("Target does not support focus"));
        }
        if (!PathUtils.isAncestor((List)this.getTarget().getPath(), (List)focus.getPath())) {
            return CompletableFuture.failedFuture(new IllegalArgumentException("Requested focus path is not a successor of the target"));
        }
        TargetFocusScope focusScope = this.findFocusScope();
        if (!PathUtils.isAncestor((List)focusScope.getPath(), (List)focus.getPath())) {
            return CompletableFuture.failedFuture(new IllegalArgumentException("Requested focus path is not a successor of the focus scope"));
        }
        return ((CompletableFuture)focusScope.requestFocus(focus).thenApply(__ -> true)).exceptionally(ex -> {
            ex = AsyncUtils.unwrapThrowable((Throwable)ex);
            String msg = "Could not focus " + focus + ": " + ex.getMessage();
            this.plugin.getTool().setStatusInfo(msg);
            if (ex instanceof DebuggerModelAccessException) {
                Msg.info((Object)this, (Object)msg);
            } else {
                Msg.error((Object)this, (Object)("Could not focus " + focus), (Throwable)ex);
            }
            return false;
        });
    }

    @Override
    public CompletableFuture<Boolean> requestActivation(TargetObject active) {
        if (!this.isSupportsActivation()) {
            return CompletableFuture.failedFuture(new IllegalArgumentException("Target does not support activation"));
        }
        if (!PathUtils.isAncestor((List)this.getTarget().getPath(), (List)active.getPath())) {
            return CompletableFuture.failedFuture(new IllegalArgumentException("Requested activation path is not a successor of the target"));
        }
        TargetActiveScope activeScope = this.findActiveScope();
        if (!PathUtils.isAncestor((List)activeScope.getPath(), (List)active.getPath())) {
            return CompletableFuture.failedFuture(new IllegalArgumentException("Requested activation path is not a successor of the focus scope"));
        }
        return ((CompletableFuture)activeScope.requestActivation(active).thenApply(__ -> true)).exceptionally(ex -> {
            ex = AsyncUtils.unwrapThrowable((Throwable)ex);
            String msg = "Could not activate " + active + ": " + ex.getMessage();
            this.plugin.getTool().setStatusInfo(msg);
            if (ex instanceof DebuggerModelAccessException) {
                Msg.info((Object)this, (Object)msg);
            } else {
                Msg.error((Object)this, (Object)("Could not activate " + active), (Throwable)ex);
            }
            return false;
        });
    }

    @Override
    public TargetObject getTarget() {
        return this.target;
    }

    @Override
    public Trace getTrace() {
        return this.trace;
    }

    public RecorderThreadMap getThreadMap() {
        return this.threadMap;
    }

    public Set<TargetThread> getThreadsView() {
        return this.getThreadMap().byTargetThread.keySet();
    }

    @Override
    public Set<TargetThread> getLiveTargetThreads() {
        return this.getThreadsView();
    }

    public DefaultThreadRecorder getThreadRecorder(TraceThread thread) {
        return (DefaultThreadRecorder)this.getThreadMap().get(thread);
    }

    public ManagedThreadRecorder getThreadRecorder(TargetThread thread) {
        return this.computeIfAbsent(thread);
    }

    public ManagedThreadRecorder getThreadRecorderForSuccessor(TargetObject successor) {
        TargetObject obj;
        for (obj = successor; obj != null && !(obj instanceof TargetThread); obj = obj.getParent()) {
        }
        if (obj == null) {
            return null;
        }
        return this.computeIfAbsent((TargetThread)obj);
    }

    @Override
    public DebuggerMemoryMapper getMemoryMapper() {
        return this.objectManager.getMemoryMapper();
    }

    @Override
    public DebuggerRegisterMapper getRegisterMapper(TraceThread thread) {
        DefaultThreadRecorder rec = this.getThreadRecorder(thread);
        if (rec == null) {
            return null;
        }
        return rec.getRegisterMapper();
    }

    public ListenerSet<TraceRecorderListener> getListeners() {
        return this.objectManager.getListeners();
    }

    @Override
    public void addListener(TraceRecorderListener l) {
        this.getListeners().add((Object)l);
    }

    @Override
    public void removeListener(TraceRecorderListener l) {
        this.getListeners().remove((Object)l);
    }

    public AbstractRecorderMemory getProcessMemory() {
        return this.processRecorder.getProcessMemory();
    }

    @Override
    public AddressSetView getAccessibleMemory() {
        return this.processRecorder.getAccessibleProcessMemory();
    }

    @Override
    public CompletableFuture<byte[]> readMemory(Address start, int length) {
        return this.processRecorder.readProcessMemory(start, length);
    }

    @Override
    public CompletableFuture<Void> writeMemory(Address start, byte[] data) {
        return this.processRecorder.writeProcessMemory(start, data);
    }

    @Override
    public Register isRegisterOnTarget(TracePlatform platform, TraceThread thread, int frameLevel, Register register) {
        Set<Register> onTarget = this.getRegisterMapper(thread).getRegistersOnTarget();
        while (register != null) {
            if (onTarget.contains(register)) {
                return register;
            }
            register = register.getParentRegister();
        }
        return null;
    }

    @Override
    public CompletableFuture<Void> writeThreadRegisters(TracePlatform platform, TraceThread thread, int frameLevel, Map<Register, RegisterValue> values) {
        DefaultThreadRecorder rec = this.getThreadRecorder(thread);
        return rec == null ? null : rec.writeThreadRegisters(frameLevel, values);
    }

    public TraceSnapshot getSnapshot() {
        return this.timeRecorder.getSnapshot();
    }

    public void createSnapshot(String description, TraceThread eventThread, RecorderPermanentTransaction tid) {
        this.timeRecorder.createSnapshot(description, eventThread, tid);
    }

    @Override
    public boolean isRegisterBankAccessible(TargetRegisterBank bank) {
        return true;
    }

    @Override
    public boolean isRegisterBankAccessible(TraceThread thread, int frameLevel) {
        return true;
    }

    @Override
    public CompletableFuture<Void> flushTransactions() {
        return ((CompletableFuture)CompletableFuture.runAsync(() -> {}, this.privateQueue).thenCompose(__ -> this.objectManager.flushEvents())).thenCompose(__ -> this.parTx.flush());
    }
}

