/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.platform.jdi;

import ghidra.app.plugin.core.debug.mapping.AbstractDebuggerPlatformOpinion;
import ghidra.app.plugin.core.debug.mapping.DebuggerPlatformMapper;
import ghidra.app.plugin.core.debug.mapping.DebuggerPlatformOffer;
import ghidra.app.plugin.core.debug.mapping.DefaultDebuggerPlatformMapper;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.Endian;
import ghidra.program.model.lang.LanguageID;
import ghidra.trace.model.Trace;
import ghidra.trace.model.target.TraceObject;
import java.util.Set;

public class JdiDebuggerPlatformOpinion
extends AbstractDebuggerPlatformOpinion {
    protected static final LanguageID LANG_ID_JAVA = new LanguageID("JVM:BE:32:default");
    protected static final LanguageID LANG_ID_DALVIK = new LanguageID("Dalvik:LE:32:default");
    protected static final CompilerSpecID COMP_ID_DEFAULT = new CompilerSpecID("default");

    @Override
    protected Set<DebuggerPlatformOffer> getOffers(TraceObject object, long snap, TraceObject env, String debugger, String arch, String os, Endian endian, boolean includeOverrides) {
        if (debugger == null || arch == null || !debugger.contains("Java Debug Interface")) {
            return Set.of();
        }
        boolean isJava = arch.contains("OpenJDK");
        boolean isDalvik = arch.contains("Dalvik");
        if (isJava) {
            return Set.of(Offers.JAVA_VM);
        }
        if (isDalvik) {
            return Set.of(Offers.DALVIK_VM);
        }
        return Set.of();
    }

    static enum Offers implements DebuggerPlatformOffer
    {
        JAVA_VM("Java Virtual Machine", LANG_ID_JAVA, COMP_ID_DEFAULT),
        DALVIK_VM("Dalvik Virtual Machine", LANG_ID_DALVIK, COMP_ID_DEFAULT);

        final String description;
        final LanguageID langID;
        final CompilerSpecID cSpecID;

        private Offers(String description, LanguageID langID, CompilerSpecID cSpecID) {
            this.description = description;
            this.langID = langID;
            this.cSpecID = cSpecID;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public int getConfidence() {
            return 100;
        }

        @Override
        public CompilerSpec getCompilerSpec() {
            return this.getCompilerSpec(this.langID, this.cSpecID);
        }

        @Override
        public DebuggerPlatformMapper take(PluginTool tool, Trace trace) {
            return new JdiDebuggerPlatformMapper(tool, trace, this.getCompilerSpec());
        }

        @Override
        public boolean isCreatorOf(DebuggerPlatformMapper mapper) {
            return mapper.getClass() == JdiDebuggerPlatformMapper.class;
        }
    }

    protected static class JdiDebuggerPlatformMapper
    extends DefaultDebuggerPlatformMapper {
        public JdiDebuggerPlatformMapper(PluginTool tool, Trace trace, CompilerSpec cSpec) {
            super(tool, trace, cSpec);
        }
    }
}

