/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.thread;

import docking.ComponentProvider;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.RangeCursorTableHeaderRenderer;
import docking.widgets.table.TableColumnDescriptor;
import docking.widgets.table.threaded.ThreadedTableModelListener;
import ghidra.app.plugin.core.debug.DebuggerCoordinates;
import ghidra.app.plugin.core.debug.gui.model.AbstractObjectsTableBasedPanel;
import ghidra.app.plugin.core.debug.gui.model.ModelQuery;
import ghidra.app.plugin.core.debug.gui.model.ObjectTableModel;
import ghidra.app.plugin.core.debug.gui.model.columns.TraceValueKeyColumn;
import ghidra.app.plugin.core.debug.gui.model.columns.TraceValueLifePlotColumn;
import ghidra.app.plugin.core.debug.gui.model.columns.TraceValueObjectAttributeColumn;
import ghidra.app.plugin.core.debug.gui.model.columns.TraceValueObjectEditableAttributeColumn;
import ghidra.app.plugin.core.debug.gui.model.columns.TraceValueObjectPropertyColumn;
import ghidra.app.plugin.core.debug.gui.model.columns.TraceValueValColumn;
import ghidra.app.plugin.core.debug.gui.thread.DebuggerThreadsProvider;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.dbg.target.TargetProcess;
import ghidra.dbg.target.TargetThread;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.util.PathPredicates;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.TraceObjectValue;
import ghidra.trace.model.thread.TraceObjectThread;
import java.util.List;
import javax.swing.JTable;

public class DebuggerThreadsPanel
extends AbstractObjectsTableBasedPanel<TraceObjectThread> {
    @AutoServiceConsumed
    protected DebuggerTraceManagerService traceManager;
    private final RangeCursorTableHeaderRenderer.SeekListener seekListener = pos -> {
        long snap = Math.round(pos);
        if (this.current.getTrace() == null || snap < 0L) {
            snap = 0L;
        }
        this.traceManager.activateSnap(snap);
    };

    protected static ModelQuery successorThreads(TargetObjectSchema rootSchema, List<String> path) {
        TargetObjectSchema schema = rootSchema.getSuccessorSchema(path);
        return new ModelQuery((PathPredicates)schema.searchFor(TargetThread.class, path, true));
    }

    public DebuggerThreadsPanel(DebuggerThreadsProvider provider) {
        super(provider.plugin, (ComponentProvider)provider, TraceObjectThread.class);
        this.setLimitToSnap(false);
        this.addSeekListener(this.seekListener);
        ((ObjectTableModel)this.tableModel).addThreadedTableModelListener(new ThreadedTableModelListener(){

            public void loadingStarted() {
            }

            public void loadingFinished(boolean wasCancelled) {
                DebuggerThreadsPanel.this.trySelectCurrentThread();
            }

            public void loadPending() {
            }
        });
    }

    @Override
    protected ObjectTableModel createModel(Plugin plugin) {
        return new ThreadTableModel(plugin);
    }

    @Override
    protected ModelQuery computeQuery(TraceObject object) {
        List seedPath;
        TargetObjectSchema rootSchema = object.getRoot().getTargetSchema();
        List processPath = rootSchema.searchForAncestor(TargetProcess.class, seedPath = object.getCanonicalPath().getKeyList());
        if (processPath != null) {
            return DebuggerThreadsPanel.successorThreads(rootSchema, processPath);
        }
        List containerPath = rootSchema.searchForSuitableContainer(TargetThread.class, seedPath);
        if (containerPath != null) {
            return DebuggerThreadsPanel.successorThreads(rootSchema, containerPath);
        }
        return DebuggerThreadsPanel.successorThreads(rootSchema, List.of());
    }

    private void trySelectCurrentThread() {
        TraceObject object = this.current.getObject();
        if (object == null) {
            return;
        }
        this.trySelectAncestor(object);
    }

    @Override
    public void coordinatesActivated(DebuggerCoordinates coordinates) {
        super.coordinatesActivated(coordinates);
        this.trySelectCurrentThread();
    }

    @Override
    public void cellActivated(JTable table) {
        ObjectTableModel.ValueRow item = (ObjectTableModel.ValueRow)this.getSelectedItem();
        if (item != null) {
            this.traceManager.activateObject(item.getValue().getChild());
        }
    }

    private static class ThreadTableModel
    extends ObjectTableModel {
        protected ThreadTableModel(Plugin plugin) {
            super(plugin);
        }

        @Override
        protected TableColumnDescriptor<ObjectTableModel.ValueRow> createTableColumnDescriptor() {
            TableColumnDescriptor descriptor = new TableColumnDescriptor();
            descriptor.addHiddenColumn((DynamicTableColumn)new ThreadPathColumn());
            descriptor.addVisibleColumn((DynamicTableColumn)new ThreadNameColumn(), 1, true);
            descriptor.addVisibleColumn((DynamicTableColumn)new ThreadCreatedColumn());
            descriptor.addVisibleColumn((DynamicTableColumn)new ThreadDestroyedColumn());
            descriptor.addVisibleColumn((DynamicTableColumn)new ThreadStateColumn());
            descriptor.addVisibleColumn((DynamicTableColumn)new ThreadCommentColumn());
            descriptor.addVisibleColumn((DynamicTableColumn)new ThreadPlotColumn());
            return descriptor;
        }
    }

    private static class ThreadPlotColumn
    extends TraceValueLifePlotColumn {
        private ThreadPlotColumn() {
        }
    }

    private static class ThreadCommentColumn
    extends TraceValueObjectEditableAttributeColumn<String> {
        public ThreadCommentColumn() {
            super("_comment", String.class);
        }

        @Override
        public String getColumnName() {
            return "Comment";
        }
    }

    private static class ThreadStateColumn
    extends TraceValueObjectAttributeColumn<String> {
        public ThreadStateColumn() {
            super("_state", String.class);
        }

        @Override
        public String getColumnName() {
            return "State";
        }
    }

    private static class ThreadDestroyedColumn
    extends AbstractThreadLifeBoundColumn {
        private ThreadDestroyedColumn() {
        }

        public String getColumnName() {
            return "Destroyed";
        }

        @Override
        Long fromLifespan(Lifespan lifespan) {
            return lifespan.maxIsFinite() ? Long.valueOf(lifespan.lmax()) : null;
        }
    }

    private static class ThreadCreatedColumn
    extends AbstractThreadLifeBoundColumn {
        private ThreadCreatedColumn() {
        }

        public String getColumnName() {
            return "Created";
        }

        @Override
        Long fromLifespan(Lifespan lifespan) {
            return lifespan.minIsFinite() ? Long.valueOf(lifespan.lmin()) : null;
        }
    }

    private static abstract class AbstractThreadLifeBoundColumn
    extends TraceValueObjectPropertyColumn<Long> {
        public AbstractThreadLifeBoundColumn() {
            super(Long.class);
        }

        abstract Long fromLifespan(Lifespan var1);

        @Override
        public ObjectTableModel.ValueProperty<Long> getProperty(ObjectTableModel.ValueRow row) {
            return new ObjectTableModel.ValueDerivedProperty<Long>(row, Long.class){

                @Override
                public Long getValue() {
                    TraceObjectValue curVal = this.row.getValue().getChild().getCanonicalParent(this.row.currentSnap());
                    if (curVal == null) {
                        return null;
                    }
                    return this.fromLifespan(curVal.getLifespan());
                }
            };
        }
    }

    private static class ThreadNameColumn
    extends TraceValueValColumn {
        private ThreadNameColumn() {
        }

        @Override
        public String getColumnName() {
            return "Name";
        }
    }

    private static class ThreadPathColumn
    extends TraceValueKeyColumn {
        private ThreadPathColumn() {
        }

        @Override
        public String getColumnName() {
            return "Path";
        }

        @Override
        public String getValue(ObjectTableModel.ValueRow rowObject, Settings settings, Trace data, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return rowObject.getValue().getCanonicalPath().toString();
        }
    }
}

