/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.objects.components;

import docking.widgets.table.GTableCellRenderingData;
import ghidra.app.plugin.core.debug.gui.objects.DebuggerObjectsProvider;
import ghidra.app.plugin.core.debug.gui.objects.components.ObjectAttributeRow;
import ghidra.app.plugin.core.debug.gui.objects.components.ObjectElementRow;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.util.PathUtils;
import ghidra.docking.settings.Settings;
import ghidra.util.table.column.AbstractGhidraColumnRenderer;
import java.awt.Component;
import java.util.List;

public class ObjectTableCellRenderer
extends AbstractGhidraColumnRenderer<Object> {
    private final DebuggerObjectsProvider provider;

    public ObjectTableCellRenderer(DebuggerObjectsProvider provider) {
        this.provider = provider;
    }

    public String getFilterString(Object t, Settings settings) {
        return t == null ? "<null>" : t.toString();
    }

    public Component getTableCellRendererComponent(GTableCellRenderingData data) {
        TargetObject object;
        super.getTableCellRendererComponent(data);
        TargetObject focus = this.provider.getFocus();
        if (focus == null) {
            return this;
        }
        Object rowObject = data.getRowObject();
        if (rowObject instanceof ObjectElementRow) {
            ObjectElementRow eRow = (ObjectElementRow)rowObject;
            object = eRow.getTargetObject();
        } else if (rowObject instanceof ObjectAttributeRow) {
            ObjectAttributeRow aRow = (ObjectAttributeRow)rowObject;
            object = aRow.getTargetObject();
        } else {
            return this;
        }
        if (PathUtils.isAncestor((List)object.getPath(), (List)focus.getPath())) {
            this.setBold();
        }
        return this;
    }
}

