/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.objects.components;

import ghidra.async.AsyncUtils;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.target.TargetObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;

public class DummyTargetObject
implements TargetObject {
    private static final String PATH_SEPARATOR_STRING = ".";
    private final DebuggerObjectModel model;
    private final String joinedPath;
    final List<String> path;
    final int hash;
    private final Map<String, Object> attributes = new LinkedHashMap<String, Object>();
    private final Map<String, TargetObject> elements = new LinkedHashMap<String, TargetObject>();
    private TargetObject parent;
    private final String kind;
    private final Object value;
    private final String type;
    private final String key;

    public DummyTargetObject(DebuggerObjectModel model, String root, List<String> path) {
        this(model, path, "", (Object)"", "");
    }

    public DummyTargetObject(DebuggerObjectModel model, List<String> path, String kind, Object value, String type) {
        this.model = model;
        this.joinedPath = StringUtils.join(path, (String)PATH_SEPARATOR_STRING);
        this.path = path;
        this.kind = kind;
        this.value = value;
        this.type = type;
        this.key = path.size() > 0 ? path.get(path.size() - 1) : "";
        this.hash = this.computeHashCode();
    }

    public DummyTargetObject(String key, List<String> path, String kind, Object value, String type, List<TargetObject> objects) {
        this.model = null;
        this.joinedPath = StringUtils.join(path, (String)PATH_SEPARATOR_STRING);
        this.path = path;
        this.kind = kind;
        this.value = value;
        this.type = type;
        this.key = path.size() > 0 ? path.get(path.size() - 1) : "";
        this.hash = this.computeHashCode();
        if (objects != null) {
            for (TargetObject obj : objects) {
                this.addObject(obj);
            }
        }
    }

    public DummyTargetObject(TargetObject parent, List<String> path, String kind, Object value, String type) {
        this.parent = parent;
        this.model = parent.getModel();
        this.joinedPath = StringUtils.join(path, (String)PATH_SEPARATOR_STRING);
        this.path = path;
        this.kind = kind;
        this.value = value;
        this.type = type;
        this.key = path.size() > 0 ? path.get(path.size() - 1) : "";
        this.hash = this.computeHashCode();
        if (!(parent instanceof DummyTargetObject)) {
            this.fetchAttributes();
        }
    }

    public boolean equals(Object obj) {
        return this.doEquals(obj);
    }

    public int hashCode() {
        return this.hash;
    }

    public TargetObject getParent() {
        return this.parent;
    }

    public void addObject(TargetObject obj) {
        String name = obj.getName();
        if (name.contains("[")) {
            this.elements.put(name, obj);
        } else {
            this.attributes.put(name, obj);
        }
    }

    public void addAttribute(String name, Object val) {
        this.attributes.put(name, val);
    }

    public void setParent(TargetObject parent) {
        this.parent = parent;
    }

    public DebuggerObjectModel getModel() {
        return this.model;
    }

    public String getName() {
        if (this.path == null) {
            return "";
        }
        String ret = this.path.get(this.path.size() - 1);
        if (ret.endsWith("]")) {
            ret = ret.substring(ret.indexOf("["));
        }
        return ret;
    }

    public Object getProtocolID() {
        return this.path;
    }

    public List<String> getPath() {
        return this.path;
    }

    public String getTypeHint() {
        return this.kind;
    }

    public CompletableFuture<Void> resync(DebuggerObjectModel.RefreshBehavior attributes, DebuggerObjectModel.RefreshBehavior elements) {
        return AsyncUtils.NIL;
    }

    public CompletableFuture<? extends Map<String, ? extends TargetObject>> fetchElements() {
        return CompletableFuture.supplyAsync(() -> this.elements);
    }

    public Map<String, ? extends TargetObject> getCachedElements() {
        return this.elements;
    }

    public Map<String, ? extends TargetObject> getCallbackElements() {
        return this.elements;
    }

    public CompletableFuture<? extends Map<String, ?>> fetchAttributes() {
        if (!this.key.equals("_display")) {
            if (this.getValue() != null) {
                String display = this.getName() + " : " + this.getValue();
                this.addAttribute("_display", display);
            }
            if (this.kind != null && !this.kind.equals("")) {
                this.addAttribute("_kind", this.kind);
            } else {
                this.addAttribute("_kind", "OBJECT_INTRINSIC");
            }
            if (this.getValue() != null) {
                this.addAttribute("_value", this.getValue());
            }
            if (this.type != null) {
                this.addAttribute("_type", this.type);
            }
        }
        return CompletableFuture.supplyAsync(() -> this.attributes);
    }

    public Map<String, ?> getCachedAttributes() {
        return this.attributes;
    }

    public Map<String, ?> getCallbackAttributes() {
        return this.attributes;
    }

    public String getJoinedPath() {
        return this.joinedPath;
    }

    public boolean isValid() {
        return true;
    }

    public String toString() {
        return this.getName();
    }

    public Object getValue() {
        return this.value;
    }
}

