/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.objects.actions;

import docking.ActionContext;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.widgets.filechooser.GhidraFileChooserMode;
import generic.theme.GIcon;
import ghidra.app.plugin.core.debug.gui.objects.DebuggerObjectsProvider;
import ghidra.app.plugin.core.debug.gui.objects.ObjectContainer;
import ghidra.app.plugin.core.debug.gui.objects.actions.ExportAsFactsAction;
import ghidra.app.plugin.core.debug.gui.objects.actions.ImportExportAsAction;
import ghidra.app.plugin.core.debug.gui.objects.components.DummyTargetObject;
import ghidra.dbg.target.TargetObject;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.SwingUtilities;

public class ImportFromFactsAction
extends ImportExportAsAction {
    protected static final Icon ICON_FACTS = new GIcon("icon.debugger.display.import.facts");
    private Map<String, Map<String, String>> maps = new LinkedHashMap<String, Map<String, String>>();

    public ImportFromFactsAction(PluginTool tool, String owner, DebuggerObjectsProvider provider) {
        super("ImportFromFacts", tool, owner, provider);
        this.fileExt = "";
        this.fileMode = GhidraFileChooserMode.DIRECTORIES_ONLY;
        this.setMenuBarData(new MenuData(new String[]{this.IMPORT, "from facts"}, ICON_FACTS, this.GROUP));
        this.setKeyBindingData(new KeyBindingData(70, 512));
        this.setHelpLocation(new HelpLocation(owner, "import_from_facts"));
        provider.addLocalAction((DockingActionIf)this);
    }

    @Override
    public boolean isEnabledForContext(ActionContext context) {
        return true;
    }

    @Override
    protected void doAction(ObjectContainer container, final File dir) {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - void declaration
             */
            @Override
            public void run() {
                try {
                    void var6_15;
                    ObjectContainer cp = new ObjectContainer(null, null);
                    DebuggerObjectsProvider p = new DebuggerObjectsProvider(ImportFromFactsAction.this.provider.getPlugin(), ImportFromFactsAction.this.provider.getModel(), cp, true);
                    cp.propagateProvider(p);
                    p.update(cp);
                    if (!dir.isDirectory()) {
                        return;
                    }
                    for (File file : dir.listFiles()) {
                        Object line;
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
                        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                        String name = file.getName();
                        name = name.substring(0, name.indexOf(ExportAsFactsAction.fileExt2));
                        ImportFromFactsAction.this.maps.put(name, map);
                        while (null != (line = bufferedReader.readLine())) {
                            String[] split = ((String)line).split(ExportAsFactsAction.SEP);
                            if (split.length == 2) {
                                map.put(split[0], split[1]);
                                continue;
                            }
                            map.put(split[0], "");
                        }
                        bufferedReader.close();
                    }
                    LinkedHashMap<String, DummyTargetObject> objMap = new LinkedHashMap<String, DummyTargetObject>();
                    Map<String, String> map = ImportFromFactsAction.this.maps.get("ObjectPath");
                    for (String string : map.keySet()) {
                        String string2 = map.get(string);
                        String[] split = string2.split(ExportAsFactsAction.SPLIT);
                        ArrayList<String> path = new ArrayList<String>();
                        for (String s : split) {
                            path.add(s);
                        }
                        String name = ImportFromFactsAction.this.maps.get("ObjectName").get(string);
                        String value = ImportFromFactsAction.this.maps.get("ObjectValue").get(string);
                        String kind = ImportFromFactsAction.this.maps.get("ObjectType").get(string);
                        DummyTargetObject to = new DummyTargetObject(ImportFromFactsAction.this.convertName(name), path, kind, value, "", null);
                        objMap.put(string, to);
                    }
                    Map<String, String> cmap = ImportFromFactsAction.this.maps.get("ObjectChildren");
                    for (String string : cmap.keySet()) {
                        String cid = cmap.get(string);
                        String pkey = string.substring(0, string.indexOf(":"));
                        DummyTargetObject to = (DummyTargetObject)objMap.get(pkey);
                        DummyTargetObject cto = (DummyTargetObject)objMap.get(cid);
                        to.addObject(cto);
                        cto.setParent(to);
                    }
                    Object var6_13 = null;
                    for (DummyTargetObject to : objMap.values()) {
                        if (to.getParent() != null) continue;
                        DummyTargetObject dummyTargetObject = to;
                        break;
                    }
                    if (var6_15 != null) {
                        ObjectContainer objectContainer = p.getRoot();
                        objectContainer.setTargetObject((TargetObject)var6_15);
                        ImportFromFactsAction.this.provider.update(objectContainer);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Msg.showError((Object)this, (Component)ImportFromFactsAction.this.provider.getComponent(), (String)"Load Failed", (Object)e);
                }
            }
        });
    }

    private String convertName(String name) {
        return name.contains("_0x") ? "[" + name.substring(name.indexOf("_") + 1) + "]" : name;
    }
}

