/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.model;

import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.RangeCursorTableHeaderRenderer;
import docking.widgets.table.TableColumnDescriptor;
import generic.Span;
import ghidra.app.plugin.core.debug.gui.model.AbstractQueryTableModel;
import ghidra.app.plugin.core.debug.gui.model.ModelQuery;
import ghidra.app.plugin.core.debug.gui.model.columns.EditableColumn;
import ghidra.app.plugin.core.debug.gui.model.columns.TraceValueKeyColumn;
import ghidra.app.plugin.core.debug.gui.model.columns.TraceValueLifeColumn;
import ghidra.app.plugin.core.debug.gui.model.columns.TraceValueLifePlotColumn;
import ghidra.app.plugin.core.debug.gui.model.columns.TraceValueObjectAttributeColumn;
import ghidra.app.plugin.core.debug.gui.model.columns.TraceValueValColumn;
import ghidra.dbg.target.schema.SchemaContext;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.TraceObjectValue;
import ghidra.util.HTMLUtilities;
import java.awt.Color;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ObjectTableModel
extends AbstractQueryTableModel<ValueRow> {
    private Map<ColKey, TraceValueObjectAttributeColumn<?>> columnCache = new HashMap();

    protected static Stream<? extends TraceObjectValue> distinctCanonical(Stream<? extends TraceObjectValue> stream) {
        HashSet seen = new HashSet();
        return stream.filter(value -> {
            if (!value.isCanonical()) {
                return true;
            }
            return seen.add(value.getChild());
        });
    }

    protected ValueRow rowForValue(TraceObjectValue value) {
        if (value.getValue() instanceof TraceObject) {
            return new ObjectRow(value);
        }
        return new PrimitiveRow(value);
    }

    protected ObjectTableModel(Plugin plugin) {
        super("Object Model", plugin);
    }

    @Override
    protected void traceChanged() {
        this.reloadAttributeColumns();
        this.updateTimelineMax();
        super.traceChanged();
    }

    @Override
    protected void queryChanged() {
        this.reloadAttributeColumns();
        super.queryChanged();
    }

    @Override
    protected void showHiddenChanged() {
        this.reloadAttributeColumns();
        super.showHiddenChanged();
    }

    @Override
    protected void maxSnapChanged() {
        this.updateTimelineMax();
        this.refresh();
    }

    protected void updateTimelineMax() {
        Long max = this.getTrace() == null ? null : this.getTrace().getTimeManager().getMaxSnap();
        Lifespan fullRange = Lifespan.span((long)0L, (long)(max == null ? 1L : max + 1L));
        int count = this.getColumnCount();
        for (int i = 0; i < count; ++i) {
            DynamicTableColumn column = this.getColumn(i);
            if (!(column instanceof TraceValueLifePlotColumn)) continue;
            TraceValueLifePlotColumn plotCol = (TraceValueLifePlotColumn)column;
            plotCol.setFullRange(fullRange);
        }
    }

    protected List<TargetObjectSchema.AttributeSchema> computeAttributeSchemas() {
        Trace trace = this.getTrace();
        ModelQuery query = this.getQuery();
        if (trace == null || query == null) {
            return List.of();
        }
        TargetObjectSchema rootSchema = trace.getObjectManager().getRootSchema();
        if (rootSchema == null) {
            return List.of();
        }
        SchemaContext ctx = rootSchema.getContext();
        return query.computeAttributes(trace).filter(a -> this.isShowHidden() || !a.isHidden()).filter(a -> !ctx.getSchema(a.getSchema()).isCanonicalContainer()).collect(Collectors.toList());
    }

    protected void reloadAttributeColumns() {
        List<Object> attributes;
        Trace trace = this.getTrace();
        ModelQuery query = this.getQuery();
        if (trace == null || query == null || trace.getObjectManager().getRootSchema() == null) {
            attributes = List.of();
        } else {
            SchemaContext ctx = trace.getObjectManager().getRootSchema().getContext();
            attributes = query.computeAttributes(trace).filter(a -> !ctx.getSchema(a.getSchema()).isCanonicalContainer()).collect(Collectors.toList());
        }
        this.resyncAttributeColumns(attributes);
    }

    protected Set<DynamicTableColumn<ValueRow, ?, ?>> computeAttributeColumns(Collection<TargetObjectSchema.AttributeSchema> attributes) {
        if (attributes == null) {
            return Set.of();
        }
        Trace trace = this.getTrace();
        if (trace == null) {
            return Set.of();
        }
        TargetObjectSchema rootSchema = trace.getObjectManager().getRootSchema();
        if (rootSchema == null) {
            return Set.of();
        }
        SchemaContext ctx = rootSchema.getContext();
        return attributes.stream().map(as -> this.columnCache.computeIfAbsent(ColKey.fromSchema(ctx, as), ck -> AutoAttributeColumn.fromSchema(ctx, as))).collect(Collectors.toSet());
    }

    protected void resyncAttributeColumns(Collection<TargetObjectSchema.AttributeSchema> attributes) {
        Map byVisible = attributes == null ? Map.of() : attributes.stream().collect(Collectors.groupingBy(a -> !a.isHidden() || this.isShowHidden()));
        HashSet visibleColumns = new HashSet(this.computeAttributeColumns((Collection)byVisible.get(true)));
        HashSet hiddenColumns = new HashSet(this.computeAttributeColumns((Collection)byVisible.get(false)));
        HashSet<DynamicTableColumn> toRemove = new HashSet<DynamicTableColumn>();
        for (int i = 0; i < this.getColumnCount(); ++i) {
            DynamicTableColumn exists = this.getColumn(i);
            if (!(exists instanceof AutoAttributeColumn) || visibleColumns.remove(exists) || hiddenColumns.remove(exists)) continue;
            toRemove.add(exists);
        }
        this.removeTableColumns(toRemove);
        this.addTableColumns(visibleColumns, true);
        this.addTableColumns(hiddenColumns, false);
    }

    @Override
    protected Stream<ValueRow> streamRows(Trace trace, ModelQuery query, Lifespan span) {
        return ObjectTableModel.distinctCanonical(query.streamValues(trace, span).filter(v -> this.isShowHidden() || !v.isHidden())).map(this::rowForValue);
    }

    protected TableColumnDescriptor<ValueRow> createTableColumnDescriptor() {
        TableColumnDescriptor descriptor = new TableColumnDescriptor();
        descriptor.addVisibleColumn((DynamicTableColumn)new TraceValueKeyColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new TraceValueValColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new TraceValueLifeColumn());
        descriptor.addHiddenColumn((DynamicTableColumn)new TraceValueLifePlotColumn());
        return descriptor;
    }

    @Override
    public ValueRow findTraceObject(TraceObject object) {
        for (ValueRow row : this.getModelData()) {
            if (row.getValue().getValue() != object || !row.getValue().isCanonical()) continue;
            return row;
        }
        return null;
    }

    public ValueRow findTraceObjectAncestor(TraceObject successor) {
        for (ValueRow row : this.getModelData()) {
            TraceObjectValue value = row.getValue();
            if (!value.isObject() || !value.getChild().getCanonicalPath().isAncestor(successor.getCanonicalPath())) continue;
            return row;
        }
        return null;
    }

    @Override
    public void setDiffColor(Color diffColor) {
        int count = this.getColumnCount();
        for (int i = 0; i < count; ++i) {
            DynamicTableColumn dynamicTableColumn = this.getColumn(i);
            if (dynamicTableColumn instanceof TraceValueObjectAttributeColumn) {
                TraceValueObjectAttributeColumn attrCol = (TraceValueObjectAttributeColumn)dynamicTableColumn;
                attrCol.setDiffColor(diffColor);
                continue;
            }
            if (!(dynamicTableColumn instanceof TraceValueValColumn)) continue;
            TraceValueValColumn valCol = (TraceValueValColumn)dynamicTableColumn;
            valCol.setDiffColor(diffColor);
        }
        for (TraceValueObjectAttributeColumn<?> traceValueObjectAttributeColumn : this.columnCache.values()) {
            traceValueObjectAttributeColumn.setDiffColor(diffColor);
        }
    }

    @Override
    public void setDiffColorSel(Color diffColorSel) {
        int count = this.getColumnCount();
        for (int i = 0; i < count; ++i) {
            DynamicTableColumn dynamicTableColumn = this.getColumn(i);
            if (dynamicTableColumn instanceof TraceValueObjectAttributeColumn) {
                TraceValueObjectAttributeColumn attrCol = (TraceValueObjectAttributeColumn)dynamicTableColumn;
                attrCol.setDiffColorSel(diffColorSel);
                continue;
            }
            if (!(dynamicTableColumn instanceof TraceValueValColumn)) continue;
            TraceValueValColumn valCol = (TraceValueValColumn)dynamicTableColumn;
            valCol.setDiffColorSel(diffColorSel);
        }
        for (TraceValueObjectAttributeColumn<?> traceValueObjectAttributeColumn : this.columnCache.values()) {
            traceValueObjectAttributeColumn.setDiffColorSel(diffColorSel);
        }
    }

    @Override
    protected void snapChanged() {
        super.snapChanged();
        long snap = this.getSnap();
        int count = this.getColumnCount();
        for (int i = 0; i < count; ++i) {
            DynamicTableColumn column = this.getColumn(i);
            if (!(column instanceof TraceValueLifePlotColumn)) continue;
            TraceValueLifePlotColumn plotCol = (TraceValueLifePlotColumn)column;
            plotCol.setSnap(snap);
        }
    }

    @Override
    public void addSeekListener(RangeCursorTableHeaderRenderer.SeekListener listener) {
        int count = this.getColumnCount();
        for (int i = 0; i < count; ++i) {
            DynamicTableColumn column = this.getColumn(i);
            if (!(column instanceof TraceValueLifePlotColumn)) continue;
            TraceValueLifePlotColumn plotCol = (TraceValueLifePlotColumn)column;
            plotCol.addSeekListener(listener);
        }
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        this.initializeSorting();
        List modelData = this.getModelData();
        if (rowIndex < 0 || rowIndex >= modelData.size()) {
            return false;
        }
        ValueRow t = (ValueRow)modelData.get(rowIndex);
        return this.isColumnEditableForRow(t, columnIndex);
    }

    public final boolean isColumnEditableForRow(ValueRow t, int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this.tableColumns.size()) {
            return false;
        }
        Trace dataSource = this.getDataSource();
        DynamicTableColumn column = (DynamicTableColumn)this.tableColumns.get(columnIndex);
        if (!(column instanceof EditableColumn)) {
            return false;
        }
        EditableColumn editable = (EditableColumn)column;
        return editable.isEditable(t, (Settings)this.columnSettings.get(column), dataSource, this.serviceProvider);
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.initializeSorting();
        List modelData = this.getModelData();
        if (rowIndex < 0 || rowIndex >= modelData.size()) {
            return;
        }
        ValueRow t = (ValueRow)modelData.get(rowIndex);
        this.setColumnValueForRow(t, aValue, columnIndex);
    }

    public void setColumnValueForRow(ValueRow t, Object aValue, int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this.tableColumns.size()) {
            return;
        }
        Trace dataSource = this.getDataSource();
        DynamicTableColumn column = (DynamicTableColumn)this.tableColumns.get(columnIndex);
        if (!(column instanceof EditableColumn)) {
            return;
        }
        EditableColumn editable = (EditableColumn)column;
        Settings settings = (Settings)this.columnSettings.get(column);
        if (!editable.isEditable(t, settings, dataSource, this.serviceProvider)) {
            return;
        }
        ObjectTableModel.doSetValue(editable, t, aValue, settings, dataSource, this.serviceProvider);
    }

    private static <ROW_TYPE, COLUMN_TYPE, DATA_SOURCE> void doSetValue(EditableColumn<ROW_TYPE, COLUMN_TYPE, DATA_SOURCE> editable, ROW_TYPE t, Object aValue, Settings settings, DATA_SOURCE dataSource, ServiceProvider serviceProvider) {
        editable.setValue(t, aValue, settings, dataSource, serviceProvider);
    }

    protected class ObjectRow
    extends AbstractValueRow {
        private final TraceObject object;

        public ObjectRow(TraceObjectValue value) {
            super(value);
            this.object = value.getChild();
        }

        public TraceObject getTraceObject() {
            return this.object;
        }

        @Override
        public String getDisplay() {
            return ObjectTableModel.this.display.getEdgeDisplay(this.value);
        }

        @Override
        public String getHtmlDisplay() {
            return ObjectTableModel.this.display.getEdgeHtmlDisplay(this.value);
        }

        @Override
        public String getToolTip() {
            return ObjectTableModel.this.display.getEdgeToolTip(this.value);
        }

        @Override
        public TraceObjectValue getAttributeEntry(String attributeName) {
            return this.object.getAttribute(ObjectTableModel.this.getSnap(), attributeName);
        }

        @Override
        public String getAttributeDisplay(String attributeName) {
            return ObjectTableModel.this.display.getEdgeDisplay(this.getAttributeEntry(attributeName));
        }

        @Override
        public String getAttributeHtmlDisplay(String attributeName) {
            return ObjectTableModel.this.display.getEdgeHtmlDisplay(this.getAttributeEntry(attributeName));
        }

        @Override
        public String getAttributeToolTip(String attributeName) {
            return ObjectTableModel.this.display.getEdgeToolTip(this.getAttributeEntry(attributeName));
        }

        @Override
        public boolean isAttributeModified(String attributeName) {
            return ObjectTableModel.this.isValueModified(this.getAttributeEntry(attributeName));
        }

        @Override
        public boolean isCurrent() {
            TraceObject current = ObjectTableModel.this.getCurrentObject();
            if (current == null) {
                return false;
            }
            return this.object.getCanonicalPath().isAncestor(current.getCanonicalPath());
        }
    }

    protected class PrimitiveRow
    extends AbstractValueRow {
        public PrimitiveRow(TraceObjectValue value) {
            super(value);
        }

        @Override
        public String getDisplay() {
            return ObjectTableModel.this.display.getPrimitiveValueDisplay(this.value.getValue());
        }

        @Override
        public String getHtmlDisplay() {
            return "<html>" + HTMLUtilities.escapeHTML((String)ObjectTableModel.this.display.getPrimitiveValueDisplay(this.value.getValue()));
        }

        @Override
        public String getToolTip() {
            return ObjectTableModel.this.display.getPrimitiveEdgeToolTip(this.value);
        }

        @Override
        public TraceObjectValue getAttributeEntry(String attributeName) {
            return null;
        }

        @Override
        public String getAttributeDisplay(String attributeName) {
            return null;
        }

        @Override
        public String getAttributeHtmlDisplay(String attributeName) {
            return null;
        }

        @Override
        public String getAttributeToolTip(String attributeName) {
            return null;
        }

        @Override
        public boolean isAttributeModified(String attributeName) {
            return false;
        }

        @Override
        public boolean isCurrent() {
            return false;
        }
    }

    static class AutoAttributeColumn<T>
    extends TraceValueObjectAttributeColumn<T> {
        public static TraceValueObjectAttributeColumn<?> fromSchema(SchemaContext ctx, TargetObjectSchema.AttributeSchema attributeSchema) {
            String name = attributeSchema.getName();
            Class<?> type = AutoAttributeColumn.computeAttributeType(ctx, attributeSchema);
            return new AutoAttributeColumn(name, type);
        }

        public AutoAttributeColumn(String attributeName, Class<T> attributeType) {
            super(attributeName, attributeType);
        }
    }

    public static interface ValueRow {
        public String getKey();

        public TraceObject currentObject();

        public long currentSnap();

        public long previousSnap();

        public Lifespan.LifeSet getLife();

        public TraceObjectValue getValue();

        public String getDisplay();

        public String getHtmlDisplay();

        public String getToolTip();

        public boolean isModified();

        public boolean isCurrent();

        default public <T> ValueAttribute<T> getAttribute(String attributeName, Class<T> type) {
            return new ValueAttribute<T>(this, attributeName, type);
        }

        public TraceObjectValue getAttributeEntry(String var1);

        public String getAttributeDisplay(String var1);

        public String getAttributeHtmlDisplay(String var1);

        public String getAttributeToolTip(String var1);

        public boolean isAttributeModified(String var1);
    }

    protected record ColKey(String name, Class<?> type) {
        public static ColKey fromSchema(SchemaContext ctx, TargetObjectSchema.AttributeSchema attributeSchema) {
            String name = attributeSchema.getName();
            Class<?> type = TraceValueObjectAttributeColumn.computeAttributeType(ctx, attributeSchema);
            return new ColKey(name, type);
        }
    }

    protected abstract class AbstractValueRow
    implements ValueRow {
        protected final TraceObjectValue value;

        public AbstractValueRow(TraceObjectValue value) {
            this.value = value;
        }

        @Override
        public TraceObjectValue getValue() {
            return this.value;
        }

        @Override
        public String getKey() {
            return this.value.getEntryKey();
        }

        @Override
        public long currentSnap() {
            return ObjectTableModel.this.getSnap();
        }

        @Override
        public TraceObject currentObject() {
            return ObjectTableModel.this.getCurrentObject();
        }

        @Override
        public long previousSnap() {
            return ObjectTableModel.this.getTrace() == ObjectTableModel.this.getDiffTrace() ? ObjectTableModel.this.getDiffSnap() : ObjectTableModel.this.getSnap();
        }

        @Override
        public Lifespan.LifeSet getLife() {
            Lifespan.DefaultLifeSet life = new Lifespan.DefaultLifeSet();
            life.add((Span)this.value.getLifespan());
            return life;
        }

        @Override
        public boolean isModified() {
            return ObjectTableModel.this.isValueModified(this.getValue());
        }
    }

    public record ValueAttribute<T>(ValueRow row, String name, Class<T> type) implements ValueProperty<T>
    {
        public TraceObjectValue getEntry() {
            return this.row.getAttributeEntry(this.name);
        }

        @Override
        public ValueRow getRow() {
            return this.row;
        }

        @Override
        public Class<T> getType() {
            return this.type;
        }

        @Override
        public T getValue() {
            TraceObjectValue entry = this.row.getAttributeEntry(this.name);
            return entry == null || !this.type.isInstance(entry.getValue()) ? null : (T)this.type.cast(entry.getValue());
        }

        @Override
        public String getDisplay() {
            return this.row.getAttributeDisplay(this.name);
        }

        @Override
        public String getHtmlDisplay() {
            return this.row.getAttributeHtmlDisplay(this.name);
        }

        @Override
        public String getToolTip() {
            return this.row.getAttributeToolTip(this.name);
        }

        @Override
        public boolean isModified() {
            return this.row.isAttributeModified(this.name);
        }
    }

    public static abstract class ValueAddressProperty
    extends ValueDerivedProperty<Address> {
        public ValueAddressProperty(ValueRow row) {
            super(row, Address.class);
        }

        @Override
        public String getHtmlDisplay() {
            Address value = (Address)this.getValue();
            return value == null ? "" : "<html><body style='font-family:monospaced'>" + HTMLUtilities.escapeHTML((String)value.toString());
        }
    }

    public static abstract class ValueDerivedProperty<T>
    implements ValueProperty<T> {
        protected final ValueRow row;
        protected final Class<T> type;

        public ValueDerivedProperty(ValueRow row, Class<T> type) {
            this.row = row;
            this.type = type;
        }

        @Override
        public ValueRow getRow() {
            return this.row;
        }

        @Override
        public Class<T> getType() {
            return this.type;
        }
    }

    public static class ValueFixedProperty<T>
    implements ValueProperty<T> {
        private T value;

        public ValueFixedProperty(T value) {
            this.value = value;
        }

        @Override
        public Class<T> getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ValueRow getRow() {
            throw new UnsupportedOperationException();
        }

        @Override
        public T getValue() {
            return this.value;
        }
    }

    public static interface ValueProperty<T> {
        public Class<T> getType();

        public ValueRow getRow();

        public T getValue();

        default public String getDisplay() {
            T value = this.getValue();
            return value == null ? "" : value.toString();
        }

        default public String getHtmlDisplay() {
            return "<html>" + HTMLUtilities.escapeHTML((String)this.getDisplay());
        }

        default public String getToolTip() {
            return this.getDisplay();
        }

        default public boolean isModified() {
            return false;
        }
    }
}

