/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.model;

import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.TraceObjectValue;
import ghidra.util.HTMLUtilities;

public interface DisplaysObjectValues {
    public long getSnap();

    default public String getNullDisplay() {
        return "";
    }

    default public String getPrimitiveValueDisplay(Object value) {
        if (!1.$assertionsDisabled && value instanceof TraceObject) {
            throw new AssertionError();
        }
        if (!1.$assertionsDisabled && value instanceof TraceObjectValue) {
            throw new AssertionError();
        }
        if (value == null) {
            return this.getNullDisplay();
        }
        return value.toString();
    }

    default public String getPrimitiveEdgeType(TraceObjectValue edge) {
        return edge.getTargetSchema().getName() + ":" + edge.getValue().getClass().getSimpleName();
    }

    default public String getPrimitiveEdgeToolTip(TraceObjectValue edge) {
        return this.getPrimitiveValueDisplay(edge.getValue()) + " (" + this.getPrimitiveEdgeType(edge) + ")";
    }

    default public String getObjectLinkDisplay(TraceObjectValue edge) {
        return this.getObjectDisplay(edge);
    }

    default public String getObjectType(TraceObjectValue edge) {
        TraceObject object = edge.getChild();
        return object.getTargetSchema().getName().toString();
    }

    default public String getObjectLinkToolTip(TraceObjectValue edge) {
        return "Link to " + this.getObjectToolTip(edge);
    }

    default public String getRawObjectDisplay(TraceObjectValue edge) {
        TraceObject object = edge.getChild();
        if (object.isRoot()) {
            return "<root>";
        }
        return object.getCanonicalPath().toString();
    }

    default public String getObjectDisplay(TraceObjectValue edge) {
        TraceObject object = edge.getChild();
        TraceObjectValue displayAttr = object.getAttribute(this.getSnap(), "_display");
        if (displayAttr != null) {
            return displayAttr.getValue().toString();
        }
        return this.getRawObjectDisplay(edge);
    }

    default public String getObjectToolTip(TraceObjectValue edge) {
        String raw;
        String display = this.getObjectDisplay(edge);
        if (display.equals(raw = this.getRawObjectDisplay(edge))) {
            return display + " (" + this.getObjectType(edge) + ")";
        }
        return display + " (" + this.getObjectType(edge) + ":" + raw + ")";
    }

    default public String getEdgeDisplay(TraceObjectValue edge) {
        if (edge == null) {
            return "";
        }
        if (edge.isCanonical()) {
            return this.getObjectDisplay(edge);
        }
        if (edge.isObject()) {
            return this.getObjectLinkDisplay(edge);
        }
        return this.getPrimitiveValueDisplay(edge.getValue());
    }

    default public String getEdgeHtmlDisplay(TraceObjectValue edge) {
        if (edge == null) {
            return "";
        }
        if (!edge.isObject()) {
            return "<html>" + HTMLUtilities.escapeHTML((String)this.getPrimitiveValueDisplay(edge.getValue()));
        }
        if (edge.isCanonical()) {
            return "<html>" + HTMLUtilities.escapeHTML((String)this.getObjectDisplay(edge));
        }
        return "<html><em>" + HTMLUtilities.escapeHTML((String)this.getObjectLinkDisplay(edge)) + "</em>";
    }

    default public String getEdgeToolTip(TraceObjectValue edge) {
        if (edge == null) {
            return null;
        }
        if (edge.isCanonical()) {
            return this.getObjectToolTip(edge);
        }
        if (edge.isObject()) {
            return this.getObjectLinkToolTip(edge);
        }
        return this.getPrimitiveEdgeToolTip(edge);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

