/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.copying;

import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.service.breakpoint.ProgramBreakpoint;
import ghidra.program.database.IntRangeMap;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeChunker;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataOrganization;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DynamicDataType;
import ghidra.program.model.lang.ProcessorContextView;
import ghidra.program.model.listing.Bookmark;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.listing.BookmarkType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.breakpoint.TraceBreakpoint;
import ghidra.trace.model.memory.TraceMemoryManager;
import ghidra.trace.model.memory.TraceMemoryState;
import ghidra.trace.model.program.TraceProgramView;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;

public class DebuggerCopyPlan {
    protected final Map<Copier, JCheckBox> checkBoxes = new LinkedHashMap<Copier, JCheckBox>();

    public DebuggerCopyPlan() {
        for (Copier copier : this.getAllCopiers()) {
            JCheckBox cb = new JCheckBox(copier.getName());
            Collection<Copier> requires = copier.getRequires();
            Collection<Copier> requiredBy = copier.getRequiredBy();
            if (!requires.isEmpty() || !requiredBy.isEmpty()) {
                cb.addActionListener(e -> {
                    if (cb.isSelected()) {
                        for (Copier req : requires) {
                            this.checkBoxes.get(req).setSelected(true);
                        }
                    } else {
                        for (Copier dep : requiredBy) {
                            this.checkBoxes.get(dep).setSelected(false);
                        }
                    }
                });
            }
            this.checkBoxes.put(copier, cb);
        }
    }

    public Collection<Copier> getAllCopiers() {
        return AllCopiers.VALUES;
    }

    public JCheckBox getCheckBox(Copier copier) {
        return this.checkBoxes.get(copier);
    }

    public void selectAll() {
        for (JCheckBox cb : this.checkBoxes.values()) {
            cb.setSelected(true);
        }
    }

    public void selectNone() {
        for (JCheckBox cb : this.checkBoxes.values()) {
            cb.setSelected(false);
        }
    }

    public void execute(TraceProgramView from, AddressRange fromRange, Program into, Address intoAddress, TaskMonitor monitor) throws Exception {
        for (Copier copier : this.getAllCopiers()) {
            if (!copier.isAvailable(from, into) || !this.checkBoxes.get(copier).isSelected()) continue;
            copier.copy(from, fromRange, into, intoAddress, monitor);
        }
    }

    public void syncCopiersEnabled(TraceProgramView from, Program dest) {
        for (Map.Entry<Copier, JCheckBox> ent : this.checkBoxes.entrySet()) {
            ent.getValue().setEnabled(ent.getKey().isAvailable(from, dest));
        }
    }

    public boolean isRequiresInitializedMemory(TraceProgramView from, Program dest) {
        return this.checkBoxes.entrySet().stream().anyMatch(ent -> {
            Copier copier = (Copier)ent.getKey();
            return copier.isRequiresInitializedMemory() && copier.isAvailable(from, dest) && ((JCheckBox)ent.getValue()).isSelected();
        });
    }

    public static interface Copier {
        public String getName();

        public boolean isAvailable(TraceProgramView var1, Program var2);

        public Collection<Copier> getRequires();

        public Collection<Copier> getRequiredBy();

        public boolean isRequiresInitializedMemory();

        public void copy(TraceProgramView var1, AddressRange var2, Program var3, Address var4, TaskMonitor var5) throws Exception;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum AllCopiers implements Copier
    {
        BYTES("Bytes", List.of()){

            @Override
            public boolean isRequiresInitializedMemory() {
                return true;
            }

            @Override
            public void copy(TraceProgramView from, AddressRange fromRange, Program into, Address intoAddress, TaskMonitor monitor) throws Exception {
                into.getListing().clearCodeUnits(intoAddress, intoAddress.add(fromRange.getLength() - 1L), false);
                byte[] buf = new byte[4096];
                AddressRangeChunker chunker = new AddressRangeChunker(fromRange, buf.length);
                for (AddressRange chunk : chunker) {
                    monitor.checkCancelled();
                    Address addr = chunk.getMinAddress();
                    int len = (int)chunk.getLength();
                    from.getMemory().getBytes(addr, buf, 0, len);
                    long off = addr.subtract(fromRange.getMinAddress());
                    Address dest = intoAddress.add(off);
                    into.getMemory().setBytes(dest, buf, 0, len);
                }
            }
        }
        ,
        STATE("State (as colors)", List.of()){

            @Override
            public void copy(TraceProgramView from, AddressRange fromRange, Program into, Address intoAddress, TaskMonitor monitor) throws Exception {
                IntRangeMap map = into.getIntRangeMap("LISTING_COLOR");
                if (map == null) {
                    map = into.createIntRangeMap("LISTING_COLOR");
                }
                AddressSet rngAsSet = new AddressSet(fromRange);
                TraceMemoryManager mm = from.getTrace().getMemoryManager();
                AddressSetView knownSet = mm.getAddressesWithState(from.getSnap(), (AddressSetView)rngAsSet, s -> s == TraceMemoryState.KNOWN);
                AddressSetView errorSet = mm.getAddressesWithState(from.getSnap(), (AddressSetView)rngAsSet, s -> s == TraceMemoryState.ERROR);
                AddressSet staleSet = rngAsSet.subtract(knownSet).subtract(errorSet);
                this.setShifted(map, fromRange.getMinAddress(), intoAddress, errorSet, DebuggerResources.COLOR_BACKGROUND_ERROR.getRGB());
                this.setShifted(map, fromRange.getMinAddress(), intoAddress, (AddressSetView)staleSet, DebuggerResources.COLOR_BACKGROUND_STALE.getRGB());
            }

            public void setShifted(IntRangeMap map, Address src, Address dst, AddressSetView set, int value) {
                for (AddressRange rng : set) {
                    long offMin = rng.getMinAddress().subtract(src);
                    long offMax = rng.getMaxAddress().subtract(src);
                    Address dMin = dst.add(offMin);
                    Address dMax = dst.add(offMax);
                    map.setValue(dMin, dMax, value);
                }
            }
        }
        ,
        INSTRUCTIONS("Instructions", List.of(BYTES)){

            @Override
            protected boolean checkAvailable(TraceProgramView from, Program into) {
                return into == null || from.getLanguage() == into.getLanguage();
            }

            @Override
            public void copy(TraceProgramView from, AddressRange fromRange, Program into, Address intoAddress, TaskMonitor monitor) throws Exception {
                Listing intoListing = into.getListing();
                for (Instruction ins : from.getListing().getInstructions((AddressSetView)new AddressSet(fromRange), true)) {
                    monitor.checkCancelled();
                    if (!ins.getPrototype().getLanguage().equals(into.getLanguage())) continue;
                    long off = ins.getMinAddress().subtract(fromRange.getMinAddress());
                    Address dest = intoAddress.add(off);
                    intoListing.createInstruction(dest, ins.getPrototype(), (MemBuffer)ins, (ProcessorContextView)ins);
                }
            }
        }
        ,
        DATA("Data", List.of()){

            @Override
            protected boolean checkAvailable(TraceProgramView from, Program into) {
                return into == null || this.sameDataOrganization((Program)from, into);
            }

            @Override
            public void copy(TraceProgramView from, AddressRange fromRange, Program into, Address intoAddress, TaskMonitor monitor) throws Exception {
                Listing intoListing = into.getListing();
                for (Data data : from.getListing().getDefinedData((AddressSetView)new AddressSet(fromRange), true)) {
                    monitor.checkCancelled();
                    long off = data.getMinAddress().subtract(fromRange.getMinAddress());
                    Address dest = intoAddress.add(off);
                    DataType dt = data.getDataType();
                    if (dt instanceof DynamicDataType) continue;
                    intoListing.createData(dest, dt, data.getLength());
                }
            }
        }
        ,
        DYNAMIC_DATA("Dynamic Data", List.of(BYTES)){

            @Override
            protected boolean checkAvailable(TraceProgramView from, Program into) {
                return into == null || this.sameDataOrganization((Program)from, into);
            }

            @Override
            public void copy(TraceProgramView from, AddressRange fromRange, Program into, Address intoAddress, TaskMonitor monitor) throws Exception {
                Listing intoListing = into.getListing();
                for (Data data : from.getListing().getDefinedData((AddressSetView)new AddressSet(fromRange), true)) {
                    monitor.checkCancelled();
                    long off = data.getMinAddress().subtract(fromRange.getMinAddress());
                    Address dest = intoAddress.add(off);
                    DataType dt = data.getDataType();
                    if (!(dt instanceof DynamicDataType)) continue;
                    intoListing.createData(dest, dt, data.getLength());
                }
            }
        }
        ,
        LABELS("Labels", List.of()){

            @Override
            public void copy(TraceProgramView from, AddressRange fromRange, Program into, Address intoAddress, TaskMonitor monitor) throws Exception {
                SymbolTable intoTable = into.getSymbolTable();
                for (Symbol label : from.getSymbolTable().getSymbols((AddressSetView)new AddressSet(fromRange), SymbolType.LABEL, true)) {
                    monitor.checkCancelled();
                    if (label.getSource() == SourceType.DEFAULT) continue;
                    long off = label.getAddress().subtract(fromRange.getMinAddress());
                    Address dest = intoAddress.add(off);
                    Namespace destNs = this.findOrCopyNamespace(label.getParentNamespace(), intoTable, into);
                    try {
                        intoTable.createLabel(dest, label.getName(), destNs, label.getSource());
                    }
                    catch (InvalidInputException e) {
                        throw new AssertionError((Object)e);
                    }
                }
            }

            private Namespace findOrCopyNamespace(Namespace ns, SymbolTable intoTable, Program into) throws Exception {
                if (ns.isGlobal()) {
                    return into.getGlobalNamespace();
                }
                Namespace destParent = this.findOrCopyNamespace(ns.getParentNamespace(), intoTable, into);
                return intoTable.getOrCreateNameSpace(destParent, ns.getName(), ns.getSymbol().getSource());
            }
        }
        ,
        BREAKPOINTS("Breakpoints (as bookmarks)", List.of()){

            @Override
            public void copy(TraceProgramView from, AddressRange fromRange, Program into, Address intoAddress, TaskMonitor monitor) throws Exception {
                for (TraceBreakpoint bpt : from.getTrace().getBreakpointManager().getBreakpointsIntersecting(Lifespan.at((long)from.getSnap()), fromRange)) {
                    monitor.checkCancelled();
                    long off = bpt.getMinAddress().subtract(fromRange.getMinAddress());
                    Address dest = intoAddress.add(off);
                    ProgramBreakpoint pb = new ProgramBreakpoint(into, dest, bpt.getLength(), bpt.getKinds());
                    if (bpt.isEnabled(from.getSnap())) {
                        pb.enable();
                    } else {
                        pb.disable();
                    }
                    pb.setEmuSleigh(bpt.getEmuSleigh());
                }
            }
        }
        ,
        BOOKMARKS("Bookmarks", List.of()){

            @Override
            public void copy(TraceProgramView from, AddressRange fromRange, Program into, Address intoAddress, TaskMonitor monitor) throws Exception {
                BookmarkManager intoBookmarks = into.getBookmarkManager();
                Iterator bit = from.getBookmarkManager().getBookmarksIterator(fromRange.getMinAddress(), true);
                while (bit.hasNext()) {
                    monitor.checkCancelled();
                    Bookmark bm = (Bookmark)bit.next();
                    if (bm.getAddress().compareTo((Object)fromRange.getMaxAddress()) > 0) break;
                    BookmarkType type = bm.getType();
                    long off = bm.getAddress().subtract(fromRange.getMinAddress());
                    Address dest = intoAddress.add(off);
                    BookmarkType destType = intoBookmarks.getBookmarkType(type.getTypeString());
                    if (destType == null) {
                        destType = intoBookmarks.defineType(type.getTypeString(), type.getIcon(), type.getMarkerColor(), type.getMarkerPriority());
                    }
                    intoBookmarks.setBookmark(dest, destType.getTypeString(), bm.getCategory(), bm.getComment());
                }
            }
        }
        ,
        REFERENCES("References (memory only)", List.of()){

            @Override
            public void copy(TraceProgramView from, AddressRange fromRange, Program into, Address intoAddress, TaskMonitor monitor) throws Exception {
                ReferenceManager intoRefs = into.getReferenceManager();
                for (Reference ref : from.getReferenceManager().getReferenceIterator(fromRange.getMinAddress())) {
                    monitor.checkCancelled();
                    if (ref.getFromAddress().compareTo((Object)fromRange.getMaxAddress()) > 0) break;
                    if (ref.getSource() == SourceType.DEFAULT || !ref.isMemoryReference() || !fromRange.contains(ref.getToAddress())) continue;
                    long offFrom = ref.getFromAddress().subtract(fromRange.getMinAddress());
                    long offTo = ref.getToAddress().subtract(fromRange.getMinAddress());
                    Address destFrom = intoAddress.add(offFrom);
                    Address destTo = intoAddress.add(offTo);
                    intoRefs.addMemoryReference(destFrom, destTo, ref.getReferenceType(), ref.getSource(), ref.getOperandIndex());
                }
            }
        }
        ,
        COMMENTS("Comments", List.of()){

            @Override
            public void copy(TraceProgramView from, AddressRange fromRange, Program into, Address intoAddress, TaskMonitor monitor) throws Exception {
                Listing fromListing = from.getListing();
                Listing intoListing = into.getListing();
                for (Address addr : fromListing.getCommentAddressIterator((AddressSetView)new AddressSet(fromRange), true)) {
                    monitor.checkCancelled();
                    long off = addr.subtract(fromRange.getMinAddress());
                    Address dest = intoAddress.add(off);
                    for (int i = 0; i <= 4; ++i) {
                        String comment = fromListing.getComment(i, addr);
                        if (comment == null) continue;
                        intoListing.setComment(dest, i, comment);
                    }
                }
            }
        };

        public static final List<Copier> VALUES;
        final String name;
        final Collection<Copier> requires;
        final Collection<Copier> requiredBy = new HashSet<Copier>();

        protected boolean sameDataOrganization(Program p1, Program p2) {
            DataOrganization dataOrg1 = p1.getDataTypeManager().getDataOrganization();
            DataOrganization dataOrg2 = p2.getDataTypeManager().getDataOrganization();
            return dataOrg1.equals(dataOrg2);
        }

        private AllCopiers(String name, Collection<AllCopiers> requires) {
            this.name = name;
            this.requires = Collections.unmodifiableCollection(requires);
            for (AllCopiers req : requires) {
                req.requiredBy.add(this);
            }
        }

        protected boolean checkAvailable(TraceProgramView from, Program into) {
            return true;
        }

        @Override
        public boolean isAvailable(TraceProgramView from, Program into) {
            return this.checkAvailable(from, into) && this.getRequires().stream().allMatch(c -> c.isAvailable(from, into));
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Collection<Copier> getRequires() {
            return this.requires;
        }

        @Override
        public Collection<Copier> getRequiredBy() {
            return this.requiredBy;
        }

        @Override
        public boolean isRequiresInitializedMemory() {
            return false;
        }

        static {
            List<AllCopiers> asList = Arrays.asList(AllCopiers.values());
            Collections.sort(asList, Comparator.comparing(AllCopiers::getName));
            VALUES = Collections.unmodifiableList(asList);
        }
    }
}

