/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.action;

import ghidra.app.plugin.core.debug.DebuggerCoordinates;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.action.RegisterLocationTrackingSpec;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Register;
import ghidra.trace.model.guest.TracePlatform;
import javax.swing.Icon;

public enum PCByRegisterLocationTrackingSpec implements RegisterLocationTrackingSpec
{
    INSTANCE;

    public static final String CONFIG_NAME = "TRACK_PC_BY_REGISTER";

    @Override
    public String getConfigName() {
        return CONFIG_NAME;
    }

    @Override
    public String getMenuName() {
        return "Track Program Counter (by Register)";
    }

    @Override
    public Icon getMenuIcon() {
        return DebuggerResources.TrackLocationAction.ICON_PC_BY_REGISTER;
    }

    @Override
    public Register computeRegister(DebuggerCoordinates coordinates) {
        TracePlatform platform = coordinates.getPlatform();
        if (platform == null) {
            return null;
        }
        return platform.getLanguage().getProgramCounter();
    }

    @Override
    public String getLocationLabel() {
        return "pc";
    }

    @Override
    public AddressSpace computeDefaultAddressSpace(DebuggerCoordinates coordinates) {
        return coordinates.getPlatform().getLanguage().getDefaultSpace();
    }
}

