/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.util;

import ghidra.docking.settings.Settings;
import ghidra.pcode.utils.Utils;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeEncodeException;
import ghidra.program.model.data.Structure;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.mem.MemBuffer;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.model.listing.TraceData;
import ghidra.trace.model.memory.TraceMemorySpace;
import ghidra.trace.model.memory.TraceMemoryState;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;

public final class TraceRegisterUtils
extends Enum<TraceRegisterUtils> {
    private static final /* synthetic */ TraceRegisterUtils[] $VALUES;

    public static TraceRegisterUtils[] values() {
        return (TraceRegisterUtils[])$VALUES.clone();
    }

    public static TraceRegisterUtils valueOf(String name) {
        return Enum.valueOf(TraceRegisterUtils.class, name);
    }

    public static AddressRange rangeForRegister(Register register) {
        Address address = register.getAddress();
        return new AddressRangeImpl(address, address.add((long)(register.getNumBytes() - 1)));
    }

    public static AddressRange getOverlayRange(AddressSpace space, AddressRange range) {
        AddressSpace physical = space.getPhysicalSpace();
        if (physical == space || physical != range.getAddressSpace()) {
            return range;
        }
        return new AddressRangeImpl(space.getAddress(range.getMinAddress().getOffset()), space.getAddress(range.getMaxAddress().getOffset()));
    }

    public static AddressSetView getOverlaySet(AddressSpace space, AddressSetView set) {
        if (!space.isOverlaySpace()) {
            return set;
        }
        AddressSet result = new AddressSet();
        for (AddressRange rng : set) {
            result.add(TraceRegisterUtils.getOverlayRange(space, rng));
        }
        return result;
    }

    public static AddressRange getPhysicalRange(AddressRange range) {
        AddressSpace physical;
        AddressSpace space = range.getAddressSpace();
        if (space == (physical = space.getPhysicalSpace())) {
            return range;
        }
        return new AddressRangeImpl(physical.getAddress(range.getMinAddress().getOffset()), physical.getAddress(range.getMaxAddress().getOffset()));
    }

    public static AddressSetView getPhysicalSet(AddressSetView set) {
        if (set.isEmpty() || !set.getMinAddress().getAddressSpace().isOverlaySpace()) {
            return set;
        }
        AddressSet result = new AddressSet();
        for (AddressRange rng : set) {
            result.add(TraceRegisterUtils.getPhysicalRange(rng));
        }
        return result;
    }

    public static byte[] padOrTruncate(byte[] arr, int length) {
        if (arr.length == length) {
            return arr;
        }
        if (arr.length < length) {
            byte[] dup = new byte[length];
            System.arraycopy(arr, 0, dup, length - arr.length, arr.length);
            return dup;
        }
        return Arrays.copyOfRange(arr, arr.length - length, arr.length);
    }

    public static ByteBuffer bufferForValue(Register register, RegisterValue value) {
        byte[] bytes = (byte[])value.toBytes().clone();
        int start = bytes.length / 2;
        if (!register.isBigEndian() && !register.isProcessorContext()) {
            ArrayUtils.reverse((byte[])bytes, (int)start, (int)bytes.length);
        }
        int offset = TraceRegisterUtils.computeMaskOffset(register);
        return ByteBuffer.wrap(bytes, start + offset, register.getNumBytes());
    }

    public static int computeMaskOffset(Register reg) {
        if (reg.isBaseRegister()) {
            return 0;
        }
        return reg.getOffset() - reg.getBaseRegister().getOffset();
    }

    public static int computeMaskOffset(RegisterValue value) {
        return TraceRegisterUtils.computeMaskOffset(value.getRegister());
    }

    public static TraceData seekComponent(TraceData data, AddressRange range) {
        if (data == null) {
            return null;
        }
        DataType type = data.getDataType();
        if (!(type instanceof Structure)) {
            return null;
        }
        int offset = (int)range.getMinAddress().subtract(data.getMinAddress());
        TraceData component = data.getComponentAt(offset);
        if (component == null) {
            return null;
        }
        int cmpMax = range.getMaxAddress().compareTo((Object)component.getMaxAddress());
        if (cmpMax > 0) {
            return null;
        }
        if (cmpMax == 0 && component.getMinAddress().equals((Object)range.getMinAddress())) {
            return component;
        }
        return TraceRegisterUtils.seekComponent(component, range);
    }

    public static TraceData seekComponent(TraceData data, Register reg) {
        return TraceRegisterUtils.seekComponent(data, TraceRegisterUtils.rangeForRegister(reg));
    }

    public static RegisterValue encodeValueRepresentationHackPointer(Register register, TraceData data, String representation) throws DataTypeEncodeException {
        DataType dataType = data.getBaseDataType();
        if (data.getValueClass() != Address.class) {
            byte[] bytes = dataType.encodeRepresentation(representation, (MemBuffer)data, (Settings)data, data.getLength());
            BigInteger value = Utils.bytesToBigInteger((byte[])bytes, (int)register.getMinimumByteSize(), (boolean)register.isBigEndian(), (boolean)false);
            return new RegisterValue(register, value);
        }
        Address addr = data.getTrace().getBaseAddressFactory().getAddress(representation);
        if (addr == null) {
            throw new DataTypeEncodeException("Invalid address", (Object)representation, dataType);
        }
        return new RegisterValue(register, addr.getOffsetAsBigInteger());
    }

    public static RegisterValue combineWithTraceParentRegisterValue(Register parent, RegisterValue rv, TracePlatform platform, long snap, TraceMemorySpace regs, boolean requireKnown) {
        Register reg = rv.getRegister();
        if (reg == parent) {
            return rv;
        }
        if (regs == null) {
            if (requireKnown) {
                throw new IllegalStateException("Must fetch " + parent + " before setting " + reg);
            }
            return rv.getRegisterValue(parent);
        }
        if (requireKnown && TraceMemoryState.KNOWN != regs.getState(platform, snap, parent)) {
            throw new IllegalStateException("Must fetch " + parent + " before setting " + reg);
        }
        return regs.getValue(platform, snap, parent).combineValues(rv);
    }

    public static RegisterValue combineWithTraceBaseRegisterValue(RegisterValue rv, TracePlatform platform, long snap, TraceMemorySpace regs, boolean requireKnown) {
        return TraceRegisterUtils.combineWithTraceParentRegisterValue(rv.getRegister().getBaseRegister(), rv, platform, snap, regs, requireKnown);
    }

    public static ByteBuffer prepareBuffer(Register register) {
        int byteLength = register.getNumBytes();
        byte[] mask = register.getBaseMask();
        ByteBuffer buf = ByteBuffer.allocate(mask.length * 2);
        buf.put(mask);
        int maskOffset = TraceRegisterUtils.computeMaskOffset(register);
        int startVal = buf.position() + maskOffset;
        buf.position(startVal);
        buf.limit(buf.position() + byteLength);
        return buf;
    }

    public static RegisterValue finishBuffer(ByteBuffer buf, Register register) {
        byte[] arr = buf.array();
        if (!register.isBigEndian() && !register.isProcessorContext()) {
            ArrayUtils.reverse((byte[])arr, (int)register.getBaseMask().length, (int)buf.capacity());
        }
        return new RegisterValue(register, arr);
    }

    public static boolean isByteBound(Register register) {
        return register.getLeastSignificantBit() % 8 == 0 && register.getBitLength() % 8 == 0;
    }

    public static void requireByteBound(Register register) {
        if (!TraceRegisterUtils.isByteBound(register)) {
            throw new IllegalArgumentException("Cannot work with sub-byte registers. Consider a parent instead.");
        }
    }

    private static /* synthetic */ TraceRegisterUtils[] $values() {
        return new TraceRegisterUtils[0];
    }

    static {
        $VALUES = TraceRegisterUtils.$values();
    }
}

