/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.target;

import db.DBHandle;
import db.DBRecord;
import db.StringField;
import ghidra.dbg.target.TargetBreakpointSpec;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.SchemaContext;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.target.schema.XmlSchemaContext;
import ghidra.dbg.util.PathMatcher;
import ghidra.dbg.util.PathPattern;
import ghidra.dbg.util.PathPredicates;
import ghidra.dbg.util.PathUtils;
import ghidra.lifecycle.Internal;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Language;
import ghidra.trace.database.DBTrace;
import ghidra.trace.database.DBTraceManager;
import ghidra.trace.database.map.DBTraceAddressSnapRangePropertyMap;
import ghidra.trace.database.map.DBTraceAddressSnapRangePropertyMapTree;
import ghidra.trace.database.module.TraceObjectSection;
import ghidra.trace.database.target.DBTraceObject;
import ghidra.trace.database.target.DBTraceObjectAddressRangeValue;
import ghidra.trace.database.target.DBTraceObjectValue;
import ghidra.trace.database.target.InternalTraceObjectValue;
import ghidra.trace.database.target.visitors.SuccessorsRelativeVisitor;
import ghidra.trace.database.thread.DBTraceObjectThread;
import ghidra.trace.model.ImmutableTraceAddressSnapRange;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.breakpoint.TraceBreakpointKind;
import ghidra.trace.model.breakpoint.TraceObjectBreakpointLocation;
import ghidra.trace.model.memory.TraceMemoryFlag;
import ghidra.trace.model.memory.TraceObjectMemoryRegion;
import ghidra.trace.model.memory.TraceOverlappedRegionException;
import ghidra.trace.model.modules.TraceObjectModule;
import ghidra.trace.model.stack.TraceObjectStack;
import ghidra.trace.model.stack.TraceObjectStackFrame;
import ghidra.trace.model.target.DuplicateKeyException;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.TraceObjectInterface;
import ghidra.trace.model.target.TraceObjectKeyPath;
import ghidra.trace.model.target.TraceObjectManager;
import ghidra.trace.model.target.TraceObjectValPath;
import ghidra.trace.model.target.TraceObjectValue;
import ghidra.trace.model.target.annot.TraceObjectInterfaceUtils;
import ghidra.trace.model.thread.TraceObjectThread;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.util.LockHold;
import ghidra.util.Msg;
import ghidra.util.database.DBAnnotatedObject;
import ghidra.util.database.DBCachedObjectIndex;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBCachedObjectStoreFactory;
import ghidra.util.database.DBObjectColumn;
import ghidra.util.database.DBOpenMode;
import ghidra.util.database.annot.DBAnnotatedColumn;
import ghidra.util.database.annot.DBAnnotatedField;
import ghidra.util.database.annot.DBAnnotatedObjectInfo;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jdom.JDOMException;

public class DBTraceObjectManager
implements TraceObjectManager,
DBTraceManager {
    protected final ReadWriteLock lock;
    protected final DBTrace trace;
    protected final DBCachedObjectStore<DBTraceObjectSchemaEntry> schemaStore;
    protected final DBCachedObjectStore<DBTraceObject> objectStore;
    protected final DBCachedObjectStore<DBTraceObjectValue> valueStore;
    protected final DBTraceAddressSnapRangePropertyMap<DBTraceObjectAddressRangeValue, DBTraceObjectAddressRangeValue> rangeValueMap;
    protected final DBCachedObjectIndex<TraceObjectKeyPath, DBTraceObject> objectsByPath;
    protected final DBCachedObjectIndex<DBTraceObjectValue.PrimaryTriple, DBTraceObjectValue> valuesByTriple;
    protected final DBCachedObjectIndex<DBTraceObject, DBTraceObjectValue> valuesByChild;
    protected final Collection<TraceObject> objectsView;
    protected final Collection<TraceObjectValue> valuesView;
    protected TargetObjectSchema rootSchema;

    public DBTraceObjectManager(DBHandle dbh, DBOpenMode openMode, ReadWriteLock lock, TaskMonitor monitor, Language baseLanguage, DBTrace trace) throws IOException, VersionException {
        this.lock = lock;
        this.trace = trace;
        DBCachedObjectStoreFactory factory = trace.getStoreFactory();
        this.schemaStore = factory.getOrCreateCachedStore("ObjectSchema", DBTraceObjectSchemaEntry.class, DBTraceObjectSchemaEntry::new, true);
        this.loadRootSchema();
        this.objectStore = factory.getOrCreateCachedStore("Objects", DBTraceObject.class, (s, r) -> new DBTraceObject(this, s, r), true);
        this.valueStore = factory.getOrCreateCachedStore("ObjectValue", DBTraceObjectValue.class, (s, r) -> new DBTraceObjectValue(this, s, r), true);
        this.rangeValueMap = new DBTraceAddressSnapRangePropertyMap("ObjectRangeValue", dbh, openMode, lock, monitor, baseLanguage, trace, null, DBTraceObjectAddressRangeValue.class, (t, s, r) -> new DBTraceObjectAddressRangeValue(this, t, s, r));
        this.objectsByPath = this.objectStore.getIndex(TraceObjectKeyPath.class, DBTraceObject.PATH_COLUMN);
        this.valuesByTriple = this.valueStore.getIndex(DBTraceObjectValue.PrimaryTriple.class, DBTraceObjectValue.TRIPLE_COLUMN);
        this.valuesByChild = this.valueStore.getIndex(DBTraceObject.class, DBTraceObjectValue.CHILD_COLUMN);
        this.objectsView = Collections.unmodifiableCollection(this.objectStore.asMap().values());
        this.valuesView = Collections.unmodifiableCollection(this.valueStore.asMap().values());
    }

    protected void loadRootSchema() {
        if (this.schemaStore.asMap().isEmpty()) {
            this.rootSchema = null;
            return;
        }
        assert (this.schemaStore.asMap().size() == 1);
        DBTraceObjectSchemaEntry schemaEntry = (DBTraceObjectSchemaEntry)this.schemaStore.getObjectAt(0L);
        this.rootSchema = schemaEntry.schema;
    }

    public void dbError(IOException e) {
        this.trace.dbError(e);
    }

    @Override
    public void invalidateCache(boolean all) {
        this.objectStore.invalidateCache();
        this.valueStore.invalidateCache();
        this.rangeValueMap.invalidateCache(all);
        this.schemaStore.invalidateCache();
        this.loadRootSchema();
    }

    @Internal
    protected DBTraceObject assertIsMine(TraceObject object) {
        if (!(object instanceof DBTraceObject)) {
            throw new IllegalArgumentException("Object " + object + " is not part of this trace");
        }
        DBTraceObject dbObject = (DBTraceObject)object;
        if (dbObject.manager != this) {
            throw new IllegalArgumentException("Object " + object + " is not part of this trace");
        }
        if (!this.getAllObjects().contains(dbObject)) {
            throw new IllegalArgumentException("Object " + object + " is not part of this trace");
        }
        return dbObject;
    }

    protected Object validatePrimitive(Object child) {
        try {
            DBCachedObjectStoreFactory.PrimitiveCodec.getCodec(child.getClass());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Cannot encode " + child, e);
        }
        return child;
    }

    @Override
    public Trace getTrace() {
        return this.trace;
    }

    protected void setSchema(TargetObjectSchema schema) {
        if (this.rootSchema != null) {
            throw new IllegalStateException("There is already a root object");
        }
        DBTraceObjectSchemaEntry schemaEntry = (DBTraceObjectSchemaEntry)this.schemaStore.create(0L);
        schemaEntry.set(schema);
        this.rootSchema = schema;
    }

    protected void emitValueCreated(DBTraceObject parent, InternalTraceObjectValue entry) {
        if (parent == null) {
            return;
        }
        parent.emitEvents(new TraceChangeRecord<InternalTraceObjectValue, Void>(Trace.TraceObjectChangeType.VALUE_CREATED, null, entry));
    }

    protected InternalTraceObjectValue doCreateValue(Lifespan lifespan, DBTraceObject parent, String key, Object value) {
        if (value instanceof AddressRange) {
            DBTraceObjectAddressRangeValue entry = this.rangeValueMap.put(new ImmutableTraceAddressSnapRange((AddressRange)value, lifespan), null);
            entry.set(parent, key, false);
            this.emitValueCreated(parent, entry);
            return entry;
        }
        if (value instanceof Address) {
            Address address = (Address)value;
            AddressRangeImpl singleton = new AddressRangeImpl(address, address);
            DBTraceObjectAddressRangeValue entry = this.rangeValueMap.put(new ImmutableTraceAddressSnapRange((AddressRange)singleton, lifespan), null);
            entry.set(parent, key, true);
            this.emitValueCreated(parent, entry);
            return entry;
        }
        DBTraceObjectValue entry = (DBTraceObjectValue)this.valueStore.create();
        entry.set(lifespan, parent, key, value);
        this.emitValueCreated(parent, entry);
        return entry;
    }

    protected DBTraceObject doCreateObject(TraceObjectKeyPath path) {
        DBTraceObject obj = (DBTraceObject)this.objectsByPath.getOne((Object)path);
        if (obj != null) {
            return obj;
        }
        obj = (DBTraceObject)this.objectStore.create();
        obj.set(path);
        obj.emitEvents(new TraceChangeRecord<DBTraceObject, Void>(Trace.TraceObjectChangeType.CREATED, null, obj));
        return obj;
    }

    protected DBTraceObject doGetObject(TraceObjectKeyPath path) {
        return (DBTraceObject)this.objectsByPath.getOne((Object)path);
    }

    @Override
    public DBTraceObject createObject(TraceObjectKeyPath path) {
        if (path.isRoot()) {
            throw new IllegalArgumentException("Cannot create non-root object with root path");
        }
        try (LockHold hold = this.trace.lockWrite();){
            if (this.rootSchema == null) {
                throw new IllegalStateException("No schema! Create the root object, first.");
            }
            DBTraceObject dBTraceObject = this.doCreateObject(path);
            return dBTraceObject;
        }
    }

    @Override
    public TraceObjectValue createRootObject(TargetObjectSchema schema) {
        try (LockHold hold = this.trace.lockWrite();){
            this.setSchema(schema);
            DBTraceObject root = this.doCreateObject(TraceObjectKeyPath.of(new String[0]));
            assert (root.getKey() == 0L);
            InternalTraceObjectValue val = this.doCreateValue(Lifespan.ALL, null, "", root);
            assert (val.getKey() == 0L);
            InternalTraceObjectValue internalTraceObjectValue = val;
            return internalTraceObjectValue;
        }
    }

    @Override
    public TargetObjectSchema getRootSchema() {
        try (LockHold hold = this.trace.lockRead();){
            TargetObjectSchema targetObjectSchema = this.rootSchema;
            return targetObjectSchema;
        }
    }

    @Override
    public DBTraceObject getRootObject() {
        return this.getObjectById(0L);
    }

    @Override
    public DBTraceObject getObjectById(long key) {
        try (LockHold hold = this.trace.lockRead();){
            DBTraceObject dBTraceObject = (DBTraceObject)this.objectStore.getObjectAt(key);
            return dBTraceObject;
        }
    }

    @Override
    public DBTraceObject getObjectByCanonicalPath(TraceObjectKeyPath path) {
        return (DBTraceObject)this.objectsByPath.getOne((Object)path);
    }

    public Stream<? extends DBTraceObject> getObjectsByPath(Lifespan span, TraceObjectKeyPath path) {
        DBTraceObject root = this.getRootObject();
        return this.getValuePaths(span, (PathPredicates)new PathPattern(path.getKeyList())).map(p -> p.getDestinationValue(root)).filter(DBTraceObject.class::isInstance).map(DBTraceObject.class::cast);
    }

    @Override
    public Stream<? extends TraceObjectValPath> getValuePaths(Lifespan span, PathPredicates predicates) {
        try (LockHold hold = this.trace.lockRead();){
            DBTraceObjectValue rootVal = (DBTraceObjectValue)this.valueStore.getObjectAt(0L);
            if (rootVal == null) {
                Stream<TraceObjectValPath> stream = Stream.of(new TraceObjectValPath[0]);
                return stream;
            }
            Stream<? extends TraceObjectValPath> stream = rootVal.doStreamVisitor(span, new SuccessorsRelativeVisitor(predicates));
            return stream;
        }
    }

    @Override
    public Collection<? extends TraceObject> getAllObjects() {
        return this.objectsView;
    }

    @Override
    public Collection<? extends TraceObjectValue> getAllValues() {
        return this.valuesView;
    }

    @Override
    public Collection<? extends TraceObjectValue> getValuesIntersecting(Lifespan span, AddressRange range) {
        return Collections.unmodifiableCollection(this.rangeValueMap.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.intersecting(range, span)).values());
    }

    public Collection<? extends TraceObjectValue> getValuesAt(long snap, Address address) {
        return Collections.unmodifiableCollection(this.rangeValueMap.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.at(address, snap)).values());
    }

    @Override
    public <I extends TraceObjectInterface> Stream<I> queryAllInterface(Lifespan span, Class<I> ifClass) {
        if (this.rootSchema == null) {
            throw new IllegalStateException("There is no schema. Create a root object.");
        }
        Class<? extends TargetObject> targetIf = TraceObjectInterfaceUtils.toTargetIf(ifClass);
        PathMatcher matcher = this.rootSchema.searchFor(targetIf, true);
        return this.getValuePaths(span, (PathPredicates)matcher).filter(p -> {
            TraceObject object = p.getDestination(this.getRootObject());
            if (object == null) {
                Msg.error((Object)this, (Object)("NULL VALUE! " + p.getLastEntry()));
                return false;
            }
            return true;
        }).map(p -> p.getDestination(this.getRootObject()).queryInterface(ifClass));
    }

    @Override
    public void cullDisconnectedObjects() {
        try (LockHold hold = this.trace.lockWrite();){
            for (DBTraceObject obj : this.objectStore.asMap().values()) {
                if (obj.doIsConnected()) continue;
                obj.delete();
            }
        }
    }

    @Override
    public void clear() {
        try (LockHold hold = this.trace.lockWrite();){
            this.valueStore.deleteAll();
            this.rangeValueMap.clear();
            this.objectStore.deleteAll();
            this.schemaStore.deleteAll();
            this.rootSchema = null;
        }
    }

    protected void doDeleteObject(DBTraceObject object) {
        this.objectStore.delete((DBAnnotatedObject)object);
        object.emitEvents(new TraceChangeRecord<DBTraceObject, Void>(Trace.TraceObjectChangeType.DELETED, null, object));
    }

    protected void doDeleteEdge(DBTraceObjectValue edge) {
        this.valueStore.delete((DBAnnotatedObject)edge);
    }

    public boolean hasSchema() {
        return this.rootSchema != null;
    }

    protected <I extends TraceObjectInterface> I doAddWithInterface(List<String> keyList, Class<I> iface) {
        Class<? extends TargetObject> targetIf = TraceObjectInterfaceUtils.toTargetIf(iface);
        TargetObjectSchema schema = this.rootSchema.getSuccessorSchema(keyList);
        if (!schema.getInterfaces().contains(targetIf)) {
            throw new IllegalStateException("Schema " + schema + " at " + PathUtils.toString(keyList) + " does not provide interface " + iface.getSimpleName());
        }
        DBTraceObject obj = this.createObject(TraceObjectKeyPath.of(keyList));
        return obj.queryInterface(iface);
    }

    protected <I extends TraceObjectInterface> I doAddWithInterface(String path, Class<I> iface) {
        return this.doAddWithInterface(PathUtils.parse((String)path), iface);
    }

    public <I extends TraceObjectInterface> Collection<I> getAllObjects(Class<I> iface) {
        try (LockHold hold = this.trace.lockRead();){
            Collection collection = this.queryAllInterface(Lifespan.ALL, iface).collect(Collectors.toSet());
            return collection;
        }
    }

    public <I extends TraceObjectInterface> Collection<I> getObjectsByPath(String path, Class<I> iface) {
        try (LockHold hold = this.trace.lockRead();){
            Collection collection = this.getObjectsByPath(Lifespan.ALL, TraceObjectKeyPath.parse(path)).map(o -> o.queryInterface(iface)).filter(i -> i != null).collect(Collectors.toSet());
            return collection;
        }
    }

    public <I extends TraceObjectInterface> I getObjectByPath(long snap, String path, Class<I> iface) {
        try (LockHold hold = this.trace.lockRead();){
            TraceObjectInterface traceObjectInterface = this.getObjectsByPath(Lifespan.at(snap), TraceObjectKeyPath.parse(path)).findAny().map(o -> o.queryInterface(iface)).orElse(null);
            return (I)traceObjectInterface;
        }
    }

    protected <I extends TraceObjectInterface> Stream<I> doParentsWithKeyHaving(Stream<? extends TraceObjectValue> values, String key, Class<I> iface) {
        return values.filter(v -> key.equals(v.getEntryKey())).map(v -> v.getParent()).map(o -> o.queryInterface(iface)).filter(i -> i != null);
    }

    public <I extends TraceObjectInterface> Collection<I> getObjectsContaining(long snap, Address address, String key, Class<I> iface) {
        try (LockHold hold = this.trace.lockRead();){
            Collection collection = this.doParentsWithKeyHaving(this.getValuesAt(snap, address).stream(), key, iface).collect(Collectors.toSet());
            return collection;
        }
    }

    public <I extends TraceObjectInterface> I getObjectContaining(long snap, Address address, String key, Class<I> iface) {
        try (LockHold hold = this.trace.lockRead();){
            TraceObjectInterface traceObjectInterface = this.doParentsWithKeyHaving(this.getValuesAt(snap, address).stream(), key, iface).findAny().orElse(null);
            return (I)traceObjectInterface;
        }
    }

    public <I extends TraceObjectInterface> Collection<I> getObjectsIntersecting(Lifespan lifespan, AddressRange range, String key, Class<I> iface) {
        try (LockHold hold = this.trace.lockRead();){
            Collection collection = this.doParentsWithKeyHaving(this.getValuesIntersecting(lifespan, range).stream(), key, iface).collect(Collectors.toSet());
            return collection;
        }
    }

    public <I extends TraceObjectInterface> Collection<I> getObjectsAtSnap(long snap, Class<I> iface) {
        try (LockHold hold = this.trace.lockRead();){
            Collection collection = this.queryAllInterface(Lifespan.at(snap), iface).collect(Collectors.toSet());
            return collection;
        }
    }

    public <I extends TraceObjectInterface> AddressSetView getObjectsAddressSet(long snap, String key, Class<I> ifaceCls, Predicate<? super I> predicate) {
        return this.rangeValueMap.getAddressSetView(Lifespan.at(snap), v -> {
            if (!key.equals(v.getEntryKey())) {
                return false;
            }
            DBTraceObject parent = v.getParent();
            Object iface = parent.queryInterface(ifaceCls);
            if (iface == null) {
                return false;
            }
            return predicate.test((Object)iface);
        });
    }

    public <I extends TraceObjectInterface> I getSuccessor(TraceObject seed, PathPredicates predicates, long snap, Class<I> iface) {
        try (LockHold hold = this.trace.lockRead();){
            TraceObjectInterface traceObjectInterface = seed.getSuccessors(Lifespan.at(snap), predicates).map(p -> p.getDestination(seed).queryInterface(iface)).filter(i -> i != null).findAny().orElse(null);
            return (I)traceObjectInterface;
        }
    }

    public <I extends TraceObjectInterface> I getLatestSuccessor(TraceObject seed, TraceObjectKeyPath path, long snap, Class<I> iface) {
        try (LockHold hold = this.trace.lockRead();){
            TraceObjectInterface traceObjectInterface = seed.getOrderedSuccessors(Lifespan.toNow(snap), path, false).map(p -> p.getDestination(seed).queryInterface(iface)).filter(i -> i != null).findAny().orElse(null);
            return (I)traceObjectInterface;
        }
    }

    public TraceObjectBreakpointLocation addBreakpoint(String path, Lifespan lifespan, AddressRange range, Collection<TraceThread> threads, Collection<TraceBreakpointKind> kinds, boolean enabled, String comment) throws DuplicateNameException {
        TraceObjectBreakpointLocation traceObjectBreakpointLocation;
        block9: {
            List specPath = this.getRootSchema().searchForAncestor(TargetBreakpointSpec.class, PathUtils.parse((String)path));
            if (specPath == null) {
                throw new IllegalStateException("The schema does not provide an implicit breakpoint specification on the given path.");
            }
            LockHold hold = this.trace.lockWrite();
            try {
                TraceObjectBreakpointLocation loc = this.doAddWithInterface(path, TraceObjectBreakpointLocation.class);
                loc.setName(lifespan, path);
                loc.setRange(lifespan, range);
                loc.setKinds(lifespan, kinds);
                loc.setEnabled(lifespan, enabled);
                loc.setComment(lifespan, comment);
                loc.getObject().insert(lifespan, TraceObject.ConflictResolution.DENY);
                traceObjectBreakpointLocation = loc;
                if (hold == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (hold != null) {
                        try {
                            hold.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (DuplicateKeyException e) {
                    throw new DuplicateNameException(e.getMessage());
                }
            }
            hold.close();
        }
        return traceObjectBreakpointLocation;
    }

    public TraceObjectMemoryRegion addMemoryRegion(String path, Lifespan lifespan, AddressRange range, Collection<TraceMemoryFlag> flags) throws TraceOverlappedRegionException {
        try (LockHold hold = this.trace.lockWrite();){
            TraceObjectMemoryRegion region = this.doAddWithInterface(path, TraceObjectMemoryRegion.class);
            region.setName(lifespan, path);
            region.setRange(lifespan, range);
            region.setFlags(lifespan, flags);
            region.getObject().insert(lifespan, TraceObject.ConflictResolution.TRUNCATE);
            TraceObjectMemoryRegion traceObjectMemoryRegion = region;
            return traceObjectMemoryRegion;
        }
    }

    public TraceObjectModule addModule(String path, String name, Lifespan lifespan, AddressRange range) throws DuplicateNameException {
        TraceObjectModule traceObjectModule;
        block8: {
            LockHold hold = this.trace.lockWrite();
            try {
                TraceObjectModule module = this.doAddWithInterface(path, TraceObjectModule.class);
                module.setName(lifespan, name);
                module.setRange(lifespan, range);
                module.getObject().insert(lifespan, TraceObject.ConflictResolution.DENY);
                traceObjectModule = module;
                if (hold == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (hold != null) {
                        try {
                            hold.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (DuplicateKeyException e) {
                    throw new DuplicateNameException(e.getMessage());
                }
            }
            hold.close();
        }
        return traceObjectModule;
    }

    public TraceObjectSection addSection(String path, String name, Lifespan lifespan, AddressRange range) throws DuplicateNameException {
        TraceObjectSection traceObjectSection;
        block8: {
            LockHold hold = this.trace.lockWrite();
            try {
                TraceObjectSection section = this.doAddWithInterface(path, TraceObjectSection.class);
                section.setName(lifespan, name);
                section.setRange(lifespan, range);
                section.getObject().insert(lifespan, TraceObject.ConflictResolution.DENY);
                traceObjectSection = section;
                if (hold == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (hold != null) {
                        try {
                            hold.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (DuplicateKeyException e) {
                    throw new DuplicateNameException(e.getMessage());
                }
            }
            hold.close();
        }
        return traceObjectSection;
    }

    public TraceObjectStack addStack(List<String> keyList, long snap) {
        try (LockHold hold = this.trace.lockWrite();){
            TraceObjectStack stack = this.doAddWithInterface(keyList, TraceObjectStack.class);
            stack.getObject().insert(Lifespan.at(snap), TraceObject.ConflictResolution.DENY);
            TraceObjectStack traceObjectStack = stack;
            return traceObjectStack;
        }
    }

    public TraceObjectStackFrame addStackFrame(List<String> keyList, long snap) {
        try (LockHold hold = this.trace.lockWrite();){
            TraceObjectStackFrame frame = this.doAddWithInterface(keyList, TraceObjectStackFrame.class);
            frame.getObject().insert(Lifespan.at(snap), TraceObject.ConflictResolution.DENY);
            TraceObjectStackFrame traceObjectStackFrame = frame;
            return traceObjectStackFrame;
        }
    }

    protected void checkDuplicateThread(String path, Lifespan lifespan) throws DuplicateNameException {
        DBTraceObject exists = this.getObjectByCanonicalPath(TraceObjectKeyPath.parse(path));
        if (exists == null) {
            return;
        }
        if (!exists.getLife().intersects(lifespan)) {
            return;
        }
        throw new DuplicateNameException("A thread having path '" + path + "' already exists within an overlapping snap");
    }

    public TraceObjectThread addThread(String path, String display, Lifespan lifespan) throws DuplicateNameException {
        TraceObjectThread traceObjectThread;
        block8: {
            LockHold hold = this.trace.lockWrite();
            try {
                this.checkDuplicateThread(path, lifespan);
                TraceObjectThread thread = this.doAddWithInterface(path, TraceObjectThread.class);
                thread.setName(lifespan, display);
                thread.getObject().insert(lifespan, TraceObject.ConflictResolution.DENY);
                traceObjectThread = thread;
                if (hold == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (hold != null) {
                        try {
                            hold.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (DuplicateKeyException e) {
                    throw new DuplicateNameException(e.getMessage());
                }
            }
            hold.close();
        }
        return traceObjectThread;
    }

    public boolean checkMyObject(DBTraceObject object) {
        if (object.manager != this) {
            return false;
        }
        return this.getAllObjects().contains(object);
    }

    public TraceThread assertMyThread(TraceThread thread) {
        if (!(thread instanceof DBTraceObjectThread)) {
            throw new AssertionError((Object)("Thread " + thread + " is not an object in this trace"));
        }
        DBTraceObjectThread dbThread = (DBTraceObjectThread)thread;
        if (!this.checkMyObject(dbThread.getObject())) {
            throw new AssertionError((Object)("Thread " + thread + " is not an object in this trace"));
        }
        return dbThread;
    }

    @DBAnnotatedObjectInfo(version=0)
    protected static final class DBTraceObjectSchemaEntry
    extends DBAnnotatedObject {
        public static final String TABLE_NAME = "ObjectSchema";
        static final String CONTEXT_COLUMN_NAME = "Context";
        static final String SCHEMA_COLUMN_NAME = "Schema";
        @DBAnnotatedColumn(value="Context")
        static DBObjectColumn CONTEXT_COLUMN;
        @DBAnnotatedColumn(value="Schema")
        static DBObjectColumn SCHEMA_COLUMN;
        @DBAnnotatedField(column="Context", codec=DBTraceObjectSchemaDBFieldCodec.class)
        private SchemaContext context;
        @DBAnnotatedField(column="Schema")
        private String schemaName;
        private TargetObjectSchema schema;

        public DBTraceObjectSchemaEntry(DBCachedObjectStore<?> store, DBRecord record) {
            super(store, record);
        }

        protected void fresh(boolean created) throws IOException {
            if (created) {
                return;
            }
            this.schema = this.context.getSchema(new TargetObjectSchema.SchemaName(this.schemaName));
        }

        protected void set(TargetObjectSchema schema) {
            this.context = schema.getContext();
            this.schemaName = schema.getName().toString();
            this.update(CONTEXT_COLUMN, SCHEMA_COLUMN);
        }
    }

    public static class DBTraceObjectSchemaDBFieldCodec
    extends DBCachedObjectStoreFactory.AbstractDBFieldCodec<SchemaContext, DBTraceObjectSchemaEntry, StringField> {
        public DBTraceObjectSchemaDBFieldCodec(Class<DBTraceObjectSchemaEntry> objectType, Field field, int column) {
            super(SchemaContext.class, objectType, StringField.class, field, column);
        }

        protected String encode(SchemaContext value) {
            return value == null ? null : XmlSchemaContext.serialize((SchemaContext)value);
        }

        protected SchemaContext decode(String xml) {
            try {
                return xml == null ? null : XmlSchemaContext.deserialize((String)xml);
            }
            catch (JDOMException e) {
                throw new IllegalArgumentException("Invalid XML-encoded schema context");
            }
        }

        public void store(SchemaContext value, StringField f) {
            f.setString(this.encode(value));
        }

        protected void doStore(DBTraceObjectSchemaEntry obj, DBRecord record) throws IllegalAccessException {
            record.setString(this.column, this.encode((SchemaContext)this.getValue(obj)));
        }

        protected void doLoad(DBTraceObjectSchemaEntry obj, DBRecord record) throws IllegalAccessException {
            this.setValue(obj, this.decode(record.getString(this.column)));
        }
    }
}

