/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.symbol;

import ghidra.program.database.function.OverlappingFunctionException;
import ghidra.program.database.symbol.OverlappingNamespaceException;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.PrototypeModel;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.trace.database.program.DBTraceVariableSnapProgramView;
import ghidra.trace.database.symbol.AbstractDBTraceSymbolSingleTypeWithLocationView;
import ghidra.trace.database.symbol.DBTraceFunctionSymbol;
import ghidra.trace.database.symbol.DBTraceLabelSymbol;
import ghidra.trace.database.symbol.DBTraceNamespaceSymbol;
import ghidra.trace.database.symbol.DBTraceSymbolManager;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.symbol.TraceFunctionSymbol;
import ghidra.trace.model.symbol.TraceFunctionSymbolView;
import ghidra.trace.model.symbol.TraceNamespaceSymbol;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.util.LockHold;
import ghidra.util.exception.InvalidInputException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.locks.Lock;

public class DBTraceFunctionSymbolView
extends AbstractDBTraceSymbolSingleTypeWithLocationView<DBTraceFunctionSymbol>
implements TraceFunctionSymbolView {
    protected static final PrototypeModel[] EMPTY_MODEL_LIST = new PrototypeModel[0];

    protected static void assertProperSpace(AddressSpace expected, AddressSetView body) {
        if (!expected.isMemorySpace()) {
            throw new IllegalArgumentException("Function must be in memory space");
        }
        for (AddressRange rng : body) {
            if (rng.getAddressSpace() == expected) continue;
            throw new IllegalArgumentException("Function body must be in same space as entry point");
        }
    }

    public DBTraceFunctionSymbolView(DBTraceSymbolManager manager) {
        super(manager, SymbolType.FUNCTION.getID(), manager.functionStore);
    }

    protected DBTraceNamespaceSymbol doValidateParentAndEntry(DBTraceNamespaceSymbol proposed, Address entryPoint) {
        if (proposed == null) {
            return this.manager.globalNamespace;
        }
        DBTraceVariableSnapProgramView program = this.manager.trace.getProgramView();
        if (!SymbolType.FUNCTION.isValidAddress((Program)program, entryPoint)) {
            throw new IllegalArgumentException("Invalid function entry point: " + entryPoint);
        }
        if (!SymbolType.FUNCTION.isValidParent((Program)program, (Namespace)proposed, entryPoint, false)) {
            throw new IllegalArgumentException("Invalid function namespace: " + proposed);
        }
        return proposed;
    }

    protected SourceType doValidateSource(SourceType proposed, String name, Address entryPoint) {
        if (!SymbolType.FUNCTION.isValidSourceType(proposed, entryPoint)) {
            throw new IllegalArgumentException("Invalid function source type: " + proposed);
        }
        return proposed;
    }

    protected String doValidateName(String proposed, Address entryPoint, SourceType source) throws InvalidInputException {
        if (source == SourceType.DEFAULT) {
            return "";
        }
        SymbolUtilities.validateName((String)proposed);
        return proposed;
    }

    protected void assertNotOverlapping(DBTraceFunctionSymbol exclude, Address entryPoint, Lifespan span, AddressSetView proposedBody) throws OverlappingFunctionException {
        for (AddressRange rng : proposedBody) {
            for (DBTraceFunctionSymbol overlap : this.manager.functions.getIntersecting(span, null, rng, false, true)) {
                if (overlap == exclude) continue;
                throw new OverlappingFunctionException(entryPoint, new OverlappingNamespaceException(rng.getMinAddress(), rng.getMaxAddress()));
            }
        }
    }

    @Override
    public DBTraceFunctionSymbol add(Lifespan lifespan, Address entryPoint, AddressSetView body, String name, TraceFunctionSymbol thunked, TraceNamespaceSymbol parent, SourceType source) throws InvalidInputException, OverlappingFunctionException {
        if (name == null || name.length() == 0 || SymbolUtilities.isReservedDynamicLabelName((String)name, (AddressFactory)this.manager.trace.getBaseAddressFactory())) {
            source = SourceType.DEFAULT;
            name = "";
        } else {
            DBTraceSymbolManager.assertValidName(name);
        }
        if (!"".equals(name) && source == SourceType.DEFAULT) {
            throw new IllegalArgumentException("Cannot create DEFAULT function with non-default name");
        }
        if (!body.contains(entryPoint)) {
            throw new IllegalArgumentException("Function body must contain the entry point");
        }
        DBTraceFunctionSymbolView.assertProperSpace(entryPoint.getAddressSpace(), body);
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            DBTraceFunctionSymbol dbThunked;
            DBTraceNamespaceSymbol dbnsParent = parent == null ? null : this.manager.assertIsMine(parent);
            this.manager.assertValidThreadAddress(null, entryPoint);
            DBTraceFunctionSymbol dBTraceFunctionSymbol = dbThunked = thunked == null ? null : this.manager.assertIsMine(thunked);
            if (this.manager.trace.getCodeManager().definedData().getAt(lifespan.lmin(), entryPoint) != null) {
                throw new IllegalArgumentException("Function entry point cannot be at defined data");
            }
            if (dbThunked != null && name.equals(dbThunked.getName())) {
                source = SourceType.DEFAULT;
                name = "";
            }
            this.assertNotOverlapping(null, entryPoint, lifespan, body);
            dbnsParent = this.doValidateParentAndEntry(dbnsParent, entryPoint);
            source = this.doValidateSource(source, name, entryPoint);
            name = this.doValidateName(name, entryPoint, source);
            DBTraceLabelSymbol toPromote = (DBTraceLabelSymbol)this.manager.labels.getChildWithNameAt(name, lifespan.lmin(), null, entryPoint, dbnsParent);
            if (toPromote != null && toPromote.getLifespan().equals(lifespan)) {
                toPromote.delete();
            }
            DBTraceFunctionSymbol function = (DBTraceFunctionSymbol)this.store.create();
            function.set(lifespan, entryPoint, name, dbThunked, dbnsParent, source);
            function.doCreateReturnParameter();
            for (AddressRange rng : body) {
                this.manager.putID(lifespan, null, rng, function.getID());
            }
            this.cacheForAt.notifyNewEntries(lifespan, body, function);
            this.manager.trace.setChanged(new TraceChangeRecord(Trace.TraceSymbolChangeType.ADDED, null, function));
            DBTraceFunctionSymbol dBTraceFunctionSymbol2 = function;
            return dBTraceFunctionSymbol2;
        }
    }

    @Override
    public Collection<String> getCallingConventionNames() {
        return this.manager.dataTypeManager.getDefinedCallingConventionNames();
    }

    @Override
    public PrototypeModel getDefaultCallingConvention() {
        return this.manager.dataTypeManager.getDefaultCallingConvention();
    }

    @Override
    public PrototypeModel getCallingConvention(String name) {
        return this.manager.dataTypeManager.getCallingConvention(name);
    }

    public static Variable getReferencedVariable(Function function, Address instrAddr, Address storageAddr, int size, boolean isRead, Language language) {
        Variable[] variables = function.getAllVariables();
        Parameter paramCandidate = null;
        ArrayList<Variable> localCandidates = null;
        Variable firstCandidate = null;
        size = Math.min(1, size);
        Register register = language.getRegister(storageAddr, size);
        for (Variable var : variables) {
            VariableStorage varStorage = var.getVariableStorage();
            if ((register == null || !varStorage.intersects(register)) && (register != null || !varStorage.contains(storageAddr))) continue;
            if (var instanceof Parameter) {
                paramCandidate = (Parameter)var;
                continue;
            }
            if (firstCandidate != null) {
                if (localCandidates == null) {
                    localCandidates = new ArrayList<Variable>();
                    localCandidates.add(firstCandidate);
                }
                localCandidates.add(var);
                continue;
            }
            firstCandidate = var;
        }
        int useOffset = (int)instrAddr.subtract(function.getEntryPoint());
        if (isRead) {
            if (useOffset == 0) {
                return paramCandidate;
            }
            --useOffset;
        }
        if (useOffset < 0) {
            useOffset = Integer.MAX_VALUE - useOffset;
        }
        if (localCandidates == null) {
            if (firstCandidate != null) {
                int varFirstUse = firstCandidate.getFirstUseOffset();
                if (varFirstUse < 0) {
                    varFirstUse = Integer.MAX_VALUE - varFirstUse;
                }
                if (varFirstUse <= useOffset) {
                    return firstCandidate;
                }
            }
            return null;
        }
        Parameter bestVar = null;
        int bestFirstUse = 0;
        for (Variable var : localCandidates) {
            int varFirstUse = var.getFirstUseOffset();
            if (varFirstUse < 0) {
                varFirstUse = Integer.MAX_VALUE - varFirstUse;
            }
            if (varFirstUse > useOffset || bestVar != null && bestFirstUse >= varFirstUse) continue;
            bestVar = var;
            bestFirstUse = varFirstUse;
        }
        if (bestVar == null) {
            bestVar = paramCandidate;
        }
        return bestVar;
    }
}

