/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.catacombae.hfsexplorer.Util;
import org.jdesktop.layout.GroupLayout;

public class MemoryStatisticsPanel
extends JPanel {
    private final Object syncObj = new Object();
    private boolean abortThread = false;
    private JTextField allocatedMemoryField;
    private JTextField currentMaxMemoryField;
    private JTextField freeMemoryField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JTextField maxMemoryField;
    private JButton runGcButton;

    public MemoryStatisticsPanel() {
        this.initComponents();
        this.runGcButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Runtime.getRuntime().gc();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startThread() {
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                Runtime rt = Runtime.getRuntime();
                Object object = MemoryStatisticsPanel.this.syncObj;
                synchronized (object) {
                    while (true) {
                        if (MemoryStatisticsPanel.this.abortThread) {
                            MemoryStatisticsPanel.this.syncObj.notify();
                            // MONITOREXIT @DISABLED, blocks:[2, 4, 5] lbl7 : MonitorExitStatement: MONITOREXIT : var2_2
                            System.err.println("MemoryStatisticsPanel thread aborted.");
                            return;
                        }
                        final long curMaxMem = rt.totalMemory();
                        final long maxMem = rt.maxMemory();
                        final long freeMem = rt.freeMemory();
                        final long allocatedMem = curMaxMem - freeMem;
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                MemoryStatisticsPanel.this.allocatedMemoryField.setText(Util.addUnitSpaces("" + allocatedMem, 3) + " bytes");
                                MemoryStatisticsPanel.this.freeMemoryField.setText(Util.addUnitSpaces("" + freeMem, 3) + " bytes");
                                MemoryStatisticsPanel.this.currentMaxMemoryField.setText(Util.addUnitSpaces("" + curMaxMem, 3) + " bytes");
                                MemoryStatisticsPanel.this.maxMemoryField.setText(Util.addUnitSpaces("" + maxMem, 3) + " bytes");
                            }
                        });
                        try {
                            MemoryStatisticsPanel.this.syncObj.wait(500L);
                        }
                        catch (InterruptedException ie) {
                            ie.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }
            }
        };
        Object object = this.syncObj;
        synchronized (object) {
            new Thread(r).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopThread() {
        Object object = this.syncObj;
        synchronized (object) {
            this.abortThread = true;
            this.syncObj.notify();
            try {
                this.syncObj.wait();
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
        }
    }

    public static JFrame createMemoryStatisticsWindow() {
        final JFrame memoryStatisticsWindow = new JFrame("Memory statistics");
        final MemoryStatisticsPanel msp = new MemoryStatisticsPanel();
        memoryStatisticsWindow.add(msp);
        memoryStatisticsWindow.setDefaultCloseOperation(0);
        memoryStatisticsWindow.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent e) {
                msp.startThread();
            }

            public void windowClosing(WindowEvent e) {
                msp.stopThread();
                memoryStatisticsWindow.dispose();
            }
        });
        memoryStatisticsWindow.pack();
        memoryStatisticsWindow.setLocationRelativeTo(null);
        memoryStatisticsWindow.setResizable(false);
        return memoryStatisticsWindow;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.runGcButton = new JButton();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.allocatedMemoryField = new JTextField();
        this.freeMemoryField = new JTextField();
        this.currentMaxMemoryField = new JTextField();
        this.maxMemoryField = new JTextField();
        this.jLabel1.setText("Allocated memory:");
        this.runGcButton.setText("Run GC");
        this.jLabel2.setText("Free memory:");
        this.jLabel3.setText("Current max:");
        this.jLabel4.setText("Total max:");
        this.allocatedMemoryField.setEditable(false);
        this.allocatedMemoryField.setBorder(null);
        this.allocatedMemoryField.setOpaque(false);
        this.freeMemoryField.setEditable(false);
        this.freeMemoryField.setBorder(null);
        this.freeMemoryField.setOpaque(false);
        this.currentMaxMemoryField.setEditable(false);
        this.currentMaxMemoryField.setBorder(null);
        this.currentMaxMemoryField.setOpaque(false);
        this.maxMemoryField.setEditable(false);
        this.maxMemoryField.setBorder(null);
        this.maxMemoryField.setOpaque(false);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel1).add((Component)this.jLabel2).add((Component)this.jLabel3).add((Component)this.jLabel4)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.freeMemoryField, -1, 228, Short.MAX_VALUE).add((Component)this.allocatedMemoryField, -1, 228, Short.MAX_VALUE).add((Component)this.currentMaxMemoryField, -1, 228, Short.MAX_VALUE).add((Component)this.maxMemoryField, -1, 228, Short.MAX_VALUE))).add(2, (Component)this.runGcButton)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.allocatedMemoryField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.freeMemoryField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.currentMaxMemoryField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel4).add((Component)this.maxMemoryField, -2, -1, -2)).addPreferredGap(0).add((Component)this.runGcButton).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

