/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.dmgextractor.encodings.encrypted;

import java.io.PrintStream;
import org.catacombae.dmgextractor.Util;

public class V1Header {
    public static final int STRUCTSIZE = 1276;
    private final byte[] unknown0 = new byte[16];
    private final byte[] blockSize = new byte[4];
    private final byte[] unknownInt20 = new byte[4];
    private final byte[] unknownInt24 = new byte[4];
    private final byte[] unknownInt28 = new byte[4];
    private final byte[] unknownInt32 = new byte[4];
    private final byte[] unknownInt36 = new byte[4];
    private final byte[] unknownInt40 = new byte[4];
    private final byte[] unknownInt44 = new byte[4];
    private final byte[] kdfIterationCount = new byte[4];
    private final byte[] kdfSaltLen = new byte[4];
    private final byte[] kdfSalt = new byte[32];
    private final byte[] unknownInt88 = new byte[4];
    private final byte[] unknownInt92 = new byte[4];
    private final byte[] unknownInt96 = new byte[4];
    private final byte[] unknownInt100 = new byte[4];
    private final byte[] unwrapIv = new byte[32];
    private final byte[] lenWrappedAesKey = new byte[4];
    private final byte[] wrappedAesKey = new byte[256];
    private final byte[] unknownInt396 = new byte[4];
    private final byte[] unknownInt400 = new byte[4];
    private final byte[] unknown404 = new byte[32];
    private final byte[] lenWrappedHmacSha1Key = new byte[4];
    private final byte[] wrappedHmacSha1Key = new byte[256];
    private final byte[] unknownInt696 = new byte[4];
    private final byte[] unknownInt700 = new byte[4];
    private final byte[] unknown704 = new byte[32];
    private final byte[] lenWrappedIntegrityKey = new byte[4];
    private final byte[] wrappedIntegrityKey = new byte[256];
    private final byte[] lenUnknown1000 = new byte[4];
    private final byte[] unknown1000 = new byte[256];
    private final byte[] decryptedDataLength = new byte[8];
    private final byte[] possibleHeaderVersion = new byte[4];
    private final byte[] signature = new byte[8];

    public V1Header(byte[] data, int offset) {
        System.arraycopy(data, offset + 0, this.unknown0, 0, 16);
        System.arraycopy(data, offset + 16, this.blockSize, 0, 4);
        System.arraycopy(data, offset + 20, this.unknownInt20, 0, 4);
        System.arraycopy(data, offset + 24, this.unknownInt24, 0, 4);
        System.arraycopy(data, offset + 28, this.unknownInt28, 0, 4);
        System.arraycopy(data, offset + 32, this.unknownInt32, 0, 4);
        System.arraycopy(data, offset + 36, this.unknownInt36, 0, 4);
        System.arraycopy(data, offset + 40, this.unknownInt40, 0, 4);
        System.arraycopy(data, offset + 44, this.unknownInt44, 0, 4);
        System.arraycopy(data, offset + 48, this.kdfIterationCount, 0, 4);
        System.arraycopy(data, offset + 52, this.kdfSaltLen, 0, 4);
        System.arraycopy(data, offset + 56, this.kdfSalt, 0, 32);
        System.arraycopy(data, offset + 88, this.unknownInt88, 0, 4);
        System.arraycopy(data, offset + 92, this.unknownInt92, 0, 4);
        System.arraycopy(data, offset + 96, this.unknownInt96, 0, 4);
        System.arraycopy(data, offset + 100, this.unknownInt100, 0, 4);
        System.arraycopy(data, offset + 104, this.unwrapIv, 0, 32);
        System.arraycopy(data, offset + 136, this.lenWrappedAesKey, 0, 4);
        System.arraycopy(data, offset + 140, this.wrappedAesKey, 0, 256);
        System.arraycopy(data, offset + 396, this.unknownInt396, 0, 4);
        System.arraycopy(data, offset + 400, this.unknownInt400, 0, 4);
        System.arraycopy(data, offset + 404, this.unknown404, 0, 32);
        System.arraycopy(data, offset + 436, this.lenWrappedHmacSha1Key, 0, 4);
        System.arraycopy(data, offset + 440, this.wrappedHmacSha1Key, 0, 256);
        System.arraycopy(data, offset + 696, this.unknownInt696, 0, 4);
        System.arraycopy(data, offset + 700, this.unknownInt700, 0, 4);
        System.arraycopy(data, offset + 704, this.unknown704, 0, 32);
        System.arraycopy(data, offset + 736, this.lenWrappedIntegrityKey, 0, 4);
        System.arraycopy(data, offset + 740, this.wrappedIntegrityKey, 0, 256);
        System.arraycopy(data, offset + 996, this.lenUnknown1000, 0, 4);
        System.arraycopy(data, offset + 1000, this.unknown1000, 0, 256);
        System.arraycopy(data, offset + 1256, this.decryptedDataLength, 0, 8);
        System.arraycopy(data, offset + 1264, this.possibleHeaderVersion, 0, 4);
        System.arraycopy(data, offset + 1268, this.signature, 0, 8);
    }

    public static int length() {
        return 1276;
    }

    public byte[] getUnknown0() {
        return Util.readByteArrayBE(this.unknown0);
    }

    public int getBlockSize() {
        return Util.readIntBE(this.blockSize);
    }

    public int getUnknownInt20() {
        return Util.readIntBE(this.unknownInt20);
    }

    public int getUnknownInt24() {
        return Util.readIntBE(this.unknownInt24);
    }

    public int getUnknownInt28() {
        return Util.readIntBE(this.unknownInt28);
    }

    public int getUnknownInt32() {
        return Util.readIntBE(this.unknownInt32);
    }

    public int getUnknownInt36() {
        return Util.readIntBE(this.unknownInt36);
    }

    public int getUnknownInt40() {
        return Util.readIntBE(this.unknownInt40);
    }

    public int getUnknownInt44() {
        return Util.readIntBE(this.unknownInt44);
    }

    public int getKdfIterationCount() {
        return Util.readIntBE(this.kdfIterationCount);
    }

    public int getKdfSaltLen() {
        return Util.readIntBE(this.kdfSaltLen);
    }

    public byte[] getKdfSalt() {
        return Util.readByteArrayBE(this.kdfSalt);
    }

    public int getUnknownInt88() {
        return Util.readIntBE(this.unknownInt88);
    }

    public int getUnknownInt92() {
        return Util.readIntBE(this.unknownInt92);
    }

    public int getUnknownInt96() {
        return Util.readIntBE(this.unknownInt96);
    }

    public int getUnknownInt100() {
        return Util.readIntBE(this.unknownInt100);
    }

    public byte[] getUnwrapIv() {
        return Util.readByteArrayBE(this.unwrapIv);
    }

    public int getLenWrappedAesKey() {
        return Util.readIntBE(this.lenWrappedAesKey);
    }

    public byte[] getWrappedAesKey() {
        return Util.readByteArrayBE(this.wrappedAesKey);
    }

    public int getUnknownInt396() {
        return Util.readIntBE(this.unknownInt396);
    }

    public int getUnknownInt400() {
        return Util.readIntBE(this.unknownInt400);
    }

    public byte[] getUnknown404() {
        return Util.readByteArrayBE(this.unknown404);
    }

    public int getLenWrappedHmacSha1Key() {
        return Util.readIntBE(this.lenWrappedHmacSha1Key);
    }

    public byte[] getWrappedHmacSha1Key() {
        return Util.readByteArrayBE(this.wrappedHmacSha1Key);
    }

    public int getUnknownInt696() {
        return Util.readIntBE(this.unknownInt696);
    }

    public int getUnknownInt700() {
        return Util.readIntBE(this.unknownInt700);
    }

    public byte[] getUnknown704() {
        return Util.readByteArrayBE(this.unknown704);
    }

    public int getLenWrappedIntegrityKey() {
        return Util.readIntBE(this.lenWrappedIntegrityKey);
    }

    public byte[] getWrappedIntegrityKey() {
        return Util.readByteArrayBE(this.wrappedIntegrityKey);
    }

    public int getLenUnknown1000() {
        return Util.readIntBE(this.lenUnknown1000);
    }

    public byte[] getUnknown1000() {
        return Util.readByteArrayBE(this.unknown1000);
    }

    public long getDecryptedDataLength() {
        return Util.readLongBE(this.decryptedDataLength);
    }

    public int getPossibleHeaderVersion() {
        return Util.readIntBE(this.possibleHeaderVersion);
    }

    public byte[] getSignature() {
        return Util.readByteArrayBE(this.signature);
    }

    public void printFields(PrintStream ps, String prefix) {
        ps.println(prefix + " unknown0: 0x" + Util.byteArrayToHexString(this.getUnknown0()));
        ps.println(prefix + " blockSize: " + Util.unsign(this.getBlockSize()));
        ps.println(prefix + " unknownInt20: " + this.getUnknownInt20());
        ps.println(prefix + " unknownInt24: " + this.getUnknownInt24());
        ps.println(prefix + " unknownInt28: " + this.getUnknownInt28());
        ps.println(prefix + " unknownInt32: " + this.getUnknownInt32());
        ps.println(prefix + " unknownInt36: " + this.getUnknownInt36());
        ps.println(prefix + " unknownInt40: " + this.getUnknownInt40());
        ps.println(prefix + " unknownInt44: " + this.getUnknownInt44());
        ps.println(prefix + " kdfIterationCount: " + Util.unsign(this.getKdfIterationCount()));
        ps.println(prefix + " kdfSaltLen: " + Util.unsign(this.getKdfSaltLen()));
        ps.println(prefix + " kdfSalt: 0x" + Util.byteArrayToHexString(this.getKdfSalt()));
        ps.println(prefix + " unknownInt88: " + this.getUnknownInt88());
        ps.println(prefix + " unknownInt92: " + this.getUnknownInt92());
        ps.println(prefix + " unknownInt96: " + this.getUnknownInt96());
        ps.println(prefix + " unknownInt100: " + this.getUnknownInt100());
        ps.println(prefix + " unwrapIv: 0x" + Util.byteArrayToHexString(this.getUnwrapIv()));
        ps.println(prefix + " lenWrappedAesKey: " + Util.unsign(this.getLenWrappedAesKey()));
        ps.println(prefix + " wrappedAesKey: 0x" + Util.byteArrayToHexString(this.getWrappedAesKey()));
        ps.println(prefix + " unknownInt396: " + this.getUnknownInt396());
        ps.println(prefix + " unknownInt400: " + this.getUnknownInt400());
        ps.println(prefix + " unknown404: 0x" + Util.byteArrayToHexString(this.getUnknown404()));
        ps.println(prefix + " lenWrappedHmacSha1Key: " + Util.unsign(this.getLenWrappedHmacSha1Key()));
        ps.println(prefix + " wrappedHmacSha1Key: 0x" + Util.byteArrayToHexString(this.getWrappedHmacSha1Key()));
        ps.println(prefix + " unknownInt696: " + this.getUnknownInt696());
        ps.println(prefix + " unknownInt700: " + this.getUnknownInt700());
        ps.println(prefix + " unknown704: 0x" + Util.byteArrayToHexString(this.getUnknown704()));
        ps.println(prefix + " lenWrappedIntegrityKey: " + Util.unsign(this.getLenWrappedIntegrityKey()));
        ps.println(prefix + " wrappedIntegrityKey: 0x" + Util.byteArrayToHexString(this.getWrappedIntegrityKey()));
        ps.println(prefix + " lenUnknown1000: " + this.getLenUnknown1000());
        ps.println(prefix + " unknown1000: 0x" + Util.byteArrayToHexString(this.getUnknown1000()));
        ps.println(prefix + " decryptedDataLength: " + this.getDecryptedDataLength());
        ps.println(prefix + " possibleHeaderVersion: " + this.getPossibleHeaderVersion());
        ps.println(prefix + " signature: \"" + Util.toASCIIString(this.getSignature()) + "\"");
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "V1Header:");
        this.printFields(ps, prefix);
    }

    public byte[] getBytes() {
        byte[] result = new byte[V1Header.length()];
        int offset = 0;
        System.arraycopy(this.unknown0, 0, result, offset, this.unknown0.length);
        System.arraycopy(this.blockSize, 0, result, offset += this.unknown0.length, this.blockSize.length);
        System.arraycopy(this.unknownInt20, 0, result, offset += this.blockSize.length, this.unknownInt20.length);
        System.arraycopy(this.unknownInt24, 0, result, offset += this.unknownInt20.length, this.unknownInt24.length);
        System.arraycopy(this.unknownInt28, 0, result, offset += this.unknownInt24.length, this.unknownInt28.length);
        System.arraycopy(this.unknownInt32, 0, result, offset += this.unknownInt28.length, this.unknownInt32.length);
        System.arraycopy(this.unknownInt36, 0, result, offset += this.unknownInt32.length, this.unknownInt36.length);
        System.arraycopy(this.unknownInt40, 0, result, offset += this.unknownInt36.length, this.unknownInt40.length);
        System.arraycopy(this.unknownInt44, 0, result, offset += this.unknownInt40.length, this.unknownInt44.length);
        System.arraycopy(this.kdfIterationCount, 0, result, offset += this.unknownInt44.length, this.kdfIterationCount.length);
        System.arraycopy(this.kdfSaltLen, 0, result, offset += this.kdfIterationCount.length, this.kdfSaltLen.length);
        System.arraycopy(this.kdfSalt, 0, result, offset += this.kdfSaltLen.length, this.kdfSalt.length);
        System.arraycopy(this.unknownInt88, 0, result, offset += this.kdfSalt.length, this.unknownInt88.length);
        System.arraycopy(this.unknownInt92, 0, result, offset += this.unknownInt88.length, this.unknownInt92.length);
        System.arraycopy(this.unknownInt96, 0, result, offset += this.unknownInt92.length, this.unknownInt96.length);
        System.arraycopy(this.unknownInt100, 0, result, offset += this.unknownInt96.length, this.unknownInt100.length);
        System.arraycopy(this.unwrapIv, 0, result, offset += this.unknownInt100.length, this.unwrapIv.length);
        System.arraycopy(this.lenWrappedAesKey, 0, result, offset += this.unwrapIv.length, this.lenWrappedAesKey.length);
        System.arraycopy(this.wrappedAesKey, 0, result, offset += this.lenWrappedAesKey.length, this.wrappedAesKey.length);
        System.arraycopy(this.unknownInt396, 0, result, offset += this.wrappedAesKey.length, this.unknownInt396.length);
        System.arraycopy(this.unknownInt400, 0, result, offset += this.unknownInt396.length, this.unknownInt400.length);
        System.arraycopy(this.unknown404, 0, result, offset += this.unknownInt400.length, this.unknown404.length);
        System.arraycopy(this.lenWrappedHmacSha1Key, 0, result, offset += this.unknown404.length, this.lenWrappedHmacSha1Key.length);
        System.arraycopy(this.wrappedHmacSha1Key, 0, result, offset += this.lenWrappedHmacSha1Key.length, this.wrappedHmacSha1Key.length);
        System.arraycopy(this.unknownInt696, 0, result, offset += this.wrappedHmacSha1Key.length, this.unknownInt696.length);
        System.arraycopy(this.unknownInt700, 0, result, offset += this.unknownInt696.length, this.unknownInt700.length);
        System.arraycopy(this.unknown704, 0, result, offset += this.unknownInt700.length, this.unknown704.length);
        System.arraycopy(this.lenWrappedIntegrityKey, 0, result, offset += this.unknown704.length, this.lenWrappedIntegrityKey.length);
        System.arraycopy(this.wrappedIntegrityKey, 0, result, offset += this.lenWrappedIntegrityKey.length, this.wrappedIntegrityKey.length);
        System.arraycopy(this.lenUnknown1000, 0, result, offset += this.wrappedIntegrityKey.length, this.lenUnknown1000.length);
        System.arraycopy(this.unknown1000, 0, result, offset += this.lenUnknown1000.length, this.unknown1000.length);
        System.arraycopy(this.decryptedDataLength, 0, result, offset += this.unknown1000.length, this.decryptedDataLength.length);
        System.arraycopy(this.possibleHeaderVersion, 0, result, offset += this.decryptedDataLength.length, this.possibleHeaderVersion.length);
        System.arraycopy(this.signature, 0, result, offset += this.possibleHeaderVersion.length, this.signature.length);
        offset += this.signature.length;
        return result;
    }
}

