/* ###
 * IP: GHIDRA
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ghidra.app.util;

import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTargetDropEvent;

import ghidra.framework.plugintool.PluginTool;

/**
 * Interface for classes that will handle drop actions for files dropped onto the tool
 */
public interface FileOpenDataFlavorHandler {
	public void handle(PluginTool tool, Object obj, DropTargetDropEvent e, DataFlavor f);
}
