/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.types.resff;

import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import org.catacombae.csjc.DynamicStruct;
import org.catacombae.csjc.PrintableStruct;
import org.catacombae.hfsexplorer.Util;
import org.catacombae.hfsexplorer.io.SynchronizedReadableRandomAccess;

public class ResourceName
implements DynamicStruct,
PrintableStruct {
    private final byte nameLength;
    private final byte[] name;

    public ResourceName(SynchronizedReadableRandomAccess stream, long offset) {
        byte[] nameLengthArray = new byte[1];
        stream.readFullyFrom(offset, nameLengthArray);
        this.nameLength = nameLengthArray[0];
        this.name = new byte[this.getNameLength()];
        stream.readFullyFrom(offset + 1L, this.name);
    }

    public short getNameLength() {
        return Util.unsign(this.nameLength);
    }

    public byte[] getName() {
        return Util.readByteArrayBE(this.name);
    }

    public void printFields(PrintStream ps, String prefix) {
        ps.println(prefix + " nameLength: " + this.getNameLength());
        try {
            ps.println(prefix + " name: " + new String(this.getName(), "MacRoman"));
        }
        catch (UnsupportedEncodingException ex) {
            ps.println(prefix + " name: 0x" + Util.byteArrayToHexString(this.getName()) + " (non-decodable)");
        }
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "ResourceName:");
        this.printFields(ps, prefix);
    }

    public byte[] getBytes() {
        byte[] result = new byte[this.occupiedSize()];
        int offset = 0;
        result[offset] = this.nameLength;
        System.arraycopy(this.name, 0, result, ++offset, this.name.length);
        offset += this.name.length;
        return result;
    }

    public int maxSize() {
        return 255;
    }

    public int occupiedSize() {
        return 1 + this.name.length;
    }
}

