/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.types.hfsplus;

import java.io.PrintStream;
import java.util.Date;
import org.catacombae.csjc.StaticStruct;
import org.catacombae.csjc.StructElements;
import org.catacombae.csjc.structelements.Dictionary;
import org.catacombae.hfsexplorer.Util;
import org.catacombae.hfsexplorer.types.finder.ExtendedFileInfo;
import org.catacombae.hfsexplorer.types.finder.FileInfo;
import org.catacombae.hfsexplorer.types.hfsplus.HFSCatalogNodeID;
import org.catacombae.hfsexplorer.types.hfsplus.HFSPlusBSDInfo;
import org.catacombae.hfsexplorer.types.hfsplus.HFSPlusCatalogAttributes;
import org.catacombae.hfsexplorer.types.hfsplus.HFSPlusCatalogLeafRecordData;
import org.catacombae.hfsexplorer.types.hfsplus.HFSPlusDate;
import org.catacombae.hfsexplorer.types.hfsplus.HFSPlusDateField;
import org.catacombae.hfsexplorer.types.hfsplus.HFSPlusForkData;

public class HFSPlusCatalogFile
extends HFSPlusCatalogLeafRecordData
implements HFSPlusCatalogAttributes,
StaticStruct {
    private final byte[] recordType = new byte[2];
    private final byte[] flags = new byte[2];
    private final byte[] reserved1 = new byte[4];
    private final HFSCatalogNodeID fileID;
    private final byte[] createDate = new byte[4];
    private final byte[] contentModDate = new byte[4];
    private final byte[] attributeModDate = new byte[4];
    private final byte[] accessDate = new byte[4];
    private final byte[] backupDate = new byte[4];
    private final HFSPlusBSDInfo permissions;
    private final FileInfo userInfo;
    private final ExtendedFileInfo finderInfo;
    private final byte[] textEncoding = new byte[4];
    private final byte[] reserved2 = new byte[4];
    private final HFSPlusForkData dataFork;
    private final HFSPlusForkData resourceFork;

    public HFSPlusCatalogFile(byte[] data, int offset) {
        System.arraycopy(data, offset + 0, this.recordType, 0, 2);
        System.arraycopy(data, offset + 2, this.flags, 0, 2);
        System.arraycopy(data, offset + 4, this.reserved1, 0, 4);
        this.fileID = new HFSCatalogNodeID(data, offset + 8);
        System.arraycopy(data, offset + 12, this.createDate, 0, 4);
        System.arraycopy(data, offset + 16, this.contentModDate, 0, 4);
        System.arraycopy(data, offset + 20, this.attributeModDate, 0, 4);
        System.arraycopy(data, offset + 24, this.accessDate, 0, 4);
        System.arraycopy(data, offset + 28, this.backupDate, 0, 4);
        this.permissions = new HFSPlusBSDInfo(data, offset + 32);
        this.userInfo = new FileInfo(data, offset + 48);
        this.finderInfo = new ExtendedFileInfo(data, offset + 64);
        System.arraycopy(data, offset + 80, this.textEncoding, 0, 4);
        System.arraycopy(data, offset + 84, this.reserved2, 0, 4);
        this.dataFork = new HFSPlusForkData(data, offset + 88);
        this.resourceFork = new HFSPlusForkData(data, offset + 168);
    }

    public static int length() {
        return 248;
    }

    public short getRecordType() {
        return Util.readShortBE(this.recordType);
    }

    public short getFlags() {
        return Util.readShortBE(this.flags);
    }

    public int getReserved1() {
        return Util.readIntBE(this.reserved1);
    }

    public HFSCatalogNodeID getFileID() {
        return this.fileID;
    }

    public int getCreateDate() {
        return Util.readIntBE(this.createDate);
    }

    public int getContentModDate() {
        return Util.readIntBE(this.contentModDate);
    }

    public int getAttributeModDate() {
        return Util.readIntBE(this.attributeModDate);
    }

    public int getAccessDate() {
        return Util.readIntBE(this.accessDate);
    }

    public int getBackupDate() {
        return Util.readIntBE(this.backupDate);
    }

    public HFSPlusBSDInfo getPermissions() {
        return this.permissions;
    }

    public FileInfo getUserInfo() {
        return this.userInfo;
    }

    public ExtendedFileInfo getFinderInfo() {
        return this.finderInfo;
    }

    public int getTextEncoding() {
        return Util.readIntBE(this.textEncoding);
    }

    public int getReserved2() {
        return Util.readIntBE(this.reserved2);
    }

    public HFSPlusForkData getDataFork() {
        return this.dataFork;
    }

    public HFSPlusForkData getResourceFork() {
        return this.resourceFork;
    }

    public boolean getFileLockedFlag() {
        return (this.getFlags() & 1) != 0;
    }

    public boolean getThreadExistsFlag() {
        return (this.getFlags() & 2) != 0;
    }

    public Date getCreateDateAsDate() {
        return HFSPlusDate.gmtTimestampToDate(this.getCreateDate());
    }

    public Date getContentModDateAsDate() {
        return HFSPlusDate.gmtTimestampToDate(this.getContentModDate());
    }

    public Date getAttributeModDateAsDate() {
        return HFSPlusDate.gmtTimestampToDate(this.getAttributeModDate());
    }

    public Date getAccessDateAsDate() {
        return HFSPlusDate.gmtTimestampToDate(this.getAccessDate());
    }

    public Date getBackupDateAsDate() {
        return HFSPlusDate.gmtTimestampToDate(this.getBackupDate());
    }

    public Dictionary getStructElements() {
        StructElements.DictionaryBuilder db = new StructElements.DictionaryBuilder(HFSPlusCatalogFile.class.getSimpleName());
        db.addFlag("fileLocked", this.flags, 0);
        db.addFlag("threadExists", this.flags, 1);
        db.addUIntBE("reserved1", this.reserved1);
        db.add("fileID", this.fileID.getStructElements());
        db.add("createDate", new HFSPlusDateField(this.createDate, false));
        db.add("contentModDate", new HFSPlusDateField(this.contentModDate, false));
        db.add("attributeModDate", new HFSPlusDateField(this.attributeModDate, false));
        db.add("accessDate", new HFSPlusDateField(this.accessDate, false));
        db.add("backupDate", new HFSPlusDateField(this.backupDate, false));
        db.add("permissions", this.permissions.getStructElements());
        db.add("userInfo", this.userInfo.getStructElements());
        db.add("finderInfo", this.finderInfo.getStructElements());
        db.addUIntBE("textEncoding", this.textEncoding);
        db.addUIntBE("reserved2", this.reserved2);
        db.add("dataFork", this.dataFork.getStructElements());
        db.add("resourceFork", this.resourceFork.getStructElements());
        return db.getResult();
    }

    public void printFields(PrintStream ps, String prefix) {
        ps.println(prefix + " recordType: " + this.getRecordType());
        ps.println(prefix + " flags: " + this.getFlags());
        ps.println(prefix + " reserved1: " + this.getReserved1());
        ps.println(prefix + " fileID: ");
        this.getFileID().print(ps, prefix + "  ");
        ps.println(prefix + " createDate: " + this.getCreateDateAsDate());
        ps.println(prefix + " contentModDate: " + this.getContentModDateAsDate());
        ps.println(prefix + " attributeModDate: " + this.getAttributeModDateAsDate());
        ps.println(prefix + " accessDate: " + this.getAccessDateAsDate());
        ps.println(prefix + " backupDate: " + this.getBackupDateAsDate());
        ps.println(prefix + " permissions: ");
        this.getPermissions().print(ps, prefix + "  ");
        ps.println(prefix + " userInfo: ");
        this.getUserInfo().print(ps, prefix + "  ");
        ps.println(prefix + " finderInfo: ");
        this.getFinderInfo().print(ps, prefix + "  ");
        ps.println(prefix + " textEncoding: " + this.getTextEncoding());
        ps.println(prefix + " reserved2: " + this.getReserved2());
        ps.println(prefix + " dataFork: ");
        this.getDataFork().print(ps, prefix + "  ");
        ps.println(prefix + " resourceFork: ");
        this.getResourceFork().print(ps, prefix + "  ");
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "HFSPlusCatalogFile:");
        this.printFields(ps, prefix);
    }

    public byte[] getBytes() {
        byte[] result = new byte[HFSPlusCatalogFile.length()];
        int offset = 0;
        System.arraycopy(this.recordType, 0, result, offset, this.recordType.length);
        System.arraycopy(this.flags, 0, result, offset += this.recordType.length, this.flags.length);
        System.arraycopy(this.reserved1, 0, result, offset += this.flags.length, this.reserved1.length);
        byte[] tempData = this.fileID.getBytes();
        System.arraycopy(tempData, 0, result, offset += this.reserved1.length, tempData.length);
        System.arraycopy(this.createDate, 0, result, offset += tempData.length, this.createDate.length);
        System.arraycopy(this.contentModDate, 0, result, offset += this.createDate.length, this.contentModDate.length);
        System.arraycopy(this.attributeModDate, 0, result, offset += this.contentModDate.length, this.attributeModDate.length);
        System.arraycopy(this.accessDate, 0, result, offset += this.attributeModDate.length, this.accessDate.length);
        System.arraycopy(this.backupDate, 0, result, offset += this.accessDate.length, this.backupDate.length);
        tempData = this.permissions.getBytes();
        System.arraycopy(tempData, 0, result, offset += this.backupDate.length, tempData.length);
        offset += tempData.length;
        tempData = this.userInfo.getBytes();
        System.arraycopy(tempData, 0, result, offset, tempData.length);
        offset += tempData.length;
        tempData = this.finderInfo.getBytes();
        System.arraycopy(tempData, 0, result, offset, tempData.length);
        System.arraycopy(this.textEncoding, 0, result, offset += tempData.length, this.textEncoding.length);
        System.arraycopy(this.reserved2, 0, result, offset += this.textEncoding.length, this.reserved2.length);
        tempData = this.dataFork.getBytes();
        System.arraycopy(tempData, 0, result, offset += this.reserved2.length, tempData.length);
        offset += tempData.length;
        tempData = this.resourceFork.getBytes();
        System.arraycopy(tempData, 0, result, offset, tempData.length);
        offset += tempData.length;
        return result;
    }

    public int size() {
        return HFSPlusCatalogFile.length();
    }
}

