/*
 * Copyright (c) 2021, 2022, 2023 Mark Jamsek <mark@jamsek.com>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#define FNC_VERSION	VERSION  /* cf. Makefile */
#define FNC_HASH	HASH
#define FNC_DATE	DATE

#ifdef FCLI_USE_SIGACTION
#define FCLI_USE_SIGACTION 0	/* we want ^c to exit */
#endif

/* Utility macros. */
#define MIN(_a, _b)	((_a) < (_b) ? (_a) : (_b))
#define MAX(_a, _b)	((_a) > (_b) ? (_a) : (_b))
#define ABS(_n)		((_n) >= 0 ? (_n) : -(_n))
#ifndef CTRL
#define CTRL(key)	((key) & 037)	/* ^key input */
#endif
#define nitems(_a)		(sizeof((_a)) / sizeof((_a)[0]))
#define ndigits(_d, _n)		do { _d++; } while (_n /= 10)
#define STRINGIFYOUT(_s)	#_s
#define STRINGIFY(_s)		STRINGIFYOUT(_s)
#define CONCATOUT(_a, _b)	_a ## _b
#define CONCAT(_a, _b)		CONCATOUT(_a, _b)
#define FILE_POSITION		__FILE__ ":" STRINGIFY(__LINE__)
#define FLAG_SET(_f, _b)	((_f) |= (_b))
#define FLAG_CHK(_f, _b)	((_f) & (_b))
#define FLAG_TOG(_f, _b)	((_f) ^= (_b))
#define FLAG_CLR(_f, _b)	((_f) &= ~(_b))

/* Application macros. */
#define PRINT_VERSION	STRINGIFY(FNC_VERSION)
#define PRINT_HASH	STRINGIFY(FNC_HASH)
#define PRINT_DATE	STRINGIFY(FNC_DATE)
#define DEF_DIFF_CTX	5		/* Default diff context lines. */
#define MAX_DIFF_CTX	64		/* Max diff context lines. */
#define HSPLIT_SCALE	0.4		/* Default horizontal split scale. */
#define SPIN_INTERVAL	200		/* Status line progress indicator. */
#define LINENO_WIDTH	6		/* View lineno max column width. */
#define MAX_PCT_LEN	7		/* Line position upto max len 99.99% */
#define SPINNER		"\\|/-\0"
#define NULL_DEVICE	"/dev/null"
#define NULL_DEVICELEN	(sizeof(NULL_DEVICE) - 1)
#define KEY_ESCAPE	27

/* fossil(1) db and runtime related paths to unveil() */
#define REPODB		fsl_cx_db_file_repo(fcli_cx(), NULL)
#define REPODIR		getdirname(REPODB, -1, false)
#define CKOUTDIR	fsl_cx_ckout_dir_name(fcli_cx(), NULL)
#ifdef P_tmpdir
const char *tmpdir = P_tmpdir;
#elif defined(_PATH_TMP)
const char *tmpdir = _PATH_TMP;
#else
const char *tmpdir = "/tmp/";
#endif

/* Portability macros. */
#ifdef __linux__
#ifndef HAVE_STRTONUM	/* use strtoll and a range check to emulate strtonum */
#define INRANGE(n_, min_, max_)						\
	(n_ < min_ || n_ > max_) ||					\
	(errno == ERANGE && (n_ == LLONG_MIN || n_ == LLONG_MAX)) ?	\
	n_ == (errno = ERANGE) : n_
#define strtonum(s_, m_, x_, e_) INRANGE((strtoll(s_, (char **)e_, 10)), m_, x_)
#endif /* HAVE_STRTONUM */
#ifndef HAVE_BSD_STRING
#define strlcat(_d, _s, _sz) fsl_strlcat(_d, _s, _sz)
#define strlcpy(_d, _s, _sz) fsl_strlcpy(_d, _s, _sz)
#endif /* HAVE_BSD_STRING */
#if defined(_DEFAULT_SOURCE) || defined(_GNU_SOURCE)
#define HAVE_REALLOCARRAY
#endif
#elif !defined(__APPLE__) /* XXX Do all BSDs have reallocarray(3)? */
#define HAVE_REALLOCARRAY
#endif /* __linux__ */

#define PRINTFV(fmt, args) __attribute__((format (printf, fmt, args)))
#ifndef __dead
#define __dead	__attribute__((noreturn))
#endif

#ifndef __predict_true
# ifdef __has_builtin
#  if __has_builtin(__builtin_expect)
#   define __predict_true(_e)	__builtin_expect(((_e) != 0), 1)
#   define __predict_false(_e)	__builtin_expect(((_e) != 0), 0)
#  endif
# endif
#endif
#ifndef __predict_true
# define __predict_true(_e)	((_e) != 0)
# define __predict_false(_e)	((_e) != 0)
#endif

#ifndef TAILQ_FOREACH_SAFE
/* rewrite of OpenBSD 6.9 sys/queue.h for linux builds */
#define TAILQ_FOREACH_SAFE(var, head, field, tmp)			\
	for ((var) = ((head)->tqh_first);				\
		(var) != (NULL) && ((tmp) = TAILQ_NEXT(var, field), 1);	\
		(var) = (tmp))
#endif
#ifndef STAILQ_FOREACH_SAFE
#define STAILQ_FOREACH_SAFE(var, head, field, tmp)			\
	for ((var) = ((head)->stqh_first);				\
		(var) && ((tmp) = STAILQ_NEXT(var, field), 1);		\
		(var) = (tmp))
#endif

/* XXX OpenBSD added STAILQ in 6.9; fallback to SIMPLEQ for prior versions. */
#if defined(__OpenBSD__) && !defined(STAILQ_HEAD)
#define SQ(_do)	CONCAT(SIMPLEQ ## _, _do)
#else
#define SQ(_do)	CONCAT(STAILQ ## _, _do)
#endif  /* __OpenBSD__ */

#ifdef __OpenBSD__
#define HAVE_PROGNAME
extern char *__progname;
#define progname __progname
#elif defined(_GNU_SOURCE)
#define HAVE_PROGNAME
extern char *program_invocation_short_name;
#define progname program_invocation_short_name
#else
static char progname[PATH_MAX];
#endif  /* __OpenBSD__ */

enum date_string {
	ISO8601_DATE_ONLY = 10,  /* YYYY-MM-DD */
	ISO8601_DATE_HHMM = 16,  /* YYYY-MM-DD HH:MM */
	ISO8601_TIMESTAMP = 19   /* YYYY-MM-DD HH:MM:SS */
};

struct fnc_file_artifact {
	fsl_card_F		*fc;
	fsl_uuid_str		 puuid;
	uint64_t		 diffstat;
	fsl_ckout_change_e	 change;
};

struct input {
	void		*data;
	char		*prompt;
	enum input_type	 type;
	int		 flags;
#define SR_CLREOL	(1 << 0)
#define SR_UPDATE	(1 << 1)
#define SR_SLEEP	(1 << 2)
#define SR_RESET	(1 << 3)
#define SR_ALL		(SR_CLREOL | SR_UPDATE | SR_SLEEP | SR_RESET)
	char		 buf[BUFSIZ];
	long		 ret;
};

struct artifact_types {
	char	**values;
	short	  nitems;
};

struct cmd_help {
	const char *sopt;
	const char *lopt;
	const char *arg;
	const char *txt;
};

struct fnc_cmd {
	const char	*name;
	const char	*aliases;
	int		 (*f)(int, char **);
	struct cmd_help	*help;
};
