/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.jna;

import org.firebirdsql.encodings.IEncodingFactory;
import org.firebirdsql.gds.ng.DefaultDatatypeCoder;

public final class LittleEndianDatatypeCoder
extends DefaultDatatypeCoder {
    public LittleEndianDatatypeCoder(IEncodingFactory encodingFactory) {
        super(encodingFactory);
    }

    @Override
    public byte[] encodeShort(short value) {
        byte[] ret = new byte[]{(byte)(value & 0xFF), (byte)(value >>> 8 & 0xFF)};
        return ret;
    }

    @Override
    public short decodeShort(byte[] byte_int) {
        int b1 = byte_int[0] & 0xFF;
        int b2 = byte_int[1] & 0xFF;
        return (short)(b1 + (b2 << 8));
    }

    @Override
    public byte[] encodeInt(int value) {
        byte[] ret = new byte[]{(byte)(value & 0xFF), (byte)(value >>> 8 & 0xFF), (byte)(value >>> 16 & 0xFF), (byte)(value >>> 24 & 0xFF)};
        return ret;
    }

    @Override
    public int decodeInt(byte[] byte_int) {
        int b1 = byte_int[0] & 0xFF;
        int b2 = byte_int[1] & 0xFF;
        int b3 = byte_int[2] & 0xFF;
        int b4 = byte_int[3] & 0xFF;
        return b1 + (b2 << 8) + (b3 << 16) + (b4 << 24);
    }

    @Override
    public byte[] encodeLong(long value) {
        byte[] ret = new byte[]{(byte)(value & 0xFFL), (byte)(value >>> 8 & 0xFFL), (byte)(value >>> 16 & 0xFFL), (byte)(value >>> 24 & 0xFFL), (byte)(value >>> 32 & 0xFFL), (byte)(value >>> 40 & 0xFFL), (byte)(value >>> 48 & 0xFFL), (byte)(value >>> 56 & 0xFFL)};
        return ret;
    }

    @Override
    public long decodeLong(byte[] byte_int) {
        long b1 = byte_int[0] & 0xFF;
        long b2 = byte_int[1] & 0xFF;
        long b3 = byte_int[2] & 0xFF;
        long b4 = byte_int[3] & 0xFF;
        long b5 = byte_int[4] & 0xFF;
        long b6 = byte_int[5] & 0xFF;
        long b7 = byte_int[6] & 0xFF;
        long b8 = byte_int[7] & 0xFF;
        return b1 + (b2 << 8) + (b3 << 16) + (b4 << 24) + (b5 << 32) + (b6 << 40) + (b7 << 48) + (b8 << 56);
    }
}

