/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.jdbc;

import com.google.cloud.spanner.AbortedDueToConcurrentModificationException;
import com.google.cloud.spanner.AbortedException;
import com.google.cloud.spanner.SpannerBatchUpdateException;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.jdbc.JdbcSqlException;
import com.google.rpc.Code;
import java.sql.BatchUpdateException;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLTimeoutException;
import java.util.Collections;

public final class JdbcSqlExceptionFactory {
    static SQLException of(SpannerException e) {
        switch (e.getErrorCode()) {
            case ABORTED: {
                if (e instanceof AbortedDueToConcurrentModificationException) {
                    return new JdbcAbortedDueToConcurrentModificationException((AbortedDueToConcurrentModificationException)e);
                }
                if (e instanceof AbortedException) {
                    return new JdbcAbortedException((AbortedException)e);
                }
            }
            case DEADLINE_EXCEEDED: {
                return new JdbcSqlTimeoutException(e.getMessage());
            }
        }
        return new JdbcSqlExceptionImpl(e);
    }

    static SQLException of(String message, Code code) {
        switch (code) {
            case ABORTED: {
                return new JdbcAbortedException(code.name() + ": " + message);
            }
            case DEADLINE_EXCEEDED: {
                return new JdbcSqlTimeoutException(code.name() + ": " + message);
            }
        }
        return new JdbcSqlExceptionImpl(code.name() + ": " + message, code);
    }

    static SQLException of(String message, SpannerException e) {
        switch (e.getErrorCode()) {
            case ABORTED: {
                if (e instanceof AbortedDueToConcurrentModificationException) {
                    return new JdbcAbortedDueToConcurrentModificationException(message, (AbortedDueToConcurrentModificationException)e);
                }
                if (e instanceof AbortedException) {
                    return new JdbcAbortedException(message, (AbortedException)e);
                }
            }
            case DEADLINE_EXCEEDED: {
                return new JdbcSqlTimeoutException(e.getErrorCode().name() + ": " + message);
            }
        }
        return new JdbcSqlExceptionImpl(e.getErrorCode().name() + ": " + message, e);
    }

    static SQLException of(String message, Code code, Throwable cause) {
        switch (code) {
            case ABORTED: {
                if (cause instanceof AbortedDueToConcurrentModificationException) {
                    return new JdbcAbortedDueToConcurrentModificationException(message, (AbortedDueToConcurrentModificationException)cause);
                }
                if (cause instanceof AbortedException) {
                    return new JdbcAbortedException(message, (AbortedException)cause);
                }
            }
            case DEADLINE_EXCEEDED: {
                return new JdbcSqlTimeoutException(code.name() + ": " + message);
            }
        }
        return new JdbcSqlExceptionImpl(code.name() + ": " + message, code, cause);
    }

    static SQLFeatureNotSupportedException unsupported(String message) {
        return new JdbcSqlFeatureNotSupportedException(message);
    }

    static SQLClientInfoException clientInfoException(String message, Code code) {
        return new JdbcSqlClientInfoException(code.name() + ": " + message, code);
    }

    static BatchUpdateException batchException(int[] updateCounts, SpannerBatchUpdateException cause) {
        return new JdbcSqlBatchUpdateException(updateCounts, cause);
    }

    public static class JdbcAbortedDueToConcurrentModificationException
    extends JdbcAbortedException {
        private JdbcAbortedDueToConcurrentModificationException(AbortedDueToConcurrentModificationException cause) {
            super((AbortedException)cause);
        }

        private JdbcAbortedDueToConcurrentModificationException(String message, AbortedDueToConcurrentModificationException cause) {
            super(message, (AbortedException)cause);
        }

        public synchronized AbortedDueToConcurrentModificationException getCause() {
            return (AbortedDueToConcurrentModificationException)super.getCause();
        }

        public SpannerException getDatabaseErrorDuringRetry() {
            return this.getCause().getDatabaseErrorDuringRetry();
        }
    }

    public static class JdbcAbortedException
    extends JdbcSqlExceptionImpl {
        private JdbcAbortedException(AbortedException cause) {
            super((SpannerException)cause);
        }

        private JdbcAbortedException(String message) {
            super(message, Code.ABORTED);
        }

        private JdbcAbortedException(String message, AbortedException cause) {
            super(message, (SpannerException)cause);
        }

        public synchronized AbortedException getCause() {
            return (AbortedException)super.getCause();
        }
    }

    public static class JdbcSqlBatchUpdateException
    extends BatchUpdateException
    implements JdbcSqlException {
        private static final long serialVersionUID = 8894995110837971444L;
        private final Code code;

        private JdbcSqlBatchUpdateException(int[] updateCounts, SpannerBatchUpdateException cause) {
            super(cause.getMessage(), updateCounts, (Throwable)cause);
            this.code = Code.forNumber((int)cause.getCode());
        }

        @Override
        public Code getCode() {
            return this.code;
        }
    }

    public static class JdbcSqlFeatureNotSupportedException
    extends SQLFeatureNotSupportedException
    implements JdbcSqlException {
        private static final long serialVersionUID = 2363793358642102814L;

        private JdbcSqlFeatureNotSupportedException(String message) {
            super(message, "not supported", 12);
        }

        @Override
        public Code getCode() {
            return Code.UNIMPLEMENTED;
        }
    }

    public static class JdbcSqlClientInfoException
    extends SQLClientInfoException
    implements JdbcSqlException {
        private static final long serialVersionUID = 5341238042343668540L;
        private final Code code;

        private JdbcSqlClientInfoException(String message, Code code) {
            super(message, Collections.emptyMap());
            this.code = code;
        }

        @Override
        public Code getCode() {
            return this.code;
        }
    }

    public static class JdbcSqlTimeoutException
    extends SQLTimeoutException
    implements JdbcSqlException {
        private static final long serialVersionUID = 2363793358642102814L;

        private JdbcSqlTimeoutException(String message) {
            super(message, "Timed out", 4);
        }

        @Override
        public Code getCode() {
            return Code.DEADLINE_EXCEEDED;
        }
    }

    public static class JdbcSqlExceptionImpl
    extends SQLException
    implements JdbcSqlException {
        private static final long serialVersionUID = 235381453830069910L;
        private final Code code;

        private JdbcSqlExceptionImpl(String message, Code code) {
            super(message, null, code.getNumber(), null);
            this.code = code;
        }

        private JdbcSqlExceptionImpl(String message, Code code, Throwable cause) {
            super(message, null, code.getNumber(), cause);
            this.code = code;
        }

        private JdbcSqlExceptionImpl(SpannerException e) {
            super(e.getMessage(), null, e.getCode(), (Throwable)e);
            this.code = Code.forNumber((int)e.getCode());
        }

        private JdbcSqlExceptionImpl(String message, SpannerException e) {
            super(message, null, e.getCode(), (Throwable)e);
            this.code = Code.forNumber((int)e.getCode());
        }

        @Override
        public Code getCode() {
            return this.code;
        }
    }
}

