/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.tree;

import java.time.Duration;
import java.util.Arrays;
import oracle.jdbc.driver.json.OracleJsonExceptions;
import oracle.jdbc.driver.json.binary.JsonSerializerImpl;
import oracle.jdbc.driver.json.binary.JsonpOsonValueFactory;
import oracle.jdbc.driver.json.binary.OsonPrimitiveConversions;
import oracle.sql.INTERVALDS;
import oracle.sql.json.OracleJsonIntervalDS;
import oracle.sql.json.OracleJsonValue;

public class OracleJsonIntervalDSImpl
implements OracleJsonIntervalDS {
    public static final int INTERVALDS_LEN = 11;
    byte[] raw;

    public OracleJsonIntervalDSImpl(byte[] byArray) {
        this.raw = byArray;
    }

    public OracleJsonIntervalDSImpl(Duration duration) {
        this.raw = OsonPrimitiveConversions.durationToIntervalDS(duration);
    }

    @Override
    public OracleJsonValue.OracleJsonType getOracleJsonType() {
        return OracleJsonValue.OracleJsonType.INTERVALDS;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof OracleJsonIntervalDS)) {
            return false;
        }
        if (!(object instanceof OracleJsonIntervalDSImpl)) {
            throw new UnsupportedOperationException();
        }
        OracleJsonIntervalDSImpl oracleJsonIntervalDSImpl = (OracleJsonIntervalDSImpl)object;
        return Arrays.equals(oracleJsonIntervalDSImpl.raw, this.raw);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.raw);
    }

    @Override
    public String toString() {
        return JsonSerializerImpl.serializeString(this.getString());
    }

    @Override
    public String getString() {
        return OsonPrimitiveConversions.serializeIntervalDS(OracleJsonExceptions.ORACLE_FACTORY, this.raw());
    }

    public byte[] raw() {
        return this.raw;
    }

    @Override
    public Duration getDuration() {
        return OsonPrimitiveConversions.intervalDSToDuration(this.raw());
    }

    public static String serializeDuration(Duration duration, OracleJsonExceptions.ExceptionFactory exceptionFactory) {
        byte[] byArray = OsonPrimitiveConversions.durationToIntervalDS(duration);
        return OsonPrimitiveConversions.serializeIntervalDS(exceptionFactory, byArray);
    }

    @Override
    public INTERVALDS getINTERVALDS() {
        return new INTERVALDS(this.raw());
    }

    @Override
    public <T> T wrap(Class<T> clazz) {
        return clazz.cast(JsonpOsonValueFactory.INSTANCE.createIntervalDS(this.raw));
    }
}

