/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.tree;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Arrays;
import oracle.jdbc.driver.json.OracleJsonExceptions;
import oracle.jdbc.driver.json.binary.JsonSerializerImpl;
import oracle.jdbc.driver.json.binary.JsonpOsonValueFactory;
import oracle.jdbc.driver.json.binary.OsonPrimitiveConversions;
import oracle.sql.DATE;
import oracle.sql.json.OracleJsonDate;
import oracle.sql.json.OracleJsonValue;

public class OracleJsonDateImpl
implements OracleJsonDate {
    byte[] raw;

    public OracleJsonDateImpl(byte[] byArray) {
        this.raw = byArray;
    }

    public OracleJsonDateImpl(Instant instant) {
        this.raw = OsonPrimitiveConversions.instantToDate(this.getExceptionFactory(), instant);
    }

    @Override
    public OracleJsonValue.OracleJsonType getOracleJsonType() {
        return OracleJsonValue.OracleJsonType.DATE;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof OracleJsonDate)) {
            return false;
        }
        if (!(object instanceof OracleJsonDateImpl)) {
            throw new UnsupportedOperationException();
        }
        OracleJsonDateImpl oracleJsonDateImpl = (OracleJsonDateImpl)object;
        return Arrays.equals(oracleJsonDateImpl.raw, this.raw);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.raw);
    }

    @Override
    public String toString() {
        return JsonSerializerImpl.serializeString(this.getString());
    }

    @Override
    public Instant getInstant() {
        byte[] byArray = this.raw();
        LocalDateTime localDateTime = OsonPrimitiveConversions.dateToLocalDateTime(this.getExceptionFactory(), byArray);
        return localDateTime.toInstant(ZoneOffset.UTC);
    }

    @Override
    public String getString() {
        return OsonPrimitiveConversions.dateToString(this.getExceptionFactory(), this.raw);
    }

    public byte[] raw() {
        return this.raw;
    }

    @Override
    public DATE getDATE() {
        return new DATE(this.raw());
    }

    @Override
    public <T> T wrap(Class<T> clazz) {
        return clazz.cast(JsonpOsonValueFactory.INSTANCE.createDate(this.raw));
    }

    public OracleJsonExceptions.ExceptionFactory getExceptionFactory() {
        return OracleJsonExceptions.ORACLE_FACTORY;
    }
}

