/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.enterprise.spanner;

import java.sql.Connection;
import org.flywaydb.core.api.ResourceProvider;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.DatabaseType;
import org.flywaydb.core.internal.database.enterprise.spanner.SpannerDatabase;
import org.flywaydb.core.internal.database.enterprise.spanner.SpannerParser;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;
import org.flywaydb.core.internal.parser.Parser;
import org.flywaydb.core.internal.parser.ParsingContext;

public class SpannerDatabaseType
extends DatabaseType {
    @Override
    public String getName() {
        return "Google Cloud Spanner";
    }

    @Override
    public int getNullType() {
        return 0;
    }

    @Override
    public boolean supportsReadOnlyTransactions() {
        return true;
    }

    @Override
    public boolean handlesJDBCUrl(String url) {
        return url.startsWith("jdbc:cloudspanner:");
    }

    @Override
    public String getDriverClass(String url, ClassLoader classLoader) {
        return "com.google.cloud.spanner.jdbc.JdbcDriver";
    }

    @Override
    public boolean handlesDatabaseProductNameAndVersion(String databaseProductName, String databaseProductVersion, Connection connection) {
        return databaseProductName.contains("Google Cloud Spanner");
    }

    @Override
    public Database createDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory, StatementInterceptor statementInterceptor) {
        return new SpannerDatabase(configuration, jdbcConnectionFactory, statementInterceptor);
    }

    @Override
    public Parser createParser(Configuration configuration, ResourceProvider resourceProvider, ParsingContext parsingContext) {
        return new SpannerParser(configuration, parsingContext);
    }

    @Override
    public boolean detectUserRequiredByUrl(String url) {
        return !url.contains("credentials=");
    }

    @Override
    public boolean detectPasswordRequiredByUrl(String url) {
        return !url.contains("credentials=");
    }
}

