/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.callback;

import java.sql.Connection;
import java.util.List;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.callback.Context;
import org.flywaydb.core.api.callback.Error;
import org.flywaydb.core.api.callback.Statement;
import org.flywaydb.core.api.callback.Warning;
import org.flywaydb.core.api.configuration.Configuration;

public class SimpleContext
implements Context {
    private final Configuration configuration;
    private final org.flywaydb.core.internal.database.base.Connection connection;
    private final MigrationInfo migrationInfo;
    private final Statement statement;

    SimpleContext(Configuration configuration, org.flywaydb.core.internal.database.base.Connection connection, MigrationInfo migrationInfo) {
        this.configuration = configuration;
        this.connection = connection;
        this.migrationInfo = migrationInfo;
        this.statement = null;
    }

    public SimpleContext(Configuration configuration, org.flywaydb.core.internal.database.base.Connection connection, MigrationInfo migrationInfo, String sql, List<Warning> warnings, List<Error> errors) {
        this.configuration = configuration;
        this.connection = connection;
        this.migrationInfo = migrationInfo;
        this.statement = new SimpleStatement(sql, warnings, errors);
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public Connection getConnection() {
        return this.connection.getJdbcConnection();
    }

    @Override
    public MigrationInfo getMigrationInfo() {
        return this.migrationInfo;
    }

    @Override
    public Statement getStatement() {
        return this.statement;
    }

    private static class SimpleStatement
    implements Statement {
        private final String sql;
        private final List<Warning> warnings;
        private final List<Error> errors;

        private SimpleStatement(String sql, List<Warning> warnings, List<Error> errors) {
            this.sql = sql;
            this.warnings = warnings;
            this.errors = errors;
        }

        @Override
        public String getSql() {
            return this.sql;
        }

        @Override
        public List<Warning> getWarnings() {
            return this.warnings;
        }

        @Override
        public List<Error> getErrors() {
            return this.errors;
        }
    }
}

