/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.util.scanner;

import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.Location;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.util.FeatureDetector;
import org.flywaydb.core.internal.util.scanner.LoadableResource;
import org.flywaydb.core.internal.util.scanner.classpath.ClassPathScanner;
import org.flywaydb.core.internal.util.scanner.classpath.ResourceAndClassScanner;
import org.flywaydb.core.internal.util.scanner.classpath.android.AndroidScanner;
import org.flywaydb.core.internal.util.scanner.filesystem.FileSystemScanner;

public class Scanner {
    private final ResourceAndClassScanner resourceAndClassScanner;
    private final ClassLoader classLoader;
    private final FileSystemScanner fileSystemScanner;

    public Scanner(Configuration configuration) {
        this.classLoader = configuration.getClassLoader();
        this.resourceAndClassScanner = new FeatureDetector(this.classLoader).isAndroidAvailable() ? new AndroidScanner(this.classLoader, configuration.getEncoding()) : new ClassPathScanner(this.classLoader, configuration.getEncoding());
        this.fileSystemScanner = new FileSystemScanner(configuration);
    }

    public LoadableResource[] scanForResources(Location location, String prefix, String[] suffixes) {
        try {
            if (location.isFileSystem()) {
                return this.fileSystemScanner.scanForResources(location, prefix, suffixes);
            }
            return this.resourceAndClassScanner.scanForResources(location, prefix, suffixes);
        }
        catch (Exception e) {
            throw new FlywayException("Unable to scan for SQL migrations in location: " + location, e);
        }
    }

    public Class<?>[] scanForClasses(Location location, Class<?> implementedInterface) throws Exception {
        return this.resourceAndClassScanner.scanForClasses(location, implementedInterface);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }
}

