! $Id$
!
! Earth System Modeling Framework
! Copyright (c) 2002-2024, University Corporation for Atmospheric Research,
! Massachusetts Institute of Technology, Geophysical Fluid Dynamics
! Laboratory, University of Michigan, National Centers for Environmental
! Prediction, Los Alamos National Laboratory, Argonne National Laboratory,
! NASA Goddard Space Flight Center.
! Licensed under the University of Illinois-NCSA License.
!
!==============================================================================

#define ESMF_FILENAME "ESMF_InfoSync.F90"

!==============================================================================
! DO NOT EDIT THIS FILE DIRECTLY. IT IS GENERATED FROM A JINJA2 TEMPLATE FILE.
!   - Template files located in scripts/jinja2_templating/templates
!   - The template file is: ESMF_InfoSync.jinja2
!   - All code edits must be done in that template file then re-generated
!   - See scripts/jinja2_templating/README.md for guidance
!==============================================================================

#include "ESMF_Macros.inc"
#include "ESMF.h"

!==============================================================================
!==============================================================================

module ESMF_InfoSyncMod

use ESMF_UtilTypesMod     ! ESMF utility types
use ESMF_InitMacrosMod    ! ESMF initializer macros
use ESMF_BaseMod          ! ESMF base class
use ESMF_LogErrMod        ! ESMF error handling

use ESMF_VMMod
use ESMF_StateMod
use ESMF_StateItemMod
use ESMF_DistGridMod
use ESMF_FieldMod
use ESMF_FieldGetMod
use ESMF_FieldBundleMod
use ESMF_CompMod
use ESMF_GridCompMod
use ESMF_CplCompMod
use ESMF_SciCompMod
use ESMF_ArrayMod
use ESMF_ArrayBundleMod
use ESMF_InfoMod
use ESMF_UtilTypesMod
use ESMF_GeomMod
use ESMF_MeshMod
use ESMF_GridMod
use ESMF_XGridMod
use ESMF_XGridGetMod
use ESMF_LocStreamMod
use ESMF_RHandleMod
use ESMF_InfoDescribeMod

use iso_c_binding, only: C_INT
implicit none

!==============================================================================
!==============================================================================

private
public ESMF_InfoSync
public ESMF_InfoGetFromHost

!==============================================================================
!==============================================================================

interface ESMF_InfoSync
  module procedure ESMF_InfoSyncState
  module procedure ESMF_InfoSyncCplComp
  module procedure ESMF_InfoSyncGridComp
  module procedure ESMF_InfoSyncSciComp
  module procedure ESMF_InfoSyncField
  module procedure ESMF_InfoSyncFieldBundle
end interface

interface ESMF_InfoGetFromHost
  module procedure ESMF_InfoGetFromHostArray
  module procedure ESMF_InfoGetFromHostArrayBundle
  module procedure ESMF_InfoGetFromHostCplComp
  module procedure ESMF_InfoGetFromHostGridComp
  module procedure ESMF_InfoGetFromHostSciComp
  module procedure ESMF_InfoGetFromHostDistGrid
  module procedure ESMF_InfoGetFromHostField
  module procedure ESMF_InfoGetFromHostFieldBundle
  module procedure ESMF_InfoGetFromHostGrid
  module procedure ESMF_InfoGetFromHostState
  module procedure ESMF_InfoGetFromHostLocStream
  module procedure ESMF_InfoGetFromHostMesh
  module procedure ESMF_InfoGetFromHostGeom
end interface

contains !=====================================================================

!===============================================================================
! ESMF_InfoSync ================================================================
!===============================================================================

! Note: Documentation stub located in ESMF_InfoMod
#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_InfoSyncState()"
subroutine ESMF_InfoSyncState(host, rootPet, vm, keywordEnforcer, markClean, rc)
  type(ESMF_State), intent(inout) :: host
  integer, intent(in) :: rootPet
  type(ESMF_VM), intent(in) :: vm
type(ESMF_KeywordEnforcer), optional:: keywordEnforcer ! must use keywords below
  logical, intent(in), optional :: markClean
  integer, intent(inout), optional :: rc

  type(ESMF_InfoDescribe) :: eidesc
  integer :: localrc
  integer(C_INT) :: local_markClean
  type(ESMF_Pointer) :: eptr

  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  local_markClean = 0  !False
  if (present(markClean)) then
    if (markClean) local_markClean = 1  !True
  endif

  call ESMF_VMGetThis(vm, eptr, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  call eidesc%Initialize(addBaseAddress=.true., addObjectInfo=.false., rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  call eidesc%Update(host, "", rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  call c_info_base_sync(eidesc%info%ptr, rootPet, eptr%ptr, local_markClean, localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  call eidesc%Destroy(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_InfoSyncState

! Note: Documentation stub located in ESMF_InfoMod
#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_InfoSyncCplComp()"
subroutine ESMF_InfoSyncCplComp(host, rootPet, vm, keywordEnforcer, markClean, rc)
  type(ESMF_CplComp), intent(inout) :: host
  integer, intent(in) :: rootPet
  type(ESMF_VM), intent(in) :: vm
type(ESMF_KeywordEnforcer), optional:: keywordEnforcer ! must use keywords below
  logical, intent(in), optional :: markClean
  integer, intent(inout), optional :: rc

  type(ESMF_InfoDescribe) :: eidesc
  integer :: localrc
  integer(C_INT) :: local_markClean
  type(ESMF_Pointer) :: eptr

  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  local_markClean = 0  !False
  if (present(markClean)) then
    if (markClean) local_markClean = 1  !True
  endif

  call ESMF_VMGetThis(vm, eptr, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  call eidesc%Initialize(addBaseAddress=.true., addObjectInfo=.false., rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  call eidesc%Update(host, "", rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  call c_info_base_sync(eidesc%info%ptr, rootPet, eptr%ptr, local_markClean, localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  call eidesc%Destroy(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_InfoSyncCplComp

! Note: Documentation stub located in ESMF_InfoMod
#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_InfoSyncGridComp()"
subroutine ESMF_InfoSyncGridComp(host, rootPet, vm, keywordEnforcer, markClean, rc)
  type(ESMF_GridComp), intent(inout) :: host
  integer, intent(in) :: rootPet
  type(ESMF_VM), intent(in) :: vm
type(ESMF_KeywordEnforcer), optional:: keywordEnforcer ! must use keywords below
  logical, intent(in), optional :: markClean
  integer, intent(inout), optional :: rc

  type(ESMF_InfoDescribe) :: eidesc
  integer :: localrc
  integer(C_INT) :: local_markClean
  type(ESMF_Pointer) :: eptr

  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  local_markClean = 0  !False
  if (present(markClean)) then
    if (markClean) local_markClean = 1  !True
  endif

  call ESMF_VMGetThis(vm, eptr, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  call eidesc%Initialize(addBaseAddress=.true., addObjectInfo=.false., rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  call eidesc%Update(host, "", rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  call c_info_base_sync(eidesc%info%ptr, rootPet, eptr%ptr, local_markClean, localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  call eidesc%Destroy(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_InfoSyncGridComp

! Note: Documentation stub located in ESMF_InfoMod
#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_InfoSyncSciComp()"
subroutine ESMF_InfoSyncSciComp(host, rootPet, vm, keywordEnforcer, markClean, rc)
  type(ESMF_SciComp), intent(inout) :: host
  integer, intent(in) :: rootPet
  type(ESMF_VM), intent(in) :: vm
type(ESMF_KeywordEnforcer), optional:: keywordEnforcer ! must use keywords below
  logical, intent(in), optional :: markClean
  integer, intent(inout), optional :: rc

  type(ESMF_InfoDescribe) :: eidesc
  integer :: localrc
  integer(C_INT) :: local_markClean
  type(ESMF_Pointer) :: eptr

  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  local_markClean = 0  !False
  if (present(markClean)) then
    if (markClean) local_markClean = 1  !True
  endif

  call ESMF_VMGetThis(vm, eptr, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  call eidesc%Initialize(addBaseAddress=.true., addObjectInfo=.false., rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  call eidesc%Update(host, "", rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  call c_info_base_sync(eidesc%info%ptr, rootPet, eptr%ptr, local_markClean, localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  call eidesc%Destroy(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_InfoSyncSciComp

! Note: Documentation stub located in ESMF_InfoMod
#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_InfoSyncField()"
subroutine ESMF_InfoSyncField(host, rootPet, vm, keywordEnforcer, markClean, rc)
  type(ESMF_Field), intent(inout) :: host
  integer, intent(in) :: rootPet
  type(ESMF_VM), intent(in) :: vm
type(ESMF_KeywordEnforcer), optional:: keywordEnforcer ! must use keywords below
  logical, intent(in), optional :: markClean
  integer, intent(inout), optional :: rc

  type(ESMF_InfoDescribe) :: eidesc
  integer :: localrc
  integer(C_INT) :: local_markClean
  type(ESMF_Pointer) :: eptr

  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  local_markClean = 0  !False
  if (present(markClean)) then
    if (markClean) local_markClean = 1  !True
  endif

  call ESMF_VMGetThis(vm, eptr, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  call eidesc%Initialize(addBaseAddress=.true., addObjectInfo=.false., rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  call eidesc%Update(host, "", rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  call c_info_base_sync(eidesc%info%ptr, rootPet, eptr%ptr, local_markClean, localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  call eidesc%Destroy(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_InfoSyncField

! Note: Documentation stub located in ESMF_InfoMod
#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_InfoSyncFieldBundle()"
subroutine ESMF_InfoSyncFieldBundle(host, rootPet, vm, keywordEnforcer, markClean, rc)
  type(ESMF_FieldBundle), intent(inout) :: host
  integer, intent(in) :: rootPet
  type(ESMF_VM), intent(in) :: vm
type(ESMF_KeywordEnforcer), optional:: keywordEnforcer ! must use keywords below
  logical, intent(in), optional :: markClean
  integer, intent(inout), optional :: rc

  type(ESMF_InfoDescribe) :: eidesc
  integer :: localrc
  integer(C_INT) :: local_markClean
  type(ESMF_Pointer) :: eptr

  if (present(rc)) rc = ESMF_RC_NOT_IMPL
  local_markClean = 0  !False
  if (present(markClean)) then
    if (markClean) local_markClean = 1  !True
  endif

  call ESMF_VMGetThis(vm, eptr, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  call eidesc%Initialize(addBaseAddress=.true., addObjectInfo=.false., rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  call eidesc%Update(host, "", rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  call c_info_base_sync(eidesc%info%ptr, rootPet, eptr%ptr, local_markClean, localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  call eidesc%Destroy(rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_InfoSyncFieldBundle

! =============================================================================
! ESMF_InfoGetFromHost ========================================================
! =============================================================================

! Note: Documentation stub located in ESMF_InfoMod
#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_InfoGetFromHostArray()"
subroutine ESMF_InfoGetFromHostArray(host, info, keywordEnforcer, rc)
  type(ESMF_Array), intent(in) :: host
  type(ESMF_Info), intent(out) :: info
type(ESMF_KeywordEnforcer), optional:: keywordEnforcer ! must use keywords below
  integer, intent(inout), optional :: rc

  integer :: localrc
  type(ESMF_InfoDescribe) :: eidesc

  if (present(rc)) rc = ESMF_RC_NOT_IMPL

  info = eidesc%GetInfo(host, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_InfoGetFromHostArray

! Note: Documentation stub located in ESMF_InfoMod
#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_InfoGetFromHostArrayBundle()"
subroutine ESMF_InfoGetFromHostArrayBundle(host, info, keywordEnforcer, rc)
  type(ESMF_ArrayBundle), intent(in) :: host
  type(ESMF_Info), intent(out) :: info
type(ESMF_KeywordEnforcer), optional:: keywordEnforcer ! must use keywords below
  integer, intent(inout), optional :: rc

  integer :: localrc
  type(ESMF_InfoDescribe) :: eidesc

  if (present(rc)) rc = ESMF_RC_NOT_IMPL

  info = eidesc%GetInfo(host, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_InfoGetFromHostArrayBundle

! Note: Documentation stub located in ESMF_InfoMod
#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_InfoGetFromHostCplComp()"
subroutine ESMF_InfoGetFromHostCplComp(host, info, keywordEnforcer, rc)
  type(ESMF_CplComp), intent(in) :: host
  type(ESMF_Info), intent(out) :: info
type(ESMF_KeywordEnforcer), optional:: keywordEnforcer ! must use keywords below
  integer, intent(inout), optional :: rc

  integer :: localrc
  type(ESMF_InfoDescribe) :: eidesc

  if (present(rc)) rc = ESMF_RC_NOT_IMPL

  info = eidesc%GetInfo(host, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_InfoGetFromHostCplComp

! Note: Documentation stub located in ESMF_InfoMod
#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_InfoGetFromHostGridComp()"
subroutine ESMF_InfoGetFromHostGridComp(host, info, keywordEnforcer, rc)
  type(ESMF_GridComp), intent(in) :: host
  type(ESMF_Info), intent(out) :: info
type(ESMF_KeywordEnforcer), optional:: keywordEnforcer ! must use keywords below
  integer, intent(inout), optional :: rc

  integer :: localrc
  type(ESMF_InfoDescribe) :: eidesc

  if (present(rc)) rc = ESMF_RC_NOT_IMPL

  info = eidesc%GetInfo(host, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_InfoGetFromHostGridComp

! Note: Documentation stub located in ESMF_InfoMod
#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_InfoGetFromHostSciComp()"
subroutine ESMF_InfoGetFromHostSciComp(host, info, keywordEnforcer, rc)
  type(ESMF_SciComp), intent(in) :: host
  type(ESMF_Info), intent(out) :: info
type(ESMF_KeywordEnforcer), optional:: keywordEnforcer ! must use keywords below
  integer, intent(inout), optional :: rc

  integer :: localrc
  type(ESMF_InfoDescribe) :: eidesc

  if (present(rc)) rc = ESMF_RC_NOT_IMPL

  info = eidesc%GetInfo(host, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_InfoGetFromHostSciComp

! Note: Documentation stub located in ESMF_InfoMod
#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_InfoGetFromHostDistGrid()"
subroutine ESMF_InfoGetFromHostDistGrid(host, info, keywordEnforcer, rc)
  type(ESMF_DistGrid), intent(in) :: host
  type(ESMF_Info), intent(out) :: info
type(ESMF_KeywordEnforcer), optional:: keywordEnforcer ! must use keywords below
  integer, intent(inout), optional :: rc

  integer :: localrc
  type(ESMF_InfoDescribe) :: eidesc

  if (present(rc)) rc = ESMF_RC_NOT_IMPL

  info = eidesc%GetInfo(host, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_InfoGetFromHostDistGrid

! Note: Documentation stub located in ESMF_InfoMod
#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_InfoGetFromHostField()"
subroutine ESMF_InfoGetFromHostField(host, info, keywordEnforcer, rc)
  type(ESMF_Field), intent(in) :: host
  type(ESMF_Info), intent(out) :: info
type(ESMF_KeywordEnforcer), optional:: keywordEnforcer ! must use keywords below
  integer, intent(inout), optional :: rc

  integer :: localrc
  type(ESMF_InfoDescribe) :: eidesc

  if (present(rc)) rc = ESMF_RC_NOT_IMPL

  info = eidesc%GetInfo(host, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_InfoGetFromHostField

! Note: Documentation stub located in ESMF_InfoMod
#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_InfoGetFromHostFieldBundle()"
subroutine ESMF_InfoGetFromHostFieldBundle(host, info, keywordEnforcer, rc)
  type(ESMF_FieldBundle), intent(in) :: host
  type(ESMF_Info), intent(out) :: info
type(ESMF_KeywordEnforcer), optional:: keywordEnforcer ! must use keywords below
  integer, intent(inout), optional :: rc

  integer :: localrc
  type(ESMF_InfoDescribe) :: eidesc

  if (present(rc)) rc = ESMF_RC_NOT_IMPL

  info = eidesc%GetInfo(host, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_InfoGetFromHostFieldBundle

! Note: Documentation stub located in ESMF_InfoMod
#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_InfoGetFromHostGrid()"
subroutine ESMF_InfoGetFromHostGrid(host, info, keywordEnforcer, rc)
  type(ESMF_Grid), intent(in) :: host
  type(ESMF_Info), intent(out) :: info
type(ESMF_KeywordEnforcer), optional:: keywordEnforcer ! must use keywords below
  integer, intent(inout), optional :: rc

  integer :: localrc
  type(ESMF_InfoDescribe) :: eidesc

  if (present(rc)) rc = ESMF_RC_NOT_IMPL

  info = eidesc%GetInfo(host, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_InfoGetFromHostGrid

! Note: Documentation stub located in ESMF_InfoMod
#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_InfoGetFromHostState()"
subroutine ESMF_InfoGetFromHostState(host, info, keywordEnforcer, rc)
  type(ESMF_State), intent(in) :: host
  type(ESMF_Info), intent(out) :: info
type(ESMF_KeywordEnforcer), optional:: keywordEnforcer ! must use keywords below
  integer, intent(inout), optional :: rc

  integer :: localrc
  type(ESMF_InfoDescribe) :: eidesc

  if (present(rc)) rc = ESMF_RC_NOT_IMPL

  info = eidesc%GetInfo(host, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_InfoGetFromHostState

! Note: Documentation stub located in ESMF_InfoMod
#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_InfoGetFromHostLocStream()"
subroutine ESMF_InfoGetFromHostLocStream(host, info, keywordEnforcer, rc)
  type(ESMF_LocStream), intent(in) :: host
  type(ESMF_Info), intent(out) :: info
type(ESMF_KeywordEnforcer), optional:: keywordEnforcer ! must use keywords below
  integer, intent(inout), optional :: rc

  integer :: localrc
  type(ESMF_InfoDescribe) :: eidesc

  if (present(rc)) rc = ESMF_RC_NOT_IMPL

  info = eidesc%GetInfo(host, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_InfoGetFromHostLocStream

! Note: Documentation stub located in ESMF_InfoMod
#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_InfoGetFromHostMesh()"
subroutine ESMF_InfoGetFromHostMesh(host, info, keywordEnforcer, rc)
  type(ESMF_Mesh), intent(in) :: host
  type(ESMF_Info), intent(out) :: info
type(ESMF_KeywordEnforcer), optional:: keywordEnforcer ! must use keywords below
  integer, intent(inout), optional :: rc

  integer :: localrc
  type(ESMF_InfoDescribe) :: eidesc

  if (present(rc)) rc = ESMF_RC_NOT_IMPL

  info = eidesc%GetInfo(host, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_InfoGetFromHostMesh


! Note: Documentation stub located in ESMF_InfoMod
#undef  ESMF_METHOD
#define ESMF_METHOD "ESMF_InfoGetFromHostGeom()"
subroutine ESMF_InfoGetFromHostGeom(host, info, keywordEnforcer, rc)
  type(ESMF_Geom), intent(in) :: host
  type(ESMF_Info), intent(out) :: info
type(ESMF_KeywordEnforcer), optional:: keywordEnforcer ! must use keywords below
  integer, intent(inout), optional :: rc

  integer :: localrc
  type(ESMF_InfoDescribe) :: eidesc

  if (present(rc)) rc = ESMF_RC_NOT_IMPL

  info = eidesc%GetInfo(host, rc=localrc)
  if (ESMF_LogFoundError(localrc, ESMF_ERR_PASSTHRU, ESMF_CONTEXT, rcToReturn=rc)) return

  if (present(rc)) rc = ESMF_SUCCESS
end subroutine ESMF_InfoGetFromHostGeom

end module ESMF_InfoSyncMod
