/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.Operations;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.CompositeIndicesRequest;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.bulk.BulkShardRequest;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.index.Index;
import org.elasticsearch.transport.TransportActionProxy;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.xpack.core.security.action.GetApiKeyRequest;
import org.elasticsearch.xpack.core.security.action.user.GetUserPrivilegesRequest;
import org.elasticsearch.xpack.core.security.action.user.GetUserPrivilegesResponse;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesRequest;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesResponse;
import org.elasticsearch.xpack.core.security.action.user.UserRequest;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authz.AuthorizationEngine;
import org.elasticsearch.xpack.core.security.authz.ResolvedIndices;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.authz.accesscontrol.IndicesAccessControl;
import org.elasticsearch.xpack.core.security.authz.permission.FieldPermissionsCache;
import org.elasticsearch.xpack.core.security.authz.permission.FieldPermissionsDefinition;
import org.elasticsearch.xpack.core.security.authz.permission.IndicesPermission;
import org.elasticsearch.xpack.core.security.authz.permission.ResourcePrivilegesMap;
import org.elasticsearch.xpack.core.security.authz.permission.Role;
import org.elasticsearch.xpack.core.security.authz.privilege.ApplicationPrivilege;
import org.elasticsearch.xpack.core.security.authz.privilege.ApplicationPrivilegeDescriptor;
import org.elasticsearch.xpack.core.security.authz.privilege.ClusterPrivilege;
import org.elasticsearch.xpack.core.security.authz.privilege.ClusterPrivilegeResolver;
import org.elasticsearch.xpack.core.security.authz.privilege.ConfigurableClusterPrivilege;
import org.elasticsearch.xpack.core.security.authz.privilege.NamedClusterPrivilege;
import org.elasticsearch.xpack.core.security.authz.privilege.Privilege;
import org.elasticsearch.xpack.core.security.support.StringMatcher;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.security.action.user.TransportHasPrivilegesAction;
import org.elasticsearch.xpack.security.authz.IndicesAndAliasesResolver;
import org.elasticsearch.xpack.security.authz.store.CompositeRolesStore;

public class RBACEngine
implements AuthorizationEngine {
    private static final Predicate<String> SAME_USER_PRIVILEGE = StringMatcher.of((String[])new String[]{"cluster:admin/xpack/security/user/change_password", "cluster:admin/xpack/security/user/authenticate", "cluster:admin/xpack/security/user/has_privileges", "cluster:admin/xpack/security/user/list_privileges", "cluster:admin/xpack/security/api_key/get"});
    private static final String INDEX_SUB_REQUEST_PRIMARY = "indices:data/write/index[p]";
    private static final String INDEX_SUB_REQUEST_REPLICA = "indices:data/write/index[r]";
    private static final String DELETE_SUB_REQUEST_PRIMARY = "indices:data/write/delete[p]";
    private static final String DELETE_SUB_REQUEST_REPLICA = "indices:data/write/delete[r]";
    private static final Logger logger = LogManager.getLogger(RBACEngine.class);
    private final CompositeRolesStore rolesStore;
    private final FieldPermissionsCache fieldPermissionsCache;

    public RBACEngine(Settings settings, CompositeRolesStore rolesStore) {
        this.rolesStore = rolesStore;
        this.fieldPermissionsCache = new FieldPermissionsCache(settings);
    }

    public void resolveAuthorizationInfo(AuthorizationEngine.RequestInfo requestInfo, ActionListener<AuthorizationEngine.AuthorizationInfo> listener) {
        Authentication authentication = requestInfo.getAuthentication();
        this.getRoles(authentication.getUser(), authentication, (ActionListener<Role>)ActionListener.wrap(role -> {
            if (authentication.getUser().isRunAs()) {
                this.getRoles(authentication.getUser().authenticatedUser(), authentication, (ActionListener<Role>)ActionListener.wrap(authenticatedUserRole -> listener.onResponse((Object)new RBACAuthorizationInfo((Role)role, (Role)authenticatedUserRole)), arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
            } else {
                listener.onResponse((Object)new RBACAuthorizationInfo((Role)role, (Role)role));
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private void getRoles(User user, Authentication authentication, ActionListener<Role> listener) {
        this.rolesStore.getRoles(user, authentication, listener);
    }

    public void authorizeRunAs(AuthorizationEngine.RequestInfo requestInfo, AuthorizationEngine.AuthorizationInfo authorizationInfo, ActionListener<AuthorizationEngine.AuthorizationResult> listener) {
        if (authorizationInfo instanceof RBACAuthorizationInfo) {
            Role role = ((RBACAuthorizationInfo)authorizationInfo).getAuthenticatedUserAuthorizationInfo().getRole();
            listener.onResponse((Object)new AuthorizationEngine.AuthorizationResult(role.checkRunAs(requestInfo.getAuthentication().getUser().principal())));
        } else {
            listener.onFailure((Exception)new IllegalArgumentException("unsupported authorization info:" + authorizationInfo.getClass().getSimpleName()));
        }
    }

    public void authorizeClusterAction(AuthorizationEngine.RequestInfo requestInfo, AuthorizationEngine.AuthorizationInfo authorizationInfo, ActionListener<AuthorizationEngine.AuthorizationResult> listener) {
        if (authorizationInfo instanceof RBACAuthorizationInfo) {
            Role role = ((RBACAuthorizationInfo)authorizationInfo).getRole();
            if (role.checkClusterAction(requestInfo.getAction(), requestInfo.getRequest(), requestInfo.getAuthentication())) {
                listener.onResponse((Object)AuthorizationEngine.AuthorizationResult.granted());
            } else if (this.checkSameUserPermissions(requestInfo.getAction(), requestInfo.getRequest(), requestInfo.getAuthentication())) {
                listener.onResponse((Object)AuthorizationEngine.AuthorizationResult.granted());
            } else {
                listener.onResponse((Object)AuthorizationEngine.AuthorizationResult.deny());
            }
        } else {
            listener.onFailure((Exception)new IllegalArgumentException("unsupported authorization info:" + authorizationInfo.getClass().getSimpleName()));
        }
    }

    boolean checkSameUserPermissions(String action, TransportRequest request, Authentication authentication) {
        boolean actionAllowed = SAME_USER_PRIVILEGE.test(action);
        if (actionAllowed) {
            if (request instanceof UserRequest) {
                UserRequest userRequest = (UserRequest)request;
                String[] usernames = userRequest.usernames();
                if (usernames == null || usernames.length != 1 || usernames[0] == null) {
                    assert (false) : "this role should only be used for actions to apply to a single user";
                    return false;
                }
                String username = usernames[0];
                boolean sameUsername = authentication.getUser().principal().equals(username);
                if (sameUsername && "cluster:admin/xpack/security/user/change_password".equals(action)) {
                    return RBACEngine.checkChangePasswordAction(authentication);
                }
                assert ("cluster:admin/xpack/security/user/authenticate".equals(action) || "cluster:admin/xpack/security/user/has_privileges".equals(action) || "cluster:admin/xpack/security/user/list_privileges".equals(action) || !sameUsername) : "Action '" + action + "' should not be possible when sameUsername=" + sameUsername;
                return sameUsername;
            }
            if (request instanceof GetApiKeyRequest) {
                GetApiKeyRequest getApiKeyRequest = (GetApiKeyRequest)request;
                if (Authentication.AuthenticationType.API_KEY == authentication.getAuthenticationType()) {
                    assert (authentication.getLookedUpBy() == null) : "runAs not supported for api key authentication";
                    String authenticatedApiKeyId = (String)authentication.getMetadata().get("_security_api_key_id");
                    if (Strings.hasText((String)getApiKeyRequest.getApiKeyId())) {
                        return getApiKeyRequest.getApiKeyId().equals(authenticatedApiKeyId);
                    }
                    return false;
                }
            } else {
                assert (false) : "right now only a user request or get api key request should be allowed";
                return false;
            }
        }
        return false;
    }

    private static boolean shouldAuthorizeIndexActionNameOnly(String action, TransportRequest request) {
        switch (action) {
            case "indices:data/write/bulk": 
            case "indices:data/write/index": 
            case "indices:data/write/delete": 
            case "indices:data/write/index[p]": 
            case "indices:data/write/index[r]": 
            case "indices:data/write/delete[p]": 
            case "indices:data/write/delete[r]": 
            case "indices:data/read/mget": 
            case "indices:data/read/mtv": 
            case "indices:data/read/msearch": 
            case "indices:data/read/mpercolate": 
            case "indices:data/read/msearch/template": 
            case "indices:data/read/search/template": 
            case "indices:data/write/reindex": 
            case "indices:data/read/sql": 
            case "indices:data/read/sql/translate": {
                if (request instanceof BulkShardRequest) {
                    return false;
                }
                if (!(request instanceof CompositeIndicesRequest)) {
                    throw new IllegalStateException("Composite and bulk actions must implement " + CompositeIndicesRequest.class.getSimpleName() + ", " + request.getClass().getSimpleName() + " doesn't. Action " + action);
                }
                return true;
            }
        }
        return false;
    }

    public void authorizeIndexAction(AuthorizationEngine.RequestInfo requestInfo, AuthorizationEngine.AuthorizationInfo authorizationInfo, AuthorizationEngine.AsyncSupplier<ResolvedIndices> indicesAsyncSupplier, Map<String, IndexAbstraction> aliasOrIndexLookup, ActionListener<AuthorizationEngine.IndexAuthorizationResult> listener) {
        String action = requestInfo.getAction();
        TransportRequest request = requestInfo.getRequest();
        if (TransportActionProxy.isProxyAction((String)action) || RBACEngine.shouldAuthorizeIndexActionNameOnly(action, request)) {
            try {
                listener.onResponse((Object)RBACEngine.authorizeIndexActionName(action, authorizationInfo, null));
            }
            catch (Exception e) {
                listener.onFailure(e);
            }
        } else if (!(request instanceof IndicesRequest)) {
            if (RBACEngine.isScrollRelatedAction(action)) {
                if ("indices:data/read/scroll".equals(action)) {
                    ActionRunnable.supply((ActionListener)ActionListener.wrap(parsedScrollId -> {
                        if (parsedScrollId.hasLocalIndices()) {
                            listener.onResponse((Object)RBACEngine.authorizeIndexActionName(action, authorizationInfo, null));
                        } else {
                            listener.onResponse((Object)new AuthorizationEngine.IndexAuthorizationResult(true, null));
                        }
                    }, arg_0 -> listener.onFailure(arg_0)), () -> ((SearchScrollRequest)((SearchScrollRequest)request)).parseScrollId()).run();
                } else {
                    listener.onResponse((Object)new AuthorizationEngine.IndexAuthorizationResult(true, null));
                }
            } else if (RBACEngine.isAsyncRelatedAction(action)) {
                if ("indices:data/read/async_search/submit".equals(action)) {
                    listener.onResponse((Object)new AuthorizationEngine.IndexAuthorizationResult(true, null));
                } else {
                    listener.onResponse((Object)new AuthorizationEngine.IndexAuthorizationResult(true, IndicesAccessControl.ALLOW_NO_INDICES));
                }
            } else if (action.equals("indices:data/read/close_point_in_time")) {
                listener.onResponse((Object)new AuthorizationEngine.IndexAuthorizationResult(true, IndicesAccessControl.ALLOW_NO_INDICES));
            } else {
                assert (false) : "only scroll and async-search related requests are known indices api that don't support retrieving the indices they relate to";
                listener.onFailure((Exception)new IllegalStateException("only scroll and async-search related requests are known indices api that don't support retrieving the indices they relate to"));
            }
        } else if (this.isChildActionAuthorizedByParent(requestInfo, authorizationInfo)) {
            listener.onResponse((Object)new AuthorizationEngine.IndexAuthorizationResult(true, requestInfo.getOriginatingAuthorizationContext().getIndicesAccessControl()));
        } else if (request instanceof IndicesRequest.Replaceable && ((IndicesRequest.Replaceable)request).allowsRemoteIndices()) {
            indicesAsyncSupplier.getAsync(ActionListener.wrap(resolvedIndices -> {
                assert (!resolvedIndices.isEmpty()) : "every indices request needs to have its indices set thus the resolved indices must not be empty";
                if (resolvedIndices.isNoIndicesPlaceholder()) {
                    listener.onResponse((Object)RBACEngine.authorizeIndexActionName(action, authorizationInfo, IndicesAccessControl.ALLOW_NO_INDICES));
                } else {
                    listener.onResponse((Object)this.buildIndicesAccessControl(action, authorizationInfo, Sets.newHashSet((Iterable)resolvedIndices.getLocal()), aliasOrIndexLookup));
                }
            }, arg_0 -> listener.onFailure(arg_0)));
        } else {
            try {
                AuthorizationEngine.IndexAuthorizationResult indexAuthorizationResult = RBACEngine.authorizeIndexActionName(action, authorizationInfo, IndicesAccessControl.ALLOW_NO_INDICES);
                if (indexAuthorizationResult.isGranted()) {
                    indicesAsyncSupplier.getAsync(ActionListener.wrap(resolvedIndices -> {
                        assert (!resolvedIndices.isEmpty()) : "every indices request needs to have its indices set thus the resolved indices must not be empty";
                        if (resolvedIndices.isNoIndicesPlaceholder()) {
                            listener.onResponse((Object)new AuthorizationEngine.IndexAuthorizationResult(true, IndicesAccessControl.ALLOW_NO_INDICES));
                        } else {
                            listener.onResponse((Object)this.buildIndicesAccessControl(action, authorizationInfo, Sets.newHashSet((Iterable)resolvedIndices.getLocal()), aliasOrIndexLookup));
                        }
                    }, arg_0 -> listener.onFailure(arg_0)));
                } else {
                    listener.onResponse((Object)indexAuthorizationResult);
                }
            }
            catch (Exception e) {
                listener.onFailure(e);
            }
        }
    }

    private boolean isChildActionAuthorizedByParent(AuthorizationEngine.RequestInfo requestInfo, AuthorizationEngine.AuthorizationInfo authorizationInfo) {
        AuthorizationEngine.AuthorizationContext parent = requestInfo.getOriginatingAuthorizationContext();
        if (parent == null) {
            return false;
        }
        IndicesAccessControl indicesAccessControl = parent.getIndicesAccessControl();
        if (indicesAccessControl == null) {
            return false;
        }
        if (!requestInfo.getAction().startsWith(parent.getAction())) {
            return false;
        }
        if (!authorizationInfo.equals(parent.getAuthorizationInfo())) {
            return false;
        }
        if (!(requestInfo.getRequest() instanceof IndicesRequest)) {
            return false;
        }
        IndicesRequest indicesRequest = (IndicesRequest)requestInfo.getRequest();
        Object[] indices = indicesRequest.indices();
        if (indices == null || indices.length == 0) {
            return false;
        }
        if (Arrays.equals(IndicesAndAliasesResolver.NO_INDICES_OR_ALIASES_ARRAY, indices)) {
            return false;
        }
        for (Object idx : indices) {
            assert (!Regex.isSimpleMatchPattern((String)idx)) : "Wildcards should already be expanded but action [" + requestInfo.getAction() + "] has index [" + (String)idx + "]";
            IndicesAccessControl.IndexAccessControl iac = indicesAccessControl.getIndexPermissions((String)idx);
            if (iac != null && iac.isGranted()) continue;
            return false;
        }
        return true;
    }

    private static AuthorizationEngine.IndexAuthorizationResult authorizeIndexActionName(String action, AuthorizationEngine.AuthorizationInfo authorizationInfo, IndicesAccessControl grantedValue) {
        Role role = RBACEngine.ensureRBAC(authorizationInfo).getRole();
        return new AuthorizationEngine.IndexAuthorizationResult(true, role.checkIndicesAction(action) ? grantedValue : IndicesAccessControl.DENIED);
    }

    public void loadAuthorizedIndices(AuthorizationEngine.RequestInfo requestInfo, AuthorizationEngine.AuthorizationInfo authorizationInfo, Map<String, IndexAbstraction> indicesLookup, ActionListener<Set<String>> listener) {
        if (authorizationInfo instanceof RBACAuthorizationInfo) {
            Role role = ((RBACAuthorizationInfo)authorizationInfo).getRole();
            listener.onResponse(RBACEngine.resolveAuthorizedIndicesFromRole(role, requestInfo, indicesLookup));
        } else {
            listener.onFailure((Exception)new IllegalArgumentException("unsupported authorization info:" + authorizationInfo.getClass().getSimpleName()));
        }
    }

    public void validateIndexPermissionsAreSubset(AuthorizationEngine.RequestInfo requestInfo, AuthorizationEngine.AuthorizationInfo authorizationInfo, Map<String, List<String>> indexNameToNewNames, ActionListener<AuthorizationEngine.AuthorizationResult> listener) {
        if (authorizationInfo instanceof RBACAuthorizationInfo) {
            Role role = ((RBACAuthorizationInfo)authorizationInfo).getRole();
            HashMap<String, Automaton> permissionMap = new HashMap<String, Automaton>();
            for (Map.Entry<String, List<String>> entry : indexNameToNewNames.entrySet()) {
                Automaton existingPermissions = permissionMap.computeIfAbsent(entry.getKey(), arg_0 -> ((Role)role).allowedActionsMatcher(arg_0));
                for (String alias : entry.getValue()) {
                    Automaton newNamePermissions = permissionMap.computeIfAbsent(alias, arg_0 -> ((Role)role).allowedActionsMatcher(arg_0));
                    if (Operations.subsetOf((Automaton)newNamePermissions, (Automaton)existingPermissions)) continue;
                    listener.onResponse((Object)AuthorizationEngine.AuthorizationResult.deny());
                    return;
                }
            }
            listener.onResponse((Object)AuthorizationEngine.AuthorizationResult.granted());
        } else {
            listener.onFailure((Exception)new IllegalArgumentException("unsupported authorization info:" + authorizationInfo.getClass().getSimpleName()));
        }
    }

    public void checkPrivileges(Authentication authentication, AuthorizationEngine.AuthorizationInfo authorizationInfo, HasPrivilegesRequest request, Collection<ApplicationPrivilegeDescriptor> applicationPrivileges, ActionListener<HasPrivilegesResponse> listener) {
        if (!(authorizationInfo instanceof RBACAuthorizationInfo)) {
            listener.onFailure((Exception)new IllegalArgumentException("unsupported authorization info:" + authorizationInfo.getClass().getSimpleName()));
            return;
        }
        Role userRole = ((RBACAuthorizationInfo)authorizationInfo).getRole();
        logger.trace(() -> new ParameterizedMessage("Check whether role [{}] has privileges cluster=[{}] index=[{}] application=[{}]", new Object[]{Strings.arrayToCommaDelimitedString((Object[])userRole.names()), Strings.arrayToCommaDelimitedString((Object[])request.clusterPrivileges()), Strings.arrayToCommaDelimitedString((Object[])request.indexPrivileges()), Strings.arrayToCommaDelimitedString((Object[])request.applicationPrivileges())}));
        HashMap<String, Boolean> cluster = new HashMap<String, Boolean>();
        for (String checkAction : request.clusterPrivileges()) {
            cluster.put(checkAction, userRole.grants((ClusterPrivilege)ClusterPrivilegeResolver.resolve((String)checkAction)));
        }
        boolean allMatch = cluster.values().stream().allMatch(Boolean::booleanValue);
        ResourcePrivilegesMap.Builder combineIndicesResourcePrivileges = ResourcePrivilegesMap.builder();
        for (RoleDescriptor.IndicesPrivileges check : request.indexPrivileges()) {
            ResourcePrivilegesMap resourcePrivileges = userRole.checkIndicesPrivileges((Set)Sets.newHashSet((Object[])check.getIndices()), check.allowRestrictedIndices(), (Set)Sets.newHashSet((Object[])check.getPrivileges()));
            allMatch = allMatch && resourcePrivileges.allAllowed();
            combineIndicesResourcePrivileges.addResourcePrivilegesMap(resourcePrivileges);
        }
        ResourcePrivilegesMap allIndices = combineIndicesResourcePrivileges.build();
        allMatch = allMatch && allIndices.allAllowed();
        HashMap privilegesByApplication = new HashMap();
        for (String applicationName : TransportHasPrivilegesAction.getApplicationNames(request)) {
            logger.debug("Checking privileges for application {}", (Object)applicationName);
            ResourcePrivilegesMap.Builder builder = ResourcePrivilegesMap.builder();
            for (RoleDescriptor.ApplicationResourcePrivileges p : request.applicationPrivileges()) {
                if (!applicationName.equals(p.getApplication())) continue;
                ResourcePrivilegesMap appPrivsByResourceMap = userRole.checkApplicationResourcePrivileges(applicationName, (Set)Sets.newHashSet((Object[])p.getResources()), (Set)Sets.newHashSet((Object[])p.getPrivileges()), applicationPrivileges);
                builder.addResourcePrivilegesMap(appPrivsByResourceMap);
            }
            ResourcePrivilegesMap resourcePrivsForApplication = builder.build();
            allMatch = allMatch && resourcePrivsForApplication.allAllowed();
            privilegesByApplication.put(applicationName, resourcePrivsForApplication.getResourceToResourcePrivileges().values());
        }
        listener.onResponse((Object)new HasPrivilegesResponse(request.username(), allMatch, cluster, allIndices.getResourceToResourcePrivileges().values(), privilegesByApplication));
    }

    public void getUserPrivileges(Authentication authentication, AuthorizationEngine.AuthorizationInfo authorizationInfo, GetUserPrivilegesRequest request, ActionListener<GetUserPrivilegesResponse> listener) {
        if (!(authorizationInfo instanceof RBACAuthorizationInfo)) {
            listener.onFailure((Exception)new IllegalArgumentException("unsupported authorization info:" + authorizationInfo.getClass().getSimpleName()));
        } else {
            Role role = ((RBACAuthorizationInfo)authorizationInfo).getRole();
            listener.onResponse((Object)this.buildUserPrivilegesResponseObject(role));
        }
    }

    GetUserPrivilegesResponse buildUserPrivilegesResponseObject(Role userRole) {
        logger.trace(() -> new ParameterizedMessage("List privileges for role [{}]", (Object)Strings.arrayToCommaDelimitedString((Object[])userRole.names())));
        TreeSet<String> cluster = new TreeSet<String>();
        HashSet<ConfigurableClusterPrivilege> conditionalCluster = new HashSet<ConfigurableClusterPrivilege>();
        for (IndicesPermission.Group[] privilege : userRole.cluster().privileges()) {
            if (privilege instanceof NamedClusterPrivilege) {
                cluster.add(((NamedClusterPrivilege)privilege).name());
                continue;
            }
            if (privilege instanceof ConfigurableClusterPrivilege) {
                conditionalCluster.add((ConfigurableClusterPrivilege)privilege);
                continue;
            }
            throw new IllegalArgumentException("found unsupported cluster privilege : " + privilege + (privilege != null ? " of type " + privilege.getClass().getSimpleName() : ""));
        }
        LinkedHashSet<GetUserPrivilegesResponse.Indices> indices = new LinkedHashSet<GetUserPrivilegesResponse.Indices>();
        for (IndicesPermission.Group group : userRole.indices().groups()) {
            Set fieldSecurity;
            Set queries;
            Set set = queries = group.getQuery() == null ? Collections.emptySet() : group.getQuery();
            if (group.getFieldPermissions().hasFieldLevelSecurity()) {
                FieldPermissionsDefinition definition = group.getFieldPermissions().getFieldPermissionsDefinition();
                assert (group.getFieldPermissions().getLimitedByFieldPermissionsDefinition() == null) : "limited-by field must not exist since we do not support reporting user privileges for limited roles";
                fieldSecurity = definition.getFieldGrantExcludeGroups();
            } else {
                fieldSecurity = Collections.emptySet();
            }
            indices.add(new GetUserPrivilegesResponse.Indices(Arrays.asList(group.indices()), (Collection)group.privilege().name(), fieldSecurity, queries, group.allowRestrictedIndices()));
        }
        LinkedHashSet<RoleDescriptor.ApplicationResourcePrivileges> application = new LinkedHashSet<RoleDescriptor.ApplicationResourcePrivileges>();
        for (String applicationName : userRole.application().getApplicationNames()) {
            for (ApplicationPrivilege privilege : userRole.application().getPrivileges(applicationName)) {
                Set resources = userRole.application().getResourcePatterns(privilege);
                if (resources.isEmpty()) {
                    logger.trace("No resources defined in application privilege {}", (Object)privilege);
                    continue;
                }
                application.add(RoleDescriptor.ApplicationResourcePrivileges.builder().application(applicationName).privileges((Collection)privilege.name()).resources((Collection)resources).build());
            }
        }
        Privilege runAsPrivilege = userRole.runAs().getPrivilege();
        Set runAs = Operations.isEmpty((Automaton)runAsPrivilege.getAutomaton()) ? Collections.emptySet() : runAsPrivilege.name();
        return new GetUserPrivilegesResponse(cluster, conditionalCluster, indices, application, runAs);
    }

    static Set<String> resolveAuthorizedIndicesFromRole(Role role, AuthorizationEngine.RequestInfo requestInfo, Map<String, IndexAbstraction> lookup) {
        Predicate predicate = role.allowedIndicesMatcher(requestInfo.getAction());
        TransportRequest request = requestInfo.getRequest();
        boolean includeDataStreams = request instanceof IndicesRequest && ((IndicesRequest)request).includeDataStreams();
        HashSet<String> indicesAndAliases = new HashSet<String>();
        if (includeDataStreams) {
            for (IndexAbstraction indexAbstraction : lookup.values()) {
                if (!predicate.test(indexAbstraction)) continue;
                indicesAndAliases.add(indexAbstraction.getName());
                if (indexAbstraction.getType() != IndexAbstraction.Type.DATA_STREAM) continue;
                for (Index index : indexAbstraction.getIndices()) {
                    indicesAndAliases.add(index.getName());
                }
            }
        } else {
            for (IndexAbstraction indexAbstraction : lookup.values()) {
                if (indexAbstraction.getType() == IndexAbstraction.Type.DATA_STREAM || !predicate.test(indexAbstraction)) continue;
                indicesAndAliases.add(indexAbstraction.getName());
            }
        }
        return Collections.unmodifiableSet(indicesAndAliases);
    }

    private AuthorizationEngine.IndexAuthorizationResult buildIndicesAccessControl(String action, AuthorizationEngine.AuthorizationInfo authorizationInfo, Set<String> indices, Map<String, IndexAbstraction> aliasAndIndexLookup) {
        Role role = RBACEngine.ensureRBAC(authorizationInfo).getRole();
        IndicesAccessControl accessControl = role.authorize(action, indices, aliasAndIndexLookup, this.fieldPermissionsCache);
        return new AuthorizationEngine.IndexAuthorizationResult(true, accessControl);
    }

    private static RBACAuthorizationInfo ensureRBAC(AuthorizationEngine.AuthorizationInfo authorizationInfo) {
        if (!(authorizationInfo instanceof RBACAuthorizationInfo)) {
            throw new IllegalArgumentException("unsupported authorization info:" + authorizationInfo.getClass().getSimpleName());
        }
        return (RBACAuthorizationInfo)authorizationInfo;
    }

    public static Role maybeGetRBACEngineRole(AuthorizationEngine.AuthorizationInfo authorizationInfo) {
        if (authorizationInfo instanceof RBACAuthorizationInfo) {
            return ((RBACAuthorizationInfo)authorizationInfo).getRole();
        }
        return null;
    }

    private static boolean checkChangePasswordAction(Authentication authentication) {
        boolean isRunAs = authentication.getUser().isRunAs();
        String realmType = isRunAs ? authentication.getLookedUpBy().getType() : authentication.getAuthenticatedBy().getType();
        assert (realmType != null);
        Authentication.AuthenticationType authType = authentication.getAuthenticationType();
        return authType.equals((Object)Authentication.AuthenticationType.REALM) && ("reserved".equals(realmType) || "native".equals(realmType));
    }

    private static boolean isScrollRelatedAction(String action) {
        return action.equals("indices:data/read/scroll") || action.equals("indices:data/read/search[phase/fetch/id/scroll]") || action.equals("indices:data/read/search[phase/query+fetch/scroll]") || action.equals("indices:data/read/search[phase/query/scroll]") || action.equals("indices:data/read/search[free_context/scroll]") || action.equals("indices:data/read/scroll/clear") || action.equals("indices:data/read/sql/close_cursor") || action.equals("indices:data/read/search[clear_scroll_contexts]");
    }

    private static boolean isAsyncRelatedAction(String action) {
        return action.equals("indices:data/read/async_search/submit") || action.equals("indices:data/read/async_search/get") || action.equals("indices:data/read/async_search/delete") || action.equals("indices:data/read/eql/async/get") || action.equals("indices:data/read/sql/async/get");
    }

    static class RBACAuthorizationInfo
    implements AuthorizationEngine.AuthorizationInfo {
        private final Role role;
        private final Map<String, Object> info;
        private final RBACAuthorizationInfo authenticatedUserAuthorizationInfo;

        RBACAuthorizationInfo(Role role, Role authenticatedUserRole) {
            this.role = Objects.requireNonNull(role);
            this.info = Collections.singletonMap("user.roles", role.names());
            this.authenticatedUserAuthorizationInfo = authenticatedUserRole == null ? this : new RBACAuthorizationInfo(authenticatedUserRole, null);
        }

        Role getRole() {
            return this.role;
        }

        public Map<String, Object> asMap() {
            return this.info;
        }

        public RBACAuthorizationInfo getAuthenticatedUserAuthorizationInfo() {
            return this.authenticatedUserAuthorizationInfo;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RBACAuthorizationInfo that = (RBACAuthorizationInfo)o;
            if (!this.role.equals((Object)that.role)) {
                return false;
            }
            if (this.authenticatedUserAuthorizationInfo == this) {
                return that.authenticatedUserAuthorizationInfo == that;
            }
            return this.authenticatedUserAuthorizationInfo.equals(that.authenticatedUserAuthorizationInfo);
        }

        public int hashCode() {
            if (this.authenticatedUserAuthorizationInfo == this) {
                return Objects.hashCode(this.role);
            }
            return Objects.hash(this.role, this.authenticatedUserAuthorizationInfo);
        }
    }
}

