/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc;

import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.node.Node;
import org.elasticsearch.xpack.core.common.IteratingActionListener;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.AuthenticationServiceField;
import org.elasticsearch.xpack.core.security.authc.AuthenticationToken;
import org.elasticsearch.xpack.core.security.authc.support.AuthenticationContextSerializer;
import org.elasticsearch.xpack.core.security.support.Exceptions;
import org.elasticsearch.xpack.core.security.user.AnonymousUser;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.security.authc.ApiKeyAuthenticator;
import org.elasticsearch.xpack.security.authc.AuthenticationService;
import org.elasticsearch.xpack.security.authc.Authenticator;
import org.elasticsearch.xpack.security.authc.OAuth2TokenAuthenticator;
import org.elasticsearch.xpack.security.authc.RealmsAuthenticator;
import org.elasticsearch.xpack.security.authc.ServiceAccountAuthenticator;
import org.elasticsearch.xpack.security.operator.OperatorPrivileges;

class AuthenticatorChain {
    private static final Logger logger = LogManager.getLogger(AuthenticatorChain.class);
    private final String nodeName;
    private final boolean runAsEnabled;
    private final OperatorPrivileges.OperatorPrivilegesService operatorPrivilegesService;
    private final AnonymousUser anonymousUser;
    private final boolean isAnonymousUserEnabled;
    private final AuthenticationContextSerializer authenticationSerializer;
    private final RealmsAuthenticator realmsAuthenticator;
    private final List<Authenticator> allAuthenticators;

    AuthenticatorChain(Settings settings, OperatorPrivileges.OperatorPrivilegesService operatorPrivilegesService, AnonymousUser anonymousUser, AuthenticationContextSerializer authenticationSerializer, ServiceAccountAuthenticator serviceAccountAuthenticator, OAuth2TokenAuthenticator oAuth2TokenAuthenticator, ApiKeyAuthenticator apiKeyAuthenticator, RealmsAuthenticator realmsAuthenticator) {
        this.nodeName = (String)Node.NODE_NAME_SETTING.get(settings);
        this.runAsEnabled = (Boolean)AuthenticationServiceField.RUN_AS_ENABLED.get(settings);
        this.operatorPrivilegesService = operatorPrivilegesService;
        this.anonymousUser = anonymousUser;
        this.isAnonymousUserEnabled = AnonymousUser.isAnonymousEnabled((Settings)settings);
        this.authenticationSerializer = authenticationSerializer;
        this.realmsAuthenticator = realmsAuthenticator;
        this.allAuthenticators = org.elasticsearch.core.List.of((Object[])new Authenticator[]{serviceAccountAuthenticator, oAuth2TokenAuthenticator, apiKeyAuthenticator, realmsAuthenticator});
    }

    void authenticateAsync(Authenticator.Context context, ActionListener<Authentication> originalListener) {
        Authentication authentication2;
        if (context.getDefaultOrderedRealmList().isEmpty()) {
            logger.debug("No realms available, failing authentication");
            originalListener.onResponse(null);
            return;
        }
        ActionListener listener = originalListener.map(authentication -> {
            this.operatorPrivilegesService.maybeMarkOperatorUser((Authentication)authentication, context.getThreadContext());
            return authentication;
        });
        if (context.getMostRecentAuthenticationToken() != null) {
            this.authenticateAsyncWithExistingAuthenticationToken(context, (ActionListener<Authentication>)listener);
            return;
        }
        try {
            authentication2 = this.lookForExistingAuthentication(context);
        }
        catch (Exception e) {
            listener.onFailure(e);
            return;
        }
        if (authentication2 != null) {
            logger.trace("Found existing authentication [{}] in request [{}]", (Object)authentication2, (Object)context.getRequest());
            listener.onResponse((Object)authentication2);
        } else {
            this.doAuthenticate(context, true, (ActionListener<Authentication>)ActionListener.runBefore((ActionListener)listener, context::close));
        }
    }

    private void authenticateAsyncWithExistingAuthenticationToken(Authenticator.Context context, ActionListener<Authentication> listener) {
        assert (context.getMostRecentAuthenticationToken() != null) : "existing authentication token must not be null";
        context.setHandleNullToken(false);
        this.doAuthenticate(context, false, listener);
    }

    private void doAuthenticate(Authenticator.Context context, boolean shouldExtractCredentials, ActionListener<Authentication> listener) {
        IteratingActionListener iteratingActionListener = new IteratingActionListener(ActionListener.wrap(result -> {
            if (result.getStatus() == Authenticator.Status.SUCCESS) {
                this.maybeLookupRunAsUser(context, result.getAuthentication(), listener);
            } else if (context.shouldHandleNullToken()) {
                this.handleNullToken(context, listener);
            } else {
                listener.onFailure((Exception)((Object)Exceptions.authenticationError((String)"failed to authenticate", (Throwable)result.getException(), (Object[])new Object[0])));
            }
        }, arg_0 -> listener.onFailure(arg_0)), this.getAuthenticatorConsumer(context, shouldExtractCredentials), this.allAuthenticators, context.getThreadContext(), Function.identity(), result -> result.getStatus() == Authenticator.Status.UNSUCCESSFUL || result.getStatus() == Authenticator.Status.NOT_HANDLED);
        iteratingActionListener.run();
    }

    private BiConsumer<Authenticator, ActionListener<Authenticator.Result>> getAuthenticatorConsumer(Authenticator.Context context, boolean shouldExtractCredentials) {
        return (authenticator, listener) -> {
            if (shouldExtractCredentials) {
                AuthenticationToken authenticationToken;
                try {
                    authenticationToken = authenticator.extractCredentials(context);
                }
                catch (Exception e2) {
                    if (e2 instanceof ElasticsearchSecurityException) {
                        listener.onFailure(e2);
                    } else {
                        context.addUnsuccessfulMessage(authenticator.name() + ": " + e2.getMessage());
                        listener.onResponse((Object)Authenticator.Result.unsuccessful(e2.getMessage(), e2));
                    }
                    return;
                }
                if (authenticationToken == null) {
                    listener.onResponse((Object)Authenticator.Result.notHandled());
                    return;
                }
                context.addAuthenticationToken(authenticationToken);
            }
            context.setHandleNullToken(context.shouldHandleNullToken() && authenticator.canBeFollowedByNullTokenHandler());
            authenticator.authenticate(context, (ActionListener<Authenticator.Result>)ActionListener.wrap(result -> {
                if (result.getStatus() == Authenticator.Status.UNSUCCESSFUL) {
                    context.addUnsuccessfulMessage(authenticator.name() + ": " + result.getMessage());
                }
                listener.onResponse(result);
            }, e -> {
                if (e instanceof ElasticsearchSecurityException) {
                    ElasticsearchSecurityException ese = (ElasticsearchSecurityException)((Object)((Object)((Object)e)));
                    if (!context.getUnsuccessfulMessages().isEmpty()) {
                        this.addMetadata(context, ese);
                    }
                }
                listener.onFailure(e);
            }));
        };
    }

    private void maybeLookupRunAsUser(Authenticator.Context context, Authentication authentication, ActionListener<Authentication> listener) {
        if (!this.runAsEnabled || authentication.getAuthenticationType() != Authentication.AuthenticationType.REALM) {
            this.finishAuthentication(context, authentication, listener);
            return;
        }
        String runAsUsername = context.getThreadContext().getHeader("es-security-runas-user");
        if (runAsUsername == null) {
            this.finishAuthentication(context, authentication, listener);
            return;
        }
        User user = authentication.getUser();
        if (runAsUsername.isEmpty()) {
            logger.debug("user [{}] attempted to runAs with an empty username", (Object)user.principal());
            listener.onFailure((Exception)((Object)context.getRequest().runAsDenied(new Authentication(new User(runAsUsername, null, user), authentication.getAuthenticatedBy(), null), context.getMostRecentAuthenticationToken())));
            return;
        }
        this.realmsAuthenticator.lookupRunAsUser(context, authentication, (ActionListener<Tuple<User, Authentication.RealmRef>>)ActionListener.wrap(tuple -> {
            Authentication finalAuth;
            if (tuple == null) {
                logger.debug("Cannot find run-as user [{}] for authenticated user [{}]", (Object)runAsUsername, (Object)user.principal());
                finalAuth = new Authentication(new User(runAsUsername, null, user), authentication.getAuthenticatedBy(), null);
            } else {
                finalAuth = new Authentication(new User((User)tuple.v1(), user), authentication.getAuthenticatedBy(), (Authentication.RealmRef)tuple.v2());
            }
            this.finishAuthentication(context, finalAuth, listener);
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private Authentication lookForExistingAuthentication(Authenticator.Context context) {
        Authentication authentication;
        try {
            authentication = this.authenticationSerializer.readFromContext(context.getThreadContext());
        }
        catch (Exception e) {
            logger.error(() -> new ParameterizedMessage("caught exception while trying to read authentication from request [{}]", (Object)context.getRequest()), (Throwable)e);
            throw context.getRequest().tamperedRequest();
        }
        if (authentication != null && context.getRequest() instanceof AuthenticationService.AuditableRestRequest) {
            throw context.getRequest().tamperedRequest();
        }
        return authentication;
    }

    void handleNullToken(Authenticator.Context context, ActionListener<Authentication> listener) {
        Authentication authentication;
        Authentication.RealmRef authenticatedBy;
        if (context.getFallbackUser() != null) {
            logger.trace("No valid credentials found in request [{}], using fallback [{}]", (Object)context.getRequest(), (Object)context.getFallbackUser().principal());
            authenticatedBy = new Authentication.RealmRef("__fallback", "__fallback", this.nodeName);
            authentication = new Authentication(context.getFallbackUser(), authenticatedBy, null, Version.CURRENT, Authentication.AuthenticationType.INTERNAL, Collections.emptyMap());
        } else if (this.shouldFallbackToAnonymous(context)) {
            logger.trace("No valid credentials found in request [{}], using anonymous [{}]", (Object)context.getRequest(), (Object)this.anonymousUser.principal());
            authenticatedBy = new Authentication.RealmRef("__anonymous", "__anonymous", this.nodeName);
            authentication = new Authentication((User)this.anonymousUser, authenticatedBy, null, Version.CURRENT, Authentication.AuthenticationType.ANONYMOUS, Collections.emptyMap());
        } else {
            authentication = null;
        }
        if (authentication != null) {
            this.writeAuthToContext(context, authentication, listener);
        } else {
            ElasticsearchSecurityException ese = context.getRequest().anonymousAccessDenied();
            if (!context.getUnsuccessfulMessages().isEmpty()) {
                logger.debug("Authenticating with null credentials is unsuccessful in request [{}] after unsuccessful attempts of other credentials", (Object)context.getRequest());
                ElasticsearchSecurityException eseWithPreviousCredentials = new ElasticsearchSecurityException("unable to authenticate with provided credentials and anonymous access is not allowed for this request", ese.status(), ese.getCause(), new Object[0]);
                ese.getHeaderKeys().forEach(k -> eseWithPreviousCredentials.addHeader(k, ese.getHeader(k)));
                this.addMetadata(context, eseWithPreviousCredentials);
                listener.onFailure((Exception)((Object)eseWithPreviousCredentials));
            } else {
                logger.debug("No valid credentials found in request [{}], rejecting", (Object)context.getRequest());
                listener.onFailure((Exception)((Object)ese));
            }
        }
    }

    void finishAuthentication(Authenticator.Context context, Authentication authentication, ActionListener<Authentication> listener) {
        if (!authentication.getUser().enabled() || !authentication.getUser().authenticatedUser().enabled()) {
            logger.debug("user [{}] is disabled. failing authentication", (Object)authentication.getUser());
            listener.onFailure((Exception)((Object)context.getRequest().authenticationFailed(context.getMostRecentAuthenticationToken())));
        } else {
            this.writeAuthToContext(context, authentication, listener);
        }
    }

    void writeAuthToContext(Authenticator.Context context, Authentication authentication, ActionListener<Authentication> listener) {
        try {
            this.authenticationSerializer.writeToContext(authentication, context.getThreadContext());
            context.getRequest().authenticationSuccess(authentication);
        }
        catch (Exception e) {
            logger.debug((Message)new ParameterizedMessage("Failed to store authentication [{}] for request [{}]", (Object)authentication, (Object)context.getRequest()), (Throwable)e);
            ElasticsearchSecurityException ese = context.getRequest().exceptionProcessingRequest(e, context.getMostRecentAuthenticationToken());
            this.addMetadata(context, ese);
            listener.onFailure((Exception)((Object)ese));
            return;
        }
        logger.trace("Established authentication [{}] for request [{}]", (Object)authentication, (Object)context.getRequest());
        listener.onResponse((Object)authentication);
    }

    private void addMetadata(Authenticator.Context context, ElasticsearchSecurityException ese) {
        if (!context.getUnsuccessfulMessages().isEmpty()) {
            ese.addMetadata("es.additional_unsuccessful_credentials", context.getUnsuccessfulMessages());
        }
    }

    private boolean shouldFallbackToAnonymous(Authenticator.Context context) {
        if (!this.isAnonymousUserEnabled) {
            return false;
        }
        if (!context.isAllowAnonymous()) {
            return false;
        }
        String header = context.getThreadContext().getHeader("Authorization");
        return !Strings.hasText((String)header) || (!header.regionMatches(true, 0, "Bearer ", 0, "Bearer ".length()) || header.length() <= "Bearer ".length()) && (!header.regionMatches(true, 0, "ApiKey ", 0, "ApiKey ".length()) || header.length() <= "ApiKey ".length());
    }
}

