/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;

public final class ResultDeduplicator<T, R> {
    private final ConcurrentMap<T, CompositeListener> requests = ConcurrentCollections.newConcurrentMap();

    public void executeOnce(T request, ActionListener<R> listener, BiConsumer<T, ActionListener<R>> callback) {
        CompositeListener completionListener = this.requests.computeIfAbsent(request, x$0 -> new CompositeListener(x$0)).addListener(listener);
        if (completionListener != null) {
            callback.accept(request, completionListener);
        }
    }

    public void clear() {
        this.requests.clear();
    }

    public int size() {
        return this.requests.size();
    }

    private final class CompositeListener
    implements ActionListener<R> {
        private final List<ActionListener<R>> listeners = new ArrayList();
        private final T request;
        private boolean isNotified;
        private Exception failure;
        private R response;

        CompositeListener(T request) {
            this.request = request;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        CompositeListener addListener(ActionListener<R> listener) {
            CompositeListener compositeListener = this;
            synchronized (compositeListener) {
                if (!this.isNotified) {
                    this.listeners.add(listener);
                    return this.listeners.size() == 1 ? this : null;
                }
            }
            if (this.failure != null) {
                listener.onFailure(this.failure);
            } else {
                listener.onResponse(this.response);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onResponse(R response) {
            CompositeListener compositeListener = this;
            synchronized (compositeListener) {
                this.response = response;
                this.isNotified = true;
            }
            try {
                ActionListener.onResponse(this.listeners, response);
            }
            finally {
                ResultDeduplicator.this.requests.remove(this.request);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFailure(Exception failure) {
            CompositeListener compositeListener = this;
            synchronized (compositeListener) {
                this.failure = failure;
                this.isNotified = true;
            }
            try {
                ActionListener.onFailure(this.listeners, failure);
            }
            finally {
                ResultDeduplicator.this.requests.remove(this.request);
            }
        }
    }
}

