/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.nio;

import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.elasticsearch.core.CompletableContext;
import org.elasticsearch.nio.NioChannel;
import org.elasticsearch.nio.NioSelector;

public abstract class ChannelContext<S extends SelectableChannel> {
    protected final S rawChannel;
    private final Consumer<Exception> exceptionHandler;
    private final CompletableContext<Void> closeContext = new CompletableContext();
    private volatile SelectionKey selectionKey;

    ChannelContext(S rawChannel, Consumer<Exception> exceptionHandler) {
        this.rawChannel = rawChannel;
        this.exceptionHandler = exceptionHandler;
    }

    protected void register() throws IOException {
        this.doSelectorRegister();
    }

    protected void channelActive() throws IOException {
    }

    void doSelectorRegister() throws IOException {
        this.setSelectionKey(((SelectableChannel)this.rawChannel).register(this.getSelector().rawSelector(), 0, this));
    }

    protected SelectionKey getSelectionKey() {
        return this.selectionKey;
    }

    public void setSelectionKey(SelectionKey selectionKey) {
        this.selectionKey = selectionKey;
    }

    public void closeFromSelector() throws IOException {
        if (this.isOpen()) {
            try {
                ((AbstractInterruptibleChannel)this.rawChannel).close();
                this.closeContext.complete(null);
            }
            catch (Exception e) {
                this.closeContext.completeExceptionally(e);
                throw e;
            }
        }
    }

    public void addCloseListener(BiConsumer<Void, Exception> listener) {
        this.closeContext.addListener(listener);
    }

    public boolean isOpen() {
        return !this.closeContext.isDone();
    }

    protected void handleException(Exception e) {
        this.exceptionHandler.accept(e);
    }

    public abstract void closeChannel();

    public abstract NioSelector getSelector();

    public abstract NioChannel getChannel();
}

