/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.automaton.TooComplexToDeterminizeException;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xpack.core.security.support.Automatons;

public class StringMatcher
implements Predicate<String> {
    private static final StringMatcher MATCH_NOTHING = new StringMatcher("(empty)", s -> false);
    protected static final Predicate<String> ALWAYS_TRUE_PREDICATE = s -> true;
    private final String description;
    private final Predicate<String> predicate;
    private static final Logger LOGGER = LogManager.getLogger(StringMatcher.class);

    private StringMatcher(String description, Predicate<String> predicate) {
        this.description = description;
        this.predicate = predicate;
    }

    public static StringMatcher of(Iterable<String> patterns) {
        return StringMatcher.builder().includeAll(patterns).build();
    }

    public static StringMatcher of(String ... patterns) {
        return StringMatcher.builder().includeAll(patterns).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return this.description;
    }

    @Override
    public boolean test(String s) {
        return this.predicate.test(s);
    }

    public boolean isTotal() {
        return this.predicate == ALWAYS_TRUE_PREDICATE;
    }

    Predicate<String> getPredicate() {
        return this.predicate;
    }

    public StringMatcher or(Predicate<? super String> other) {
        Objects.requireNonNull(other);
        return new StringMatcher(this.description + "|" + other, this.predicate.or(other));
    }

    public StringMatcher and(Predicate<? super String> other) {
        return this.and(String.valueOf(other), other);
    }

    public StringMatcher and(String otherDescription, Predicate<? super String> otherPredicate) {
        Objects.requireNonNull(otherPredicate);
        return new StringMatcher(this.description + "&" + otherDescription, this.predicate.and(otherPredicate));
    }

    public static class Builder {
        private final List<String> allText = new ArrayList<String>();
        private final Set<String> exactMatch = new HashSet<String>();
        private final Set<String> nonExactMatch = new LinkedHashSet<String>();

        public Builder include(String pattern) {
            this.allText.add(pattern);
            if (pattern.startsWith("/") || pattern.contains("*") || pattern.contains("?")) {
                this.nonExactMatch.add(pattern);
            } else {
                this.exactMatch.add(pattern);
            }
            return this;
        }

        public Builder includeAll(String ... patterns) {
            for (String pattern : patterns) {
                this.include(pattern);
            }
            return this;
        }

        public Builder includeAll(Iterable<String> patterns) {
            for (String pattern : patterns) {
                this.include(pattern);
            }
            return this;
        }

        public StringMatcher build() {
            if (this.allText.isEmpty()) {
                return MATCH_NOTHING;
            }
            String description = Builder.describe(this.allText);
            if (this.nonExactMatch.contains("*")) {
                return new StringMatcher(description, ALWAYS_TRUE_PREDICATE);
            }
            if (this.exactMatch.isEmpty()) {
                return new StringMatcher(description, Builder.buildAutomataPredicate(this.nonExactMatch));
            }
            if (this.nonExactMatch.isEmpty()) {
                return new StringMatcher(description, Builder.buildExactMatchPredicate(this.exactMatch));
            }
            Predicate<String> predicate = Builder.buildExactMatchPredicate(this.exactMatch).or(Builder.buildAutomataPredicate(this.nonExactMatch));
            return new StringMatcher(description, predicate);
        }

        private static String describe(List<String> strings) {
            if (strings.size() == 1) {
                return strings.get(0);
            }
            int totalLength = strings.stream().map(String::length).reduce(0, Math::addExact);
            if (totalLength < 250) {
                return Strings.collectionToDelimitedString(strings, "|");
            }
            int maxItemLength = Math.max(16, 250 / strings.size());
            return strings.stream().map(s -> {
                if (s.length() > maxItemLength) {
                    return Strings.cleanTruncate(s, maxItemLength - 3) + "...";
                }
                return s;
            }).collect(Collectors.joining("|"));
        }

        private static Predicate<String> buildExactMatchPredicate(Set<String> stringValues) {
            if (stringValues.size() == 1) {
                String singleValue = stringValues.iterator().next();
                return singleValue::equals;
            }
            return stringValues::contains;
        }

        private static Predicate<String> buildAutomataPredicate(Collection<String> patterns) {
            try {
                return Automatons.predicate(patterns);
            }
            catch (TooComplexToDeterminizeException e) {
                LOGGER.debug("Pattern automaton [{}] is too complex", (Object)patterns);
                String description = Strings.collectionToCommaDelimitedString(patterns);
                if (description.length() > 80) {
                    description = Strings.cleanTruncate(description, 80) + "...";
                }
                throw new ElasticsearchSecurityException("The set of patterns [{}] is too complex to evaluate", e, description);
            }
        }
    }
}

