/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.monitoring.client;

import java.util.Map;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.xpack.core.monitoring.action.MonitoringBulkAction;
import org.elasticsearch.xpack.core.monitoring.action.MonitoringBulkRequest;
import org.elasticsearch.xpack.core.monitoring.action.MonitoringBulkRequestBuilder;
import org.elasticsearch.xpack.core.monitoring.action.MonitoringBulkResponse;

public class MonitoringClient {
    private final Client client;

    @Inject
    public MonitoringClient(Client client) {
        this.client = client;
    }

    public MonitoringBulkRequestBuilder prepareMonitoringBulk() {
        return new MonitoringBulkRequestBuilder(this.client);
    }

    public void bulk(MonitoringBulkRequest request, ActionListener<MonitoringBulkResponse> listener) {
        this.client.execute(MonitoringBulkAction.INSTANCE, request, listener);
    }

    public ActionFuture<MonitoringBulkResponse> bulk(MonitoringBulkRequest request) {
        return this.client.execute(MonitoringBulkAction.INSTANCE, request);
    }

    public MonitoringClient filterWithHeader(Map<String, String> headers) {
        return new MonitoringClient(this.client.filterWithHeader(headers));
    }
}

