/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Pattern;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelConfig;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class PutTrainedModelAliasAction
extends ActionType<AcknowledgedResponse> {
    private static final Pattern VALID_MODEL_ALIAS_CHAR_PATTERN = Pattern.compile("[a-z0-9](?:[a-z0-9_\\-\\.]*[a-z])?");
    public static final PutTrainedModelAliasAction INSTANCE = new PutTrainedModelAliasAction();
    public static final String NAME = "cluster:admin/xpack/ml/inference/model_aliases/put";

    private PutTrainedModelAliasAction() {
        super(NAME, AcknowledgedResponse::readFrom);
    }

    public static class Request
    extends AcknowledgedRequest<Request> {
        public static final String MODEL_ALIAS = "model_alias";
        public static final String REASSIGN = "reassign";
        private final String modelAlias;
        private final String modelId;
        private final boolean reassign;

        public Request(String modelAlias, String modelId, boolean reassign) {
            this.modelAlias = ExceptionsHelper.requireNonNull(modelAlias, MODEL_ALIAS);
            this.modelId = ExceptionsHelper.requireNonNull(modelId, TrainedModelConfig.MODEL_ID);
            this.reassign = reassign;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.modelAlias = in.readString();
            this.modelId = in.readString();
            this.reassign = in.readBoolean();
        }

        public String getModelAlias() {
            return this.modelAlias;
        }

        public String getModelId() {
            return this.modelId;
        }

        public boolean isReassign() {
            return this.reassign;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.modelAlias);
            out.writeString(this.modelId);
            out.writeBoolean(this.reassign);
        }

        @Override
        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (this.modelAlias.equals(this.modelId)) {
                validationException = ValidateActions.addValidationError(String.format(Locale.ROOT, "model_alias [%s] cannot equal model_id [%s]", this.modelAlias, this.modelId), validationException);
            }
            if (!VALID_MODEL_ALIAS_CHAR_PATTERN.matcher(this.modelAlias).matches()) {
                validationException = ValidateActions.addValidationError(Messages.getMessage("Invalid model_alias; ''{0}'' can contain lowercase alphanumeric (a-z and 0-9), hyphens or underscores; must start with alphanumeric and cannot end with numbers", this.modelAlias), validationException);
            }
            return validationException;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return Objects.equals(this.modelAlias, request.modelAlias) && Objects.equals(this.modelId, request.modelId) && Objects.equals(this.reassign, request.reassign);
        }

        public int hashCode() {
            return Objects.hash(this.modelAlias, this.modelId, this.reassign);
        }
    }
}

