/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ilm.LifecycleAction;

public class Phase
implements ToXContentObject,
Writeable {
    private static final Logger logger = LogManager.getLogger(Phase.class);
    public static final ParseField MIN_AGE = new ParseField("min_age", new String[0]);
    public static final ParseField ACTIONS_FIELD = new ParseField("actions", new String[0]);
    private static final ConstructingObjectParser<Phase, String> PARSER = new ConstructingObjectParser<Phase, String>("phase", false, (a, name) -> {
        List lifecycleActions = (List)a[1];
        HashMap<String, LifecycleAction> map = new HashMap<String, LifecycleAction>(lifecycleActions.size());
        for (LifecycleAction lifecycleAction : lifecycleActions) {
            if (map.put(lifecycleAction.getWriteableName(), lifecycleAction) == null) continue;
            throw new IllegalStateException("Duplicate key");
        }
        return new Phase((String)name, (TimeValue)a[0], (Map<String, LifecycleAction>)map);
    });
    private final String name;
    private final Map<String, LifecycleAction> actions;
    private final TimeValue minimumAge;

    public static Phase parse(XContentParser parser, String name) {
        return PARSER.apply(parser, name);
    }

    public Phase(String name, TimeValue minimumAge, Map<String, LifecycleAction> actions) {
        this.name = name;
        this.minimumAge = minimumAge == null ? TimeValue.ZERO : minimumAge;
        this.actions = actions;
    }

    public Phase(StreamInput in) throws IOException {
        this.name = in.readString();
        this.minimumAge = in.readTimeValue();
        int size = in.readVInt();
        TreeMap<String, LifecycleAction> actions = new TreeMap<String, LifecycleAction>();
        for (int i = 0; i < size; ++i) {
            actions.put(in.readString(), in.readNamedWriteable(LifecycleAction.class));
        }
        this.actions = actions;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeTimeValue(this.minimumAge);
        out.writeVInt(this.actions.size());
        for (Map.Entry<String, LifecycleAction> entry : this.actions.entrySet()) {
            out.writeString(entry.getKey());
            out.writeNamedWriteable(entry.getValue());
        }
    }

    public TimeValue getMinimumAge() {
        return this.minimumAge;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, LifecycleAction> getActions() {
        return this.actions;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(MIN_AGE.getPreferredName(), this.minimumAge.getStringRep());
        builder.xContentValuesMap(ACTIONS_FIELD.getPreferredName(), this.actions);
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.minimumAge, this.actions);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        Phase other = (Phase)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.minimumAge, other.minimumAge) && Objects.equals(this.actions, other.actions);
    }

    public String toString() {
        return Strings.toString(this, true, true);
    }

    static {
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> {
            assert (Version.CURRENT.major < 9) : "remove this hack now that we don't have to read 7.x cluster states";
            String timeValueString = p.text();
            if (timeValueString.startsWith("-")) {
                logger.warn("phase has negative min_age value of [{}] - this will be treated as a min_age of 0", (Object)timeValueString);
                return TimeValue.ZERO;
            }
            return TimeValue.parseTimeValue(timeValueString, MIN_AGE.getPreferredName());
        }, MIN_AGE, ObjectParser.ValueType.VALUE);
        PARSER.declareNamedObjects(ConstructingObjectParser.constructorArg(), (p, c, n) -> p.namedObject(LifecycleAction.class, n, null), v -> {
            throw new IllegalArgumentException("ordered " + ACTIONS_FIELD.getPreferredName() + " are not supported");
        }, ACTIONS_FIELD);
    }
}

