/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.license.LicensingClient;
import org.elasticsearch.protocol.xpack.XPackInfoRequest;
import org.elasticsearch.protocol.xpack.XPackInfoResponse;
import org.elasticsearch.protocol.xpack.frozen.FreezeRequest;
import org.elasticsearch.protocol.xpack.frozen.FreezeResponse;
import org.elasticsearch.xpack.core.action.XPackInfoAction;
import org.elasticsearch.xpack.core.action.XPackInfoRequestBuilder;
import org.elasticsearch.xpack.core.ccr.client.CcrClient;
import org.elasticsearch.xpack.core.datastreams.DataStreamClient;
import org.elasticsearch.xpack.core.enrich.client.EnrichClient;
import org.elasticsearch.xpack.core.frozen.action.FreezeIndexAction;
import org.elasticsearch.xpack.core.ilm.client.ILMClient;
import org.elasticsearch.xpack.core.ml.client.MachineLearningClient;
import org.elasticsearch.xpack.core.monitoring.client.MonitoringClient;
import org.elasticsearch.xpack.core.security.authc.support.UsernamePasswordToken;
import org.elasticsearch.xpack.core.security.client.SecurityClient;
import org.elasticsearch.xpack.core.watcher.client.WatcherClient;

public class XPackClient {
    private final Client client;
    private final CcrClient ccrClient;
    private final LicensingClient licensingClient;
    private final MonitoringClient monitoringClient;
    private final SecurityClient securityClient;
    private final WatcherClient watcherClient;
    private final MachineLearningClient machineLearning;
    private final ILMClient ilmClient;
    private final EnrichClient enrichClient;
    private final DataStreamClient dataStreamClient;

    public XPackClient(Client client) {
        this.client = Objects.requireNonNull(client, "client");
        this.ccrClient = new CcrClient(client);
        this.licensingClient = new LicensingClient(client);
        this.monitoringClient = new MonitoringClient(client);
        this.securityClient = new SecurityClient(client);
        this.watcherClient = new WatcherClient(client);
        this.machineLearning = new MachineLearningClient(client);
        this.ilmClient = new ILMClient(client);
        this.enrichClient = new EnrichClient(client);
        this.dataStreamClient = new DataStreamClient(client);
    }

    public Client es() {
        return this.client;
    }

    public CcrClient ccr() {
        return this.ccrClient;
    }

    public LicensingClient licensing() {
        return this.licensingClient;
    }

    public MonitoringClient monitoring() {
        return this.monitoringClient;
    }

    public SecurityClient security() {
        return this.securityClient;
    }

    public WatcherClient watcher() {
        return this.watcherClient;
    }

    public MachineLearningClient machineLearning() {
        return this.machineLearning;
    }

    public ILMClient ilmClient() {
        return this.ilmClient;
    }

    public EnrichClient enrichClient() {
        return this.enrichClient;
    }

    public DataStreamClient dataStreamClient() {
        return this.dataStreamClient;
    }

    public XPackClient withHeaders(Map<String, String> headers) {
        return new XPackClient(this.client.filterWithHeader(headers));
    }

    public XPackClient withAuth(String username, char[] passwd) {
        return this.withHeaders(Collections.singletonMap("Authorization", UsernamePasswordToken.basicAuthHeaderValue(username, new SecureString(passwd))));
    }

    public XPackInfoRequestBuilder prepareInfo() {
        return new XPackInfoRequestBuilder(this.client);
    }

    public void info(XPackInfoRequest request, ActionListener<XPackInfoResponse> listener) {
        this.client.execute(XPackInfoAction.INSTANCE, request, listener);
    }

    public void freeze(FreezeRequest request, ActionListener<FreezeResponse> listener) {
        this.client.execute(FreezeIndexAction.INSTANCE, request, listener);
    }

    public FreezeResponse freeze(FreezeRequest request) throws ExecutionException, InterruptedException {
        PlainActionFuture<FreezeResponse> future = new PlainActionFuture<FreezeResponse>();
        this.freeze(request, future);
        return (FreezeResponse)future.get();
    }
}

