/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.nio;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.PageCacheRecycler;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.http.HttpServerTransport;
import org.elasticsearch.http.nio.NioHttpServerTransport;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.plugins.NetworkPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.nio.NioGroupFactory;
import org.elasticsearch.transport.nio.NioTransport;
import org.elasticsearch.xcontent.NamedXContentRegistry;

public class NioTransportPlugin
extends Plugin
implements NetworkPlugin {
    public static final String NIO_TRANSPORT_NAME = "nio-transport";
    public static final String NIO_HTTP_TRANSPORT_NAME = "nio-http-transport";
    private static final Logger logger = LogManager.getLogger(NioTransportPlugin.class);
    public static final Setting<Integer> NIO_WORKER_COUNT = new Setting<Integer>("transport.nio.worker_count", s -> Integer.toString(EsExecutors.allocatedProcessors(s)), s -> Setting.parseInt(s, 1, "transport.nio.worker_count"), Setting.Property.NodeScope);
    public static final Setting<Integer> NIO_HTTP_WORKER_COUNT = Setting.intSetting("http.nio.worker_count", 0, 0, Setting.Property.NodeScope);
    private final SetOnce<NioGroupFactory> groupFactory = new SetOnce();

    @Override
    public List<Setting<?>> getSettings() {
        return Arrays.asList(NIO_HTTP_WORKER_COUNT, NIO_WORKER_COUNT);
    }

    @Override
    public Map<String, Supplier<Transport>> getTransports(Settings settings, ThreadPool threadPool, PageCacheRecycler pageCacheRecycler, CircuitBreakerService circuitBreakerService, NamedWriteableRegistry namedWriteableRegistry, NetworkService networkService) {
        return Collections.singletonMap(NIO_TRANSPORT_NAME, () -> new NioTransport(settings, Version.CURRENT, threadPool, networkService, pageCacheRecycler, namedWriteableRegistry, circuitBreakerService, this.getNioGroupFactory(settings)));
    }

    @Override
    public Map<String, Supplier<HttpServerTransport>> getHttpTransports(Settings settings, ThreadPool threadPool, BigArrays bigArrays, PageCacheRecycler pageCacheRecycler, CircuitBreakerService circuitBreakerService, NamedXContentRegistry xContentRegistry, NetworkService networkService, HttpServerTransport.Dispatcher dispatcher, ClusterSettings clusterSettings) {
        return Collections.singletonMap(NIO_HTTP_TRANSPORT_NAME, () -> new NioHttpServerTransport(settings, networkService, bigArrays, pageCacheRecycler, threadPool, xContentRegistry, dispatcher, this.getNioGroupFactory(settings), clusterSettings));
    }

    private synchronized NioGroupFactory getNioGroupFactory(Settings settings) {
        NioGroupFactory nioGroupFactory = this.groupFactory.get();
        if (nioGroupFactory != null) {
            assert (nioGroupFactory.getSettings().equals(settings)) : "Different settings than originally provided";
            return nioGroupFactory;
        }
        this.groupFactory.set(new NioGroupFactory(settings, logger));
        return this.groupFactory.get();
    }
}

