/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.fielddata.MultiGeoPointValues;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.metrics.CompensatedSum;
import org.elasticsearch.search.aggregations.metrics.InternalGeoCentroid;
import org.elasticsearch.search.aggregations.metrics.MetricsAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;

final class GeoCentroidAggregator
extends MetricsAggregator {
    private final ValuesSource.GeoPoint valuesSource;
    private DoubleArray lonSum;
    private DoubleArray lonCompensations;
    private DoubleArray latSum;
    private DoubleArray latCompensations;
    private LongArray counts;

    GeoCentroidAggregator(String name, ValuesSourceConfig valuesSourceConfig, AggregationContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, metadata);
        ValuesSource.GeoPoint geoPoint = this.valuesSource = valuesSourceConfig.hasValues() ? (ValuesSource.GeoPoint)valuesSourceConfig.getValuesSource() : null;
        if (this.valuesSource != null) {
            this.lonSum = this.bigArrays().newDoubleArray(1L, true);
            this.lonCompensations = this.bigArrays().newDoubleArray(1L, true);
            this.latSum = this.bigArrays().newDoubleArray(1L, true);
            this.latCompensations = this.bigArrays().newDoubleArray(1L, true);
            this.counts = this.bigArrays().newLongArray(1L, true);
        }
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        if (this.valuesSource == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final MultiGeoPointValues values = this.valuesSource.geoPointValues(ctx);
        final CompensatedSum compensatedSumLat = new CompensatedSum(0.0, 0.0);
        final CompensatedSum compensatedSumLon = new CompensatedSum(0.0, 0.0);
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                GeoCentroidAggregator.this.latSum = GeoCentroidAggregator.this.bigArrays().grow(GeoCentroidAggregator.this.latSum, bucket + 1L);
                GeoCentroidAggregator.this.lonSum = GeoCentroidAggregator.this.bigArrays().grow(GeoCentroidAggregator.this.lonSum, bucket + 1L);
                GeoCentroidAggregator.this.lonCompensations = GeoCentroidAggregator.this.bigArrays().grow(GeoCentroidAggregator.this.lonCompensations, bucket + 1L);
                GeoCentroidAggregator.this.latCompensations = GeoCentroidAggregator.this.bigArrays().grow(GeoCentroidAggregator.this.latCompensations, bucket + 1L);
                GeoCentroidAggregator.this.counts = GeoCentroidAggregator.this.bigArrays().grow(GeoCentroidAggregator.this.counts, bucket + 1L);
                if (values.advanceExact(doc)) {
                    int valueCount = values.docValueCount();
                    GeoCentroidAggregator.this.counts.increment(bucket, valueCount);
                    double sumLat = GeoCentroidAggregator.this.latSum.get(bucket);
                    double compensationLat = GeoCentroidAggregator.this.latCompensations.get(bucket);
                    double sumLon = GeoCentroidAggregator.this.lonSum.get(bucket);
                    double compensationLon = GeoCentroidAggregator.this.lonCompensations.get(bucket);
                    compensatedSumLat.reset(sumLat, compensationLat);
                    compensatedSumLon.reset(sumLon, compensationLon);
                    for (int i = 0; i < valueCount; ++i) {
                        GeoPoint value = values.nextValue();
                        compensatedSumLat.add(value.getLat());
                        compensatedSumLon.add(value.getLon());
                    }
                    GeoCentroidAggregator.this.lonSum.set(bucket, compensatedSumLon.value());
                    GeoCentroidAggregator.this.lonCompensations.set(bucket, compensatedSumLon.delta());
                    GeoCentroidAggregator.this.latSum.set(bucket, compensatedSumLat.value());
                    GeoCentroidAggregator.this.latCompensations.set(bucket, compensatedSumLat.delta());
                }
            }
        };
    }

    @Override
    public InternalAggregation buildAggregation(long bucket) {
        if (this.valuesSource == null || bucket >= this.counts.size()) {
            return this.buildEmptyAggregation();
        }
        long bucketCount = this.counts.get(bucket);
        GeoPoint bucketCentroid = bucketCount > 0L ? new GeoPoint(this.latSum.get(bucket) / (double)bucketCount, this.lonSum.get(bucket) / (double)bucketCount) : null;
        return new InternalGeoCentroid(this.name, bucketCentroid, bucketCount, this.metadata());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalGeoCentroid(this.name, null, 0L, this.metadata());
    }

    @Override
    public void doClose() {
        Releasables.close(this.latSum, this.latCompensations, this.lonSum, this.lonCompensations, this.counts);
    }
}

