/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;
import org.apache.lucene.util.automaton.MinimizationOperations;
import org.apache.lucene.util.automaton.Operations;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.snapshots.features.ResetFeatureStateResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexAction;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.TriConsumer;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Booleans;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.Index;
import org.elasticsearch.indices.AssociatedIndexDescriptor;
import org.elasticsearch.indices.ExecutorSelector;
import org.elasticsearch.indices.IndexPatternMatcher;
import org.elasticsearch.indices.SystemDataStreamDescriptor;
import org.elasticsearch.indices.SystemIndexDescriptor;
import org.elasticsearch.plugins.SystemIndexPlugin;
import org.elasticsearch.tasks.TaskResultsService;

public class SystemIndices {
    public static final String SYSTEM_INDEX_ACCESS_CONTROL_HEADER_KEY = "_system_index_access_allowed";
    public static final String EXTERNAL_SYSTEM_INDEX_ACCESS_CONTROL_HEADER_KEY = "_external_system_index_access_origin";
    public static final String UPGRADED_INDEX_SUFFIX = "-reindexed-for-8";
    private static final Automaton EMPTY = Automata.makeEmpty();
    private static final Map<String, Feature> SERVER_SYSTEM_INDEX_DESCRIPTORS = Collections.singletonMap("tasks", new Feature("tasks", "Manages task results", Collections.singletonList(TaskResultsService.TASKS_DESCRIPTOR)));
    private final CharacterRunAutomaton systemIndexAutomaton;
    private final CharacterRunAutomaton systemDataStreamIndicesAutomaton;
    private final CharacterRunAutomaton netNewSystemIndexAutomaton;
    private final Predicate<String> systemDataStreamAutomaton;
    private final Map<String, Feature> featureDescriptors;
    private final Map<String, CharacterRunAutomaton> productToSystemIndicesMatcher;
    private final ExecutorSelector executorSelector;

    public SystemIndices(Map<String, Feature> pluginAndModulesDescriptors) {
        this.featureDescriptors = SystemIndices.buildSystemIndexDescriptorMap(pluginAndModulesDescriptors);
        SystemIndices.checkForOverlappingPatterns(this.featureDescriptors);
        SystemIndices.ensurePatternsAllowSuffix(this.featureDescriptors);
        SystemIndices.checkForDuplicateAliases(this.getSystemIndexDescriptors());
        this.systemIndexAutomaton = SystemIndices.buildIndexCharacterRunAutomaton(this.featureDescriptors);
        this.netNewSystemIndexAutomaton = SystemIndices.buildNetNewIndexCharacterRunAutomaton(this.featureDescriptors);
        this.systemDataStreamIndicesAutomaton = SystemIndices.buildDataStreamBackingIndicesAutomaton(this.featureDescriptors);
        this.systemDataStreamAutomaton = SystemIndices.buildDataStreamNamePredicate(this.featureDescriptors);
        this.productToSystemIndicesMatcher = SystemIndices.getProductToSystemIndicesMap(this.featureDescriptors);
        this.executorSelector = new ExecutorSelector(this);
    }

    static void ensurePatternsAllowSuffix(Map<String, Feature> features) {
        String suffixPattern = "*-reindexed-for-8";
        List descriptorsWithNoRoomForSuffix = features.entrySet().stream().flatMap(feature -> ((Feature)feature.getValue()).getIndexDescriptors().stream().filter(descriptor -> !SystemIndices.overlaps(descriptor.getIndexPattern(), suffixPattern)).map(descriptor -> new ParameterizedMessage("pattern [{}] from feature [{}]", (Object)descriptor.getIndexPattern(), feature.getKey()).getFormattedMessage())).collect(Collectors.toList());
        if (!descriptorsWithNoRoomForSuffix.isEmpty()) {
            throw new IllegalStateException(new ParameterizedMessage("the following system index patterns do not allow suffix [{}] required to allow upgrades: [{}]", (Object)UPGRADED_INDEX_SUFFIX, (Object)descriptorsWithNoRoomForSuffix).getFormattedMessage());
        }
    }

    private static void checkForDuplicateAliases(Collection<SystemIndexDescriptor> descriptors) {
        HashMap<String, Integer> aliasCounts = new HashMap<String, Integer>();
        for (SystemIndexDescriptor descriptor : descriptors) {
            String aliasName = descriptor.getAliasName();
            if (aliasName == null) continue;
            aliasCounts.compute(aliasName, (alias, existingCount) -> 1 + (existingCount == null ? 0 : existingCount));
        }
        List duplicateAliases = aliasCounts.entrySet().stream().filter(entry -> (Integer)entry.getValue() > 1).map(Map.Entry::getKey).sorted().collect(Collectors.toList());
        if (!duplicateAliases.isEmpty()) {
            throw new IllegalStateException("Found aliases associated with multiple system index descriptors: " + duplicateAliases + "");
        }
    }

    private static Map<String, CharacterRunAutomaton> getProductToSystemIndicesMap(Map<String, Feature> descriptors) {
        HashMap productToSystemIndicesMap = new HashMap();
        for (Feature feature : descriptors.values()) {
            feature.getIndexDescriptors().forEach(systemIndexDescriptor -> {
                if (systemIndexDescriptor.isExternal()) {
                    systemIndexDescriptor.getAllowedElasticProductOrigins().forEach(origin -> productToSystemIndicesMap.compute(origin, (key, value) -> {
                        Automaton automaton = SystemIndexDescriptor.buildAutomaton(systemIndexDescriptor.getIndexPattern(), systemIndexDescriptor.getAliasName());
                        return value == null ? automaton : Operations.union(value, automaton);
                    }));
                }
            });
            feature.getDataStreamDescriptors().forEach(dataStreamDescriptor -> {
                if (dataStreamDescriptor.isExternal()) {
                    dataStreamDescriptor.getAllowedElasticProductOrigins().forEach(origin -> productToSystemIndicesMap.compute(origin, (key, value) -> {
                        Automaton automaton = SystemIndexDescriptor.buildAutomaton(dataStreamDescriptor.getBackingIndexPattern(), dataStreamDescriptor.getDataStreamName());
                        return value == null ? automaton : Operations.union(value, automaton);
                    }));
                }
            });
        }
        return Collections.unmodifiableMap(productToSystemIndicesMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new CharacterRunAutomaton(MinimizationOperations.minimize((Automaton)entry.getValue(), Integer.MAX_VALUE)))));
    }

    public boolean isSystemName(String name) {
        return this.isSystemIndex(name) || this.isSystemDataStream(name) || this.isSystemIndexBackingDataStream(name);
    }

    public boolean isSystemIndex(Index index) {
        return this.isSystemIndex(index.getName());
    }

    public boolean isSystemIndex(String indexName) {
        return this.systemIndexAutomaton.run(indexName);
    }

    public boolean isSystemDataStream(String name) {
        return this.systemDataStreamAutomaton.test(name);
    }

    public boolean isSystemIndexBackingDataStream(String name) {
        return this.systemDataStreamIndicesAutomaton.run(name);
    }

    public boolean isNetNewSystemIndex(String indexName) {
        return this.netNewSystemIndexAutomaton.run(indexName);
    }

    public ExecutorSelector getExecutorSelector() {
        return this.executorSelector;
    }

    @Nullable
    public SystemIndexDescriptor findMatchingDescriptor(String name) {
        List matchingDescriptors = this.featureDescriptors.values().stream().flatMap(feature -> feature.getIndexDescriptors().stream()).filter(descriptor -> descriptor.matchesIndexPattern(name)).collect(Collectors.toList());
        if (matchingDescriptors.isEmpty()) {
            return null;
        }
        if (matchingDescriptors.size() == 1) {
            return (SystemIndexDescriptor)matchingDescriptors.get(0);
        }
        StringBuilder errorMessage = new StringBuilder().append("index name [").append(name).append("] is claimed as a system index by multiple system index patterns: [").append(matchingDescriptors.stream().map(descriptor -> "pattern: [" + descriptor.getIndexPattern() + "], description: [" + descriptor.getDescription() + "]").collect(Collectors.joining("; ")));
        assert (false) : errorMessage.toString();
        throw new IllegalStateException(errorMessage.toString());
    }

    @Nullable
    public SystemDataStreamDescriptor findMatchingDataStreamDescriptor(String name) {
        List matchingDescriptors = this.featureDescriptors.values().stream().flatMap(feature -> feature.getDataStreamDescriptors().stream()).filter(descriptor -> descriptor.getDataStreamName().equals(name)).collect(Collectors.toList());
        if (matchingDescriptors.isEmpty()) {
            return null;
        }
        if (matchingDescriptors.size() == 1) {
            return (SystemDataStreamDescriptor)matchingDescriptors.get(0);
        }
        StringBuilder errorMessage = new StringBuilder().append("DataStream name [").append(name).append("] is claimed as a system data stream by multiple descriptors: [").append(matchingDescriptors.stream().map(descriptor -> "name: [" + descriptor.getDataStreamName() + "], description: [" + descriptor.getDescription() + "]").collect(Collectors.joining("; ")));
        assert (false) : errorMessage.toString();
        throw new IllegalStateException(errorMessage.toString());
    }

    public Predicate<IndexMetadata> getProductSystemIndexMetadataPredicate(ThreadContext threadContext) {
        String product = threadContext.getHeader(EXTERNAL_SYSTEM_INDEX_ACCESS_CONTROL_HEADER_KEY);
        if (product == null) {
            return indexMetadata -> false;
        }
        CharacterRunAutomaton automaton = this.productToSystemIndicesMatcher.get(product);
        if (automaton == null) {
            return indexMetadata -> false;
        }
        return indexMetadata -> automaton.run(indexMetadata.getIndex().getName());
    }

    public Predicate<String> getProductSystemIndexNamePredicate(ThreadContext threadContext) {
        String product = threadContext.getHeader(EXTERNAL_SYSTEM_INDEX_ACCESS_CONTROL_HEADER_KEY);
        if (product == null) {
            return name -> false;
        }
        CharacterRunAutomaton automaton = this.productToSystemIndicesMatcher.get(product);
        if (automaton == null) {
            return name -> false;
        }
        return automaton::run;
    }

    public Map<String, Feature> getFeatures() {
        return this.featureDescriptors;
    }

    private static CharacterRunAutomaton buildIndexCharacterRunAutomaton(Map<String, Feature> descriptors) {
        Optional<Automaton> automaton = descriptors.values().stream().map(SystemIndices::featureToIndexAutomaton).reduce(Operations::union);
        return new CharacterRunAutomaton(MinimizationOperations.minimize(automaton.orElse(EMPTY), Integer.MAX_VALUE));
    }

    private static CharacterRunAutomaton buildNetNewIndexCharacterRunAutomaton(Map<String, Feature> featureDescriptors) {
        Optional<Automaton> automaton = featureDescriptors.values().stream().flatMap(feature -> feature.getIndexDescriptors().stream()).filter(SystemIndexDescriptor::isNetNew).map(descriptor -> SystemIndexDescriptor.buildAutomaton(descriptor.getIndexPattern(), descriptor.getAliasName())).reduce(Operations::union);
        return new CharacterRunAutomaton(MinimizationOperations.minimize(automaton.orElse(EMPTY), Integer.MAX_VALUE));
    }

    private static Automaton featureToIndexAutomaton(Feature feature) {
        Optional<Automaton> systemIndexAutomaton = feature.getIndexDescriptors().stream().map(descriptor -> SystemIndexDescriptor.buildAutomaton(descriptor.getIndexPattern(), descriptor.getAliasName())).reduce(Operations::union);
        return systemIndexAutomaton.orElse(EMPTY);
    }

    private static Predicate<String> buildDataStreamNamePredicate(Map<String, Feature> descriptors) {
        Set systemDataStreamNames = descriptors.values().stream().flatMap(feature -> feature.getDataStreamDescriptors().stream()).map(SystemDataStreamDescriptor::getDataStreamName).collect(Collectors.toSet());
        return systemDataStreamNames::contains;
    }

    private static CharacterRunAutomaton buildDataStreamBackingIndicesAutomaton(Map<String, Feature> descriptors) {
        Optional<Automaton> automaton = descriptors.values().stream().map(SystemIndices::featureToDataStreamBackingIndicesAutomaton).reduce(Operations::union);
        return new CharacterRunAutomaton(automaton.orElse(EMPTY));
    }

    private static Automaton featureToDataStreamBackingIndicesAutomaton(Feature feature) {
        Optional<Automaton> systemDataStreamAutomaton = feature.getDataStreamDescriptors().stream().map(descriptor -> SystemIndexDescriptor.buildAutomaton(descriptor.getBackingIndexPattern(), null)).reduce(Operations::union);
        return systemDataStreamAutomaton.orElse(EMPTY);
    }

    public SystemDataStreamDescriptor validateDataStreamAccess(String dataStreamName, ThreadContext threadContext) {
        if (this.systemDataStreamAutomaton.test(dataStreamName)) {
            SystemDataStreamDescriptor dataStreamDescriptor = this.featureDescriptors.values().stream().flatMap(feature -> feature.getDataStreamDescriptors().stream()).filter(descriptor -> descriptor.getDataStreamName().equals(dataStreamName)).findFirst().orElseThrow(() -> new IllegalStateException("system data stream descriptor not found for [" + dataStreamName + "]"));
            if (dataStreamDescriptor.isExternal()) {
                SystemIndexAccessLevel accessLevel = this.getSystemIndexAccessLevel(threadContext);
                assert (accessLevel != SystemIndexAccessLevel.BACKWARDS_COMPATIBLE_ONLY) : "BACKWARDS_COMPATIBLE access level is leaking";
                if (accessLevel == SystemIndexAccessLevel.NONE) {
                    throw this.dataStreamAccessException(null, dataStreamName);
                }
                if (accessLevel == SystemIndexAccessLevel.RESTRICTED) {
                    if (!this.getProductSystemIndexNamePredicate(threadContext).test(dataStreamName)) {
                        throw this.dataStreamAccessException(threadContext.getHeader(EXTERNAL_SYSTEM_INDEX_ACCESS_CONTROL_HEADER_KEY), dataStreamName);
                    }
                    return dataStreamDescriptor;
                }
                assert (accessLevel == SystemIndexAccessLevel.ALL || accessLevel == SystemIndexAccessLevel.BACKWARDS_COMPATIBLE_ONLY);
                return dataStreamDescriptor;
            }
            return dataStreamDescriptor;
        }
        return null;
    }

    public IllegalArgumentException dataStreamAccessException(ThreadContext threadContext, Collection<String> names) {
        return this.dataStreamAccessException(threadContext.getHeader(EXTERNAL_SYSTEM_INDEX_ACCESS_CONTROL_HEADER_KEY), names.toArray(Strings.EMPTY_ARRAY));
    }

    public IllegalArgumentException netNewSystemIndexAccessException(ThreadContext threadContext, Collection<String> names) {
        String product = threadContext.getHeader(EXTERNAL_SYSTEM_INDEX_ACCESS_CONTROL_HEADER_KEY);
        if (product == null) {
            return new IllegalArgumentException("Indices " + Arrays.toString(names.toArray(Strings.EMPTY_ARRAY)) + " use and access is reserved for system operations");
        }
        return new IllegalArgumentException("Indices " + Arrays.toString(names.toArray(Strings.EMPTY_ARRAY)) + " use and access is reserved for system operations");
    }

    IllegalArgumentException dataStreamAccessException(@Nullable String product, String ... dataStreamNames) {
        if (product == null) {
            return new IllegalArgumentException("Data stream(s) " + Arrays.toString(dataStreamNames) + " use and access is reserved for system operations");
        }
        return new IllegalArgumentException("Data stream(s) " + Arrays.toString(dataStreamNames) + " may not be accessed by product [" + product + "]");
    }

    public SystemIndexAccessLevel getSystemIndexAccessLevel(ThreadContext threadContext) {
        String headerValue = threadContext.getHeader(SYSTEM_INDEX_ACCESS_CONTROL_HEADER_KEY);
        String productHeaderValue = threadContext.getHeader(EXTERNAL_SYSTEM_INDEX_ACCESS_CONTROL_HEADER_KEY);
        boolean allowed = Booleans.parseBoolean(headerValue, true);
        if (allowed) {
            if (productHeaderValue != null) {
                return SystemIndexAccessLevel.RESTRICTED;
            }
            return SystemIndexAccessLevel.ALL;
        }
        return SystemIndexAccessLevel.NONE;
    }

    static void checkForOverlappingPatterns(Map<String, Feature> sourceToFeature) {
        List<Tuple> sourceDescriptorPair = sourceToFeature.entrySet().stream().flatMap(entry -> ((Feature)entry.getValue()).getIndexDescriptors().stream().map(descriptor -> new Tuple<String, SystemIndexDescriptor>((String)entry.getKey(), (SystemIndexDescriptor)descriptor))).sorted(Comparator.comparing(d -> (String)d.v1() + ":" + ((SystemIndexDescriptor)d.v2()).getIndexPattern())).collect(Collectors.toList());
        List sourceDataStreamDescriptorPair = sourceToFeature.entrySet().stream().filter(entry -> !((Feature)entry.getValue()).getDataStreamDescriptors().isEmpty()).flatMap(entry -> ((Feature)entry.getValue()).getDataStreamDescriptors().stream().map(descriptor -> new Tuple<String, SystemDataStreamDescriptor>((String)entry.getKey(), (SystemDataStreamDescriptor)descriptor))).sorted(Comparator.comparing(d -> (String)d.v1() + ":" + ((SystemDataStreamDescriptor)d.v2()).getDataStreamName())).collect(Collectors.toList());
        sourceDescriptorPair.forEach(descriptorToCheck -> {
            List descriptorsMatchingThisPattern = sourceDescriptorPair.stream().filter(d -> descriptorToCheck.v2() != d.v2()).filter(d -> SystemIndices.overlaps((SystemIndexDescriptor)descriptorToCheck.v2(), (SystemIndexDescriptor)d.v2()) || ((SystemIndexDescriptor)d.v2()).getAliasName() != null && ((SystemIndexDescriptor)descriptorToCheck.v2()).matchesIndexPattern(((SystemIndexDescriptor)d.v2()).getAliasName())).collect(Collectors.toList());
            if (!descriptorsMatchingThisPattern.isEmpty()) {
                throw new IllegalStateException("a system index descriptor [" + descriptorToCheck.v2() + "] from [" + (String)descriptorToCheck.v1() + "] overlaps with other system index descriptors: [" + descriptorsMatchingThisPattern.stream().map(descriptor -> descriptor.v2() + " from [" + (String)descriptor.v1() + "]").collect(Collectors.joining(", ")));
            }
            List dataStreamsMatching = sourceDataStreamDescriptorPair.stream().filter(dsTuple -> ((SystemIndexDescriptor)descriptorToCheck.v2()).matchesIndexPattern(((SystemDataStreamDescriptor)dsTuple.v2()).getDataStreamName()) || SystemIndices.overlaps(((SystemIndexDescriptor)descriptorToCheck.v2()).getIndexPattern(), ((SystemDataStreamDescriptor)dsTuple.v2()).getBackingIndexPattern())).collect(Collectors.toList());
            if (!dataStreamsMatching.isEmpty()) {
                throw new IllegalStateException("a system index descriptor [" + descriptorToCheck.v2() + "] from [" + (String)descriptorToCheck.v1() + "] overlaps with one or more data stream descriptors: [" + dataStreamsMatching.stream().map(descriptor -> descriptor.v2() + " from [" + (String)descriptor.v1() + "]").collect(Collectors.joining(", ")));
            }
        });
    }

    private static boolean overlaps(SystemIndexDescriptor a1, SystemIndexDescriptor a2) {
        return SystemIndices.overlaps(a1.getIndexPattern(), a2.getIndexPattern());
    }

    private static boolean overlaps(String pattern1, String pattern2) {
        Automaton a2Automaton;
        Automaton a1Automaton = SystemIndexDescriptor.buildAutomaton(pattern1, null);
        return !Operations.isEmpty(Operations.intersection(a1Automaton, a2Automaton = SystemIndexDescriptor.buildAutomaton(pattern2, null)));
    }

    private static Map<String, Feature> buildSystemIndexDescriptorMap(Map<String, Feature> featuresMap) {
        HashMap<String, Feature> map = new HashMap<String, Feature>(featuresMap.size() + SERVER_SYSTEM_INDEX_DESCRIPTORS.size());
        map.putAll(featuresMap);
        SERVER_SYSTEM_INDEX_DESCRIPTORS.forEach((source, feature) -> {
            if (map.putIfAbsent((String)source, (Feature)feature) != null) {
                throw new IllegalArgumentException("plugin or module attempted to define the same source [" + source + "] as a built-in system index");
            }
        });
        return Collections.unmodifiableMap(map);
    }

    Collection<SystemIndexDescriptor> getSystemIndexDescriptors() {
        return this.featureDescriptors.values().stream().flatMap(f -> f.getIndexDescriptors().stream()).collect(Collectors.toList());
    }

    public static void validateFeatureName(String name, String plugin) {
        if ("none".equalsIgnoreCase(name)) {
            throw new IllegalArgumentException("feature name cannot be reserved name [\"none\"], but was for plugin [" + plugin + "]");
        }
    }

    public static class Feature {
        private final String name;
        private final String description;
        private final Collection<SystemIndexDescriptor> indexDescriptors;
        private final Collection<SystemDataStreamDescriptor> dataStreamDescriptors;
        private final Collection<AssociatedIndexDescriptor> associatedIndexDescriptors;
        private final TriConsumer<ClusterService, Client, ActionListener<ResetFeatureStateResponse.ResetFeatureStateStatus>> cleanUpFunction;
        private final MigrationPreparationHandler preMigrationFunction;
        private final MigrationCompletionHandler postMigrationFunction;

        public Feature(String name, String description, Collection<SystemIndexDescriptor> indexDescriptors, Collection<SystemDataStreamDescriptor> dataStreamDescriptors, Collection<AssociatedIndexDescriptor> associatedIndexDescriptors, TriConsumer<ClusterService, Client, ActionListener<ResetFeatureStateResponse.ResetFeatureStateStatus>> cleanUpFunction, MigrationPreparationHandler preMigrationFunction, MigrationCompletionHandler postMigrationFunction) {
            this.name = name;
            this.description = description;
            this.indexDescriptors = indexDescriptors;
            this.dataStreamDescriptors = dataStreamDescriptors;
            this.associatedIndexDescriptors = associatedIndexDescriptors;
            this.cleanUpFunction = cleanUpFunction;
            this.preMigrationFunction = preMigrationFunction;
            this.postMigrationFunction = postMigrationFunction;
        }

        public Feature(String name, String description, Collection<SystemIndexDescriptor> indexDescriptors) {
            this(name, description, indexDescriptors, Collections.emptyList(), Collections.emptyList(), (clusterService, client, listener) -> Feature.cleanUpFeature(indexDescriptors, Collections.emptyList(), name, clusterService, client, listener), Feature::noopPreMigrationFunction, Feature::noopPostMigrationFunction);
        }

        public Feature(String name, String description, Collection<SystemIndexDescriptor> indexDescriptors, Collection<SystemDataStreamDescriptor> dataStreamDescriptors) {
            this(name, description, indexDescriptors, dataStreamDescriptors, Collections.emptyList(), (clusterService, client, listener) -> Feature.cleanUpFeature(indexDescriptors, Collections.emptyList(), name, clusterService, client, listener), Feature::noopPreMigrationFunction, Feature::noopPostMigrationFunction);
        }

        public static Feature fromSystemIndexPlugin(SystemIndexPlugin plugin, Settings settings) {
            return new Feature(plugin.getFeatureName(), plugin.getFeatureDescription(), plugin.getSystemIndexDescriptors(settings), plugin.getSystemDataStreamDescriptors(), plugin.getAssociatedIndexDescriptors(), plugin::cleanUpFeature, plugin::prepareForIndicesMigration, plugin::indicesMigrationComplete);
        }

        public String getDescription() {
            return this.description;
        }

        public Collection<SystemIndexDescriptor> getIndexDescriptors() {
            return this.indexDescriptors;
        }

        public Collection<SystemDataStreamDescriptor> getDataStreamDescriptors() {
            return this.dataStreamDescriptors;
        }

        public Collection<AssociatedIndexDescriptor> getAssociatedIndexDescriptors() {
            return this.associatedIndexDescriptors;
        }

        public TriConsumer<ClusterService, Client, ActionListener<ResetFeatureStateResponse.ResetFeatureStateStatus>> getCleanUpFunction() {
            return this.cleanUpFunction;
        }

        public String getName() {
            return this.name;
        }

        public MigrationPreparationHandler getPreMigrationFunction() {
            return this.preMigrationFunction;
        }

        public MigrationCompletionHandler getPostMigrationFunction() {
            return this.postMigrationFunction;
        }

        public static void cleanUpFeature(Collection<? extends IndexPatternMatcher> indexDescriptors, Collection<? extends IndexPatternMatcher> associatedIndexDescriptors, final String name, ClusterService clusterService, Client client, final ActionListener<ResetFeatureStateResponse.ResetFeatureStateStatus> listener) {
            Metadata metadata = clusterService.state().getMetadata();
            List<String> allIndices = Stream.concat(indexDescriptors.stream(), associatedIndexDescriptors.stream()).map(descriptor -> descriptor.getMatchingIndices(metadata)).flatMap(Collection::stream).collect(Collectors.toList());
            if (allIndices.isEmpty()) {
                listener.onResponse(ResetFeatureStateResponse.ResetFeatureStateStatus.success(name));
                return;
            }
            DeleteIndexRequest deleteIndexRequest = new DeleteIndexRequest();
            deleteIndexRequest.indices(allIndices.toArray(Strings.EMPTY_ARRAY));
            client.execute(DeleteIndexAction.INSTANCE, deleteIndexRequest, new ActionListener<AcknowledgedResponse>(){

                @Override
                public void onResponse(AcknowledgedResponse acknowledgedResponse) {
                    listener.onResponse(ResetFeatureStateResponse.ResetFeatureStateStatus.success(name));
                }

                @Override
                public void onFailure(Exception e) {
                    listener.onResponse(ResetFeatureStateResponse.ResetFeatureStateStatus.failure(name, e));
                }
            });
        }

        private static void noopPreMigrationFunction(ClusterService clusterService, Client client, ActionListener<Map<String, Object>> listener) {
            listener.onResponse(Collections.emptyMap());
        }

        private static void noopPostMigrationFunction(Map<String, Object> preUpgradeMetadata, ClusterService clusterService, Client client, ActionListener<Boolean> listener) {
            listener.onResponse(true);
        }

        public static Feature pluginToFeature(SystemIndexPlugin plugin, Settings settings) {
            return new Feature(plugin.getFeatureName(), plugin.getFeatureDescription(), plugin.getSystemIndexDescriptors(settings), plugin.getSystemDataStreamDescriptors(), plugin.getAssociatedIndexDescriptors(), plugin::cleanUpFeature, plugin::prepareForIndicesMigration, plugin::indicesMigrationComplete);
        }

        @FunctionalInterface
        public static interface MigrationPreparationHandler {
            public void prepareForIndicesMigration(ClusterService var1, Client var2, ActionListener<Map<String, Object>> var3);
        }

        @FunctionalInterface
        public static interface MigrationCompletionHandler {
            public void indicesMigrationComplete(Map<String, Object> var1, ClusterService var2, Client var3, ActionListener<Boolean> var4);
        }
    }

    public static enum SystemIndexAccessLevel {
        ALL,
        NONE,
        RESTRICTED,
        BACKWARDS_COMPATIBLE_ONLY;

    }
}

