/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import org.HdrHistogram.DoubleHistogram;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.InternalHDRPercentiles;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.xpack.analytics.aggregations.metrics.AbstractHistoBackedHDRPercentilesAggregator;

public class HistoBackedHDRPercentilesAggregator
extends AbstractHistoBackedHDRPercentilesAggregator {
    public HistoBackedHDRPercentilesAggregator(String name, ValuesSource valuesSource, AggregationContext context, Aggregator parent, double[] percents, int numberOfSignificantValueDigits, boolean keyed, DocValueFormat formatter, Map<String, Object> metadata) throws IOException {
        super(name, valuesSource, context, parent, percents, numberOfSignificantValueDigits, keyed, formatter, metadata);
    }

    public InternalAggregation buildAggregation(long owningBucketOrdinal) {
        DoubleHistogram state = this.getState(owningBucketOrdinal);
        if (state == null) {
            return this.buildEmptyAggregation();
        }
        return new InternalHDRPercentiles(this.name, this.keys, state, this.keyed, this.format, this.metadata());
    }

    public double metric(String name, long bucketOrd) {
        DoubleHistogram state = this.getState(bucketOrd);
        if (state == null) {
            return Double.NaN;
        }
        return state.getValueAtPercentile(Double.parseDouble(name));
    }

    public InternalAggregation buildEmptyAggregation() {
        DoubleHistogram state = new DoubleHistogram(this.numberOfSignificantValueDigits);
        state.setAutoResize(true);
        return new InternalHDRPercentiles(this.name, this.keys, state, this.keyed, this.format, this.metadata());
    }
}

