/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ilm.history;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.bulk.BackoffPolicy;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.OriginSettingClient;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xpack.core.ilm.LifecycleSettings;
import org.elasticsearch.xpack.ilm.history.ILMHistoryItem;

public class ILMHistoryStore
implements Closeable {
    private static final Logger logger = LogManager.getLogger(ILMHistoryStore.class);
    public static final String ILM_HISTORY_DATA_STREAM = "ilm-history-5";
    private static int ILM_HISTORY_BULK_SIZE = StrictMath.toIntExact(ByteSizeValue.parseBytesSizeValue((String)System.getProperty("es.indices.lifecycle.history.bulk.size", "50MB"), (String)"es.indices.lifecycle.history.bulk.size").getBytes());
    private final boolean ilmHistoryEnabled;
    private final BulkProcessor processor;
    private final ThreadPool threadPool;

    public ILMHistoryStore(Settings nodeSettings, Client client, final ClusterService clusterService, ThreadPool threadPool) {
        this.ilmHistoryEnabled = (Boolean)LifecycleSettings.LIFECYCLE_HISTORY_INDEX_ENABLED_SETTING.get(nodeSettings);
        this.threadPool = threadPool;
        this.processor = BulkProcessor.builder((arg_0, arg_1) -> ((OriginSettingClient)new OriginSettingClient(client, "index_lifecycle")).bulk(arg_0, arg_1), (BulkProcessor.Listener)new BulkProcessor.Listener(){

            public void beforeBulk(long executionId, BulkRequest request) {
                if (!clusterService.state().getMetadata().templatesV2().containsKey("ilm-history")) {
                    ElasticsearchException e = new ElasticsearchException("no ILM history template", new Object[0]);
                    logger.warn((Message)new ParameterizedMessage("unable to index the following ILM history items:\n{}", (Object)request.requests().stream().filter(dwr -> dwr instanceof IndexRequest).map(dwr -> (IndexRequest)dwr).map(IndexRequest::sourceAsMap).map(Object::toString).collect(Collectors.joining("\n"))), (Throwable)e);
                    throw new ElasticsearchException((Throwable)e);
                }
            }

            public void afterBulk(long executionId, BulkRequest request, BulkResponse response) {
                long items = request.numberOfActions();
                if (logger.isTraceEnabled()) {
                    logger.trace("indexed [{}] items into ILM history index [{}]", (Object)items, (Object)Arrays.stream(response.getItems()).map(BulkItemResponse::getIndex).distinct().collect(Collectors.joining(",")));
                }
                if (response.hasFailures()) {
                    Map<String, String> failures = Arrays.stream(response.getItems()).filter(BulkItemResponse::isFailed).collect(Collectors.toMap(BulkItemResponse::getId, BulkItemResponse::getFailureMessage, (msg1, msg2) -> Objects.equals(msg1, msg2) ? msg1 : msg1 + "," + msg2));
                    logger.error("failures: [{}]", failures);
                }
            }

            public void afterBulk(long executionId, BulkRequest request, Throwable failure) {
                long items = request.numberOfActions();
                logger.error((Message)new ParameterizedMessage("failed to index {} items into ILM history index", (Object)items), failure);
            }
        }, (String)"ilm-history-store").setBulkActions(-1).setBulkSize(ByteSizeValue.ofBytes((long)ILM_HISTORY_BULK_SIZE)).setFlushInterval(TimeValue.timeValueSeconds((long)5L)).setConcurrentRequests(1).setBackoffPolicy(BackoffPolicy.exponentialBackoff((TimeValue)TimeValue.timeValueMillis((long)1000L), (int)3)).build();
    }

    public void putAsync(ILMHistoryItem item) {
        if (!this.ilmHistoryEnabled) {
            logger.trace("not recording ILM history item because [{}] is [false]: [{}]", (Object)LifecycleSettings.LIFECYCLE_HISTORY_INDEX_ENABLED_SETTING.getKey(), (Object)item);
            return;
        }
        logger.trace("queueing ILM history item for indexing [{}]: [{}]", (Object)ILM_HISTORY_DATA_STREAM, (Object)item);
        try (XContentBuilder builder = XContentFactory.jsonBuilder();){
            item.toXContent(builder, ToXContent.EMPTY_PARAMS);
            IndexRequest request = new IndexRequest(ILM_HISTORY_DATA_STREAM).source(builder).opType(DocWriteRequest.OpType.CREATE);
            this.threadPool.executor("generic").execute(() -> {
                try {
                    this.processor.add(request);
                }
                catch (Exception e) {
                    logger.error((Message)new ParameterizedMessage("failed add ILM history item to queue for index [{}]: [{}]", (Object)ILM_HISTORY_DATA_STREAM, (Object)item), (Throwable)e);
                }
            });
        }
        catch (IOException exception) {
            logger.error((Message)new ParameterizedMessage("failed to queue ILM history item in index [{}]: [{}]", (Object)ILM_HISTORY_DATA_STREAM, (Object)item), (Throwable)exception);
        }
    }

    @Override
    public void close() {
        try {
            this.processor.awaitClose(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            logger.warn("failed to shut down ILM history bulk processor after 10 seconds", (Throwable)e);
        }
    }
}

