/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.deprecation.logging;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;
import org.apache.logging.log4j.core.layout.ByteBufferDestination;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.elasticsearch.common.Strings;

@Plugin(name="EcsJsonLayout", category="Core", elementType="layout", printObject=true)
public class EcsJsonLayout
extends AbstractStringLayout {
    private static final String ECS_VERSION = "1.7";
    private final PatternLayout patternLayout;

    protected EcsJsonLayout(String typeName, Charset charset, String[] esmessagefields) {
        super(charset);
        this.patternLayout = PatternLayout.newBuilder().withPattern(this.pattern(typeName, esmessagefields)).withAlwaysWriteExceptions(false).build();
    }

    protected String pattern(String dataset, String[] esMessageFields) {
        if (Strings.isEmpty((CharSequence)dataset)) {
            throw new IllegalArgumentException("layout parameter 'dataset' cannot be empty");
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("event.dataset", this.inQuotes(dataset));
        map.put("@timestamp", this.inQuotes("%d{yyyy-MM-dd'T'HH:mm:ss,SSSZZ}"));
        map.put("log.level", this.inQuotes("%p"));
        map.put("log.logger", this.inQuotes("%c"));
        map.put("elasticsearch.cluster.name", this.inQuotes("${sys:es.logs.cluster_name}"));
        map.put("elasticsearch.cluster.uuid", this.inQuotes("%cluster_id"));
        map.put("elasticsearch.node.id", this.inQuotes("%node_id"));
        map.put("elasticsearch.node.name", this.inQuotes("%node_name"));
        map.put("trace.id", this.inQuotes("%notEmpty{%trace_id}"));
        map.put("message", this.inQuotes("%notEmpty{%enc{%marker}{JSON} }%enc{%.-10000m}{JSON}"));
        map.put("data_stream.type", this.inQuotes("logs"));
        map.put("data_stream.dataset", this.inQuotes("deprecation.elasticsearch"));
        map.put("data_stream.namespace", this.inQuotes("default"));
        map.put("ecs.version", this.inQuotes(ECS_VERSION));
        HashMap<String, String> ecsKeyReplacements = new HashMap<String, String>();
        ecsKeyReplacements.put("category", "elasticsearch.event.category");
        ecsKeyReplacements.put("key", "event.code");
        ecsKeyReplacements.put("x-opaque-id", "elasticsearch.http.request.x_opaque_id");
        for (String key : esMessageFields) {
            map.put(ecsKeyReplacements.getOrDefault(key, key), this.inQuotes("%ESMessageField{" + key + "}"));
        }
        return this.createPattern(map, Stream.of(esMessageFields).collect(Collectors.toSet()));
    }

    protected String createPattern(Map<String, Object> map, Set<String> esMessageFields) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        String separator = "";
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (esMessageFields.contains(entry.getKey())) {
                sb.append("%notEmpty{");
                sb.append(separator);
                this.appendField(sb, entry);
                sb.append("}");
            } else {
                sb.append(separator);
                this.appendField(sb, entry);
            }
            separator = ", ";
        }
        sb.append("%exceptionAsJson ");
        sb.append("}");
        sb.append(System.lineSeparator());
        return sb.toString();
    }

    private void appendField(StringBuilder sb, Map.Entry<String, Object> entry) {
        sb.append(this.jsonKey(entry.getKey()));
        sb.append(entry.getValue().toString());
    }

    private CharSequence jsonKey(String s) {
        return this.inQuotes(s) + ": ";
    }

    protected String inQuotes(String s) {
        return "\"" + s + "\"";
    }

    @PluginFactory
    public static EcsJsonLayout createLayout(String type, Charset charset, String[] esmessagefields) {
        return new EcsJsonLayout(type, charset, esmessagefields);
    }

    PatternLayout getPatternLayout() {
        return this.patternLayout;
    }

    @PluginBuilderFactory
    public static <B extends Builder<B>> B newBuilder() {
        return (B)((Object)((Builder)new Builder().asBuilder()));
    }

    public String toSerializable(LogEvent event) {
        return this.patternLayout.toSerializable(event);
    }

    public Map<String, String> getContentFormat() {
        return this.patternLayout.getContentFormat();
    }

    public void encode(LogEvent event, ByteBufferDestination destination) {
        this.patternLayout.encode(event, destination);
    }

    public String toString() {
        return "EcsJsonLayout{patternLayout=" + this.patternLayout + '}';
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractStringLayout.Builder<B>
    implements org.apache.logging.log4j.core.util.Builder<EcsJsonLayout> {
        @PluginAttribute(value="dataset")
        String dataset;
        @PluginAttribute(value="charset", defaultString="UTF-8")
        Charset charset;
        @PluginAttribute(value="esmessagefields")
        private String esMessageFields;

        public Builder() {
            this.setCharset(StandardCharsets.UTF_8);
        }

        public EcsJsonLayout build() {
            String[] split = Strings.isNullOrEmpty((String)this.esMessageFields) ? new String[]{} : this.esMessageFields.split(",");
            return EcsJsonLayout.createLayout(this.dataset, this.charset, split);
        }

        public Charset getCharset() {
            return this.charset;
        }

        public B setCharset(Charset charset) {
            this.charset = charset;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public String getDataset() {
            return this.dataset;
        }

        public B setDataset(String dataset) {
            this.dataset = dataset;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public String getESMessageFields() {
            return this.esMessageFields;
        }

        public B setESMessageFields(String esmessagefields) {
            this.esMessageFields = esmessagefields;
            return (B)((Object)((Builder)this.asBuilder()));
        }
    }
}

