note
    description: "A JSON converter for AUTHOR"
    author: "Paul Cohen"
    date: "$Date: 2013-01-21 23:44:55 -0800 (Mon, 21 Jan 2013) $"
    revision: "$Revision: 90785 $"

class JSON_AUTHOR_CONVERTER

inherit
    JSON_CONVERTER

create
    make

feature {NONE} -- Initialization

    make
        local
            ucs: STRING_32
        do
            create ucs.make_from_string ("")
            create object.make (ucs)
        end

feature -- Access

    object: AUTHOR

feature -- Conversion

    from_json (j: like to_json): detachable like object
        local
            ucs: detachable STRING_32
        do
            ucs ?= json.object (j.item (name_key), Void)
            check ucs /= Void end
            create Result.make (ucs)
        end

    to_json (o: like object): JSON_OBJECT
        do
            create Result.make
            Result.put (json.value (o.name), name_key)
        end

feature    {NONE} -- Implementation

    name_key: JSON_STRING
        once
            create Result.make_json ("name")
        end

end -- class JSON_AUTHOR_CONVERTER
