note
	description: "Statistics about each base representation"
	author: "Colin LeMahieu"
	date: "$Date: 2011-11-11 09:13:16 -0800 (Fri, 11 Nov 2011) $"
	revision: "$Revision: 87787 $"
	quote: "As the growing emphasis on feelings crowds out reason, facts will play a smaller role in public discourse. - Paul Craig Roberts"

deferred class
	MP_BASES

feature

	chars_per_limb (base: INTEGER): INTEGER
			-- Number of printed characters per limb truncated down in base `base'
		require
			base >= 2
			base <= 256
		do
			inspect base
			when 2 then
				Result := 32
			when 3 then
				Result := 20
			when 4 then
				Result := 16
			when 5 then
				Result := 13
			when 6 then
				Result := 12
			when 7 then
				Result := 11
			when 8..9 then
				Result := 10
			when 10..11 then
				Result := 9
			when 12..16 then
				Result := 8
			when 17..23 then
				Result := 7
			when 24..40 then
				Result := 6
			when 41..84 then
				Result := 5
			when 85..256 then
				Result := 4
			end
		end

	chars_per_bit_exactly (base: INTEGER): REAL_64
			-- Exact number of characters per bit in base `base'
		require
			base >= 2
			base <= 256
		do
			inspect base
			when 2 then
				Result := 1.0000000000000000
			when 3 then
				Result := 0.6309297535714574
			when 4 then
				Result := 0.5000000000000000
			when 5 then
				Result := 0.4306765580733931
			when 6 then
				Result := 0.3868528072345416
			when 7 then
				Result := 0.3562071871080222
			when 8 then
				Result := 0.3333333333333334
			when 9 then
				Result := 0.3154648767857287
			when 10 then
				Result := 0.3010299956639811
			when 11 then
				Result := 0.2890648263178878
			when 12 then
				Result := 0.2789429456511298
			when 13 then
				Result := 0.2702381544273197
			when 14 then
				Result := 0.2626495350371936
			when 15 then
				Result := 0.2559580248098155
			when 16 then
				Result := 0.2500000000000000
			when 17 then
				Result := 0.2446505421182260
			when 18 then
				Result := 0.2398124665681315
			when 19 then
				Result := 0.2354089133666382
			when 20 then
				Result := 0.2313782131597592
			when 21 then
				Result := 0.2276702486969530
			when 22 then
				Result := 0.2242438242175754
			when 23 then
				Result := 0.2210647294575037
			when 24 then
				Result := 0.2181042919855316
			when 25 then
				Result := 0.2153382790366965
			when 26 then
				Result := 0.2127460535533632
			when 27 then
				Result := 0.2103099178571525
			when 28 then
				Result := 0.2080145976765095
			when 29 then
				Result := 0.2058468324604345
			when 30 then
				Result := 0.2037950470905062
			when 31 then
				Result := 0.2018490865820999
			when 32 then
				Result := 0.2000000000000000
			when 33 then
				Result := 0.1982398631705605
			when 34 then
				Result := 0.1965616322328226
			when 35 then
				Result := 0.1949590218937863
			when 36 then
				Result := 0.1934264036172708
			when 37 then
				Result := 0.1919587200065601
			when 38 then
				Result := 0.1905514124267734
			when 39 then
				Result := 0.1892003595168700
			when 40 then
				Result := 0.1879018247091076
			when 41 then
				Result := 0.1866524112389434
			when 42 then
				Result := 0.1854490234153689
			when 43 then
				Result := 0.1842888331487062
			when 44 then
				Result := 0.1831692509136336
			when 45 then
				Result := 0.1820879004699383
			when 46 then
				Result := 0.1810425967800402
			when 47 then
				Result := 0.1800313266566926
			when 48 then
				Result := 0.1790522317510414
			when 49 then
				Result := 0.1781035935540111
			when 50 then
				Result := 0.1771838201355579
			when 51 then
				Result := 0.1762914343888821
			when 52 then
				Result := 0.1754250635819545
			when 53 then
				Result := 0.1745834300480449
			when 54 then
				Result := 0.1737653428714400
			when 55 then
				Result := 0.1729696904450771
			when 56 then
				Result := 0.1721954337940981
			when 57 then
				Result := 0.1714416005739134
			when 58 then
				Result := 0.1707072796637201
			when 59 then
				Result := 0.1699916162869140
			when 60 then
				Result := 0.1692938075987814
			when 61 then
				Result := 0.1686130986895011
			when 62 then
				Result := 0.1679487789570419
			when 63 then
				Result := 0.1673001788101741
			when 64 then
				Result := 0.1666666666666667
			when 65 then
				Result := 0.1660476462159378
			when 66 then
				Result := 0.1654425539190583
			when 67 then
				Result := 0.1648508567221604
			when 68 then
				Result := 0.1642720499620502
			when 69 then
				Result := 0.1637056554452156
			when 70 then
				Result := 0.1631512196835108
			when 71 then
				Result := 0.1626083122716341
			when 72 then
				Result := 0.1620765243931223
			when 73 then
				Result := 0.1615554674429964
			when 74 then
				Result := 0.1610447717564444
			when 75 then
				Result := 0.1605440854340214
			when 76 then
				Result := 0.1600530732548214
			when 77 then
				Result := 0.1595714156699382
			when 78 then
				Result := 0.1590988078692942
			when 79 then
				Result := 0.1586349589155960
			when 80 then
				Result := 0.1581795909397823
			when 81 then
				Result := 0.1577324383928644
			when 82 then
				Result := 0.1572932473495469
			when 83 then
				Result := 0.1568617748594410
			when 84 then
				Result := 0.1564377883420716
			when 85 then
				Result := 0.1560210650222250
			when 86 then
				Result := 0.1556113914024940
			when 87 then
				Result := 0.1552085627701551
			when 88 then
				Result := 0.1548123827357682
			when 89 then
				Result := 0.1544226628011101
			when 90 then
				Result := 0.1540392219542636
			when 91 then
				Result := 0.1536618862898642
			when 92 then
				Result := 0.1532904886526781
			when 93 then
				Result := 0.1529248683028321
			when 94 then
				Result := 0.1525648706011593
			when 95 then
				Result := 0.1522103467132434
			when 96 then
				Result := 0.1518611533308632
			when 97 then
				Result := 0.1515171524096389
			when 98 then
				Result := 0.1511782109217764
			when 99 then
				Result := 0.1508442006228941
			when 100 then
				Result := 0.1505149978319906
			when 101 then
				Result := 0.1501904832236879
			when 102 then
				Result := 0.1498705416319474
			when 103 then
				Result := 0.1495550618645152
			when 104 then
				Result := 0.1492439365274121
			when 105 then
				Result := 0.1489370618588283
			when 106 then
				Result := 0.1486343375718350
			when 107 then
				Result := 0.1486343375718350
			when 108 then
				Result := 0.1480409554829326
			when 109 then
				Result := 0.1477501131786861
			when 110 then
				Result := 0.1474630519902391
			when 111 then
				Result := 0.1471796869179853
			when 112 then
				Result := 0.1468999356504447
			when 113 then
				Result := 0.1466237184553111
			when 114 then
				Result := 0.1463509580758620
			when 115 then
				Result := 0.1460815796324244
			when 116 then
				Result := 0.1458155105286054
			when 117 then
				Result := 0.1455526803620167
			when 118 then
				Result := 0.1452930208392428
			when 119 then
				Result := 0.1450364656948130
			when 120 then
				Result := 0.1447829506139581
			when 121 then
				Result := 0.1445324131589439
			when 122 then
				Result := 0.1442847926987864
			when 123 then
				Result := 0.1440400303421672
			when 124 then
				Result := 0.1437980688733775
			when 125 then
				Result := 0.1435588526911310
			when 126 then
				Result := 0.1433223277500932
			when 127 then
				Result := 0.1430884415049874
			when 128 then
				Result := 0.1428571428571429
			when 129 then
				Result := 0.1426283821033600
			when 130 then
				Result := 0.1424021108869747
			when 131 then
				Result := 0.1421782821510107
			when 132 then
				Result := 0.1419568500933153
			when 133 then
				Result := 0.1417377701235801
			when 134 then
				Result := 0.1415209988221527
			when 135 then
				Result := 0.1413064939005528
			when 136 then
				Result := 0.1410942141636095
			when 137 then
				Result := 0.1408841194731412
			when 138 then
				Result := 0.1406761707131039
			when 139 then
				Result := 0.1404703297561400
			when 140 then
				Result := 0.1402665594314587
			when 141 then
				Result := 0.1400648234939879
			when 142 then
				Result := 0.1398650865947379
			when 143 then
				Result := 0.1396673142523192
			when 144 then
				Result := 0.1394714728255649
			when 145 then
				Result := 0.1392775294872041
			when 146 then
				Result := 0.1390854521985406
			when 147 then
				Result := 0.1388952096850913
			when 148 then
				Result := 0.1387067714131417
			when 149 then
				Result := 0.1385201075671775
			when 150 then
				Result := 0.1383351890281540
			when 151 then
				Result := 0.1381519873525671
			when 152 then
				Result := 0.1379704747522905
			when 153 then
				Result := 0.1377906240751463
			when 154 then
				Result := 0.1376124087861776
			when 155 then
				Result := 0.1374358029495937
			when 156 then
				Result := 0.1372607812113589
			when 157 then
				Result := 0.1370873187823978
			when 158 then
				Result := 0.1369153914223921
			when 159 then
				Result := 0.1367449754241439
			when 160 then
				Result := 0.1365760475984821
			when 161 then
				Result := 0.1364085852596902
			when 162 then
				Result := 0.1362425662114337
			when 163 then
				Result := 0.1360779687331669
			when 164 then
				Result := 0.1359147715670014
			when 165 then
				Result := 0.1357529539050150
			when 166 then
				Result := 0.1355924953769863
			when 167 then
				Result := 0.1354333760385373
			when 168 then
				Result := 0.1352755763596663
			when 169 then
				Result := 0.1351190772136599
			when 170 then
				Result := 0.1349638598663645
			when 171 then
				Result := 0.1348099059658079
			when 172 then
				Result := 0.1346571975321549
			when 173 then
				Result := 0.1345057169479844
			when 174 then
				Result := 0.1343554469488779
			when 175 then
				Result := 0.1342063706143054
			when 176 then
				Result := 0.1340584713587980
			when 177 then
				Result := 0.1339117329233981
			when 178 then
				Result := 0.1337661393673756
			when 179 then
				Result := 0.1336216750601997
			when 180 then
				Result := 0.1334783246737591
			when 181 then
				Result := 0.1333360731748201
			when 182 then
				Result := 0.1331949058177136
			when 183 then
				Result := 0.1330548081372441
			when 184 then
				Result := 0.1329157659418126
			when 185 then
				Result := 0.1327777653067443
			when 186 then
				Result := 0.1326407925678156
			when 187 then
				Result := 0.1325048343149731
			when 188 then
				Result := 0.1323698773862368
			when 189 then
				Result := 0.1322359088617821
			when 190 then
				Result := 0.1321029160581950
			when 191 then
				Result := 0.1319708865228925
			when 192 then
				Result := 0.1318398080287045
			when 193 then
				Result := 0.1317096685686114
			when 194 then
				Result := 0.1315804563506306
			when 195 then
				Result := 0.1314521597928493
			when 196 then
				Result := 0.1313247675185968
			when 197 then
				Result := 0.1311982683517524
			when 198 then
				Result := 0.1310726513121844
			when 199 then
				Result := 0.1309479056113158
			when 200 then
				Result := 0.1308240206478128
			when 201 then
				Result := 0.1307009860033912
			when 202 then
				Result := 0.1305787914387386
			when 203 then
				Result := 0.1304574268895465
			when 204 then
				Result := 0.1303368824626505
			when 205 then
				Result := 0.1302171484322746
			when 206 then
				Result := 0.1300982152363760
			when 207 then
				Result := 0.1299800734730872
			when 208 then
				Result := 0.1298627138972530
			when 209 then
				Result := 0.1297461274170591
			when 210 then
				Result := 0.1296303050907487
			when 211 then
				Result := 0.1295152381234257
			when 212 then
				Result := 0.1294009178639407
			when 213 then
				Result := 0.1292873358018581
			when 214 then
				Result := 0.1291744835645007
			when 215 then
				Result := 0.1290623529140715
			when 216 then
				Result := 0.1289509357448472
			when 217 then
				Result := 0.1288402240804449
			when 218 then
				Result := 0.1287302100711567
			when 219 then
				Result := 0.1286208859913518
			when 220 then
				Result := 0.1285122442369443
			when 221 then
				Result := 0.1284042773229231
			when 222 then
				Result := 0.1282969778809442
			when 223 then
				Result := 0.1281903386569819
			when 224 then
				Result := 0.1280843525090381
			when 225 then
				Result := 0.1279790124049078
			when 226 then
				Result := 0.1278743114199984
			when 227 then
				Result := 0.1277702427352035
			when 228 then
				Result := 0.1276667996348261
			when 229 then
				Result := 0.1275639755045533
			when 230 then
				Result := 0.1274617638294791
			when 231 then
				Result := 0.1273601581921741
			when 232 then
				Result := 0.1272591522708010
			when 233 then
				Result := 0.1271587398372755
			when 234 then
				Result := 0.1270589147554692
			when 235 then
				Result := 0.1269596709794558
			when 236 then
				Result := 0.1268610025517973
			when 237 then
				Result := 0.1267629036018709
			when 238 then
				Result := 0.1266653683442337
			when 239 then
				Result := 0.1265683910770258
			when 240 then
				Result := 0.1264719661804097
			when 241 then
				Result := 0.1263760881150453
			when 242 then
				Result := 0.1262807514205999
			when 243 then
				Result := 0.1261859507142915
			when 244 then
				Result := 0.1260916806894653
			when 245 then
				Result := 0.1259979361142023
			when 246 then
				Result := 0.1259047118299582
			when 247 then
				Result := 0.1258120027502338
			when 248 then
				Result := 0.1257198038592741
			when 249 then
				Result := 0.1256281102107963
			when 250 then
				Result := 0.1255369169267456
			when 251 then
				Result := 0.1254462191960791
			when 252 then
				Result := 0.1253560122735751
			when 253 then
				Result := 0.1252662914786691
			when 254 then
				Result := 0.1251770521943144
			when 255 then
				Result := 0.1250882898658682
			when 256 then
				Result := 0.1250000000000000
			end
		end

	big_base (base: INTEGER): NATURAL
		do
			inspect base
			when 2 then
				Result := 0x00000001
			when 3 then
				Result := 0xcfd41b91
			when 4 then
				Result := 0x00000002
			when 5 then
				Result := 0x48c27395
			when 6 then
				Result := 0x81bf1000
			when 7 then
				Result := 0x75db9c97
			when 8 then
				Result := 0x00000003
			when 9 then
				Result := 0xcfd41b91
			when 10 then
				Result := 0x3b9aca00
			when 11 then
				Result := 0x8c8b6d2b
			when 12 then
				Result := 0x19a10000
			when 13 then
				Result := 0x309f1021
			when 14 then
				Result := 0x57f6c100
			when 15 then
				Result := 0x98c29b81
			when 16 then
				Result := 0x00000004
			when 17 then
				Result := 0x18754571
			when 18 then
				Result := 0x247dbc80
			when 19 then
				Result := 0x3547667b
			when 20 then
				Result := 0x4c4b4000
			when 21 then
				Result := 0x6b5a6e1d
			when 22 then
				Result := 0x94ace180
			when 23 then
				Result := 0xcaf18367
			when 24 then
				Result := 0x0b640000
			when 25 then
				Result := 0x0e8d4a51
			when 26 then
				Result := 0x1269ae40
			when 27 then
				Result := 0x17179149
			when 28 then
				Result := 0x1cb91000
			when 29 then
				Result := 0x23744899
			when 30 then
				Result := 0x2b73a840
			when 31 then
				Result := 0x34e63b41
			when 32 then
				Result := 0x00000005
			when 33 then
				Result := 0x4cfa3cc1
			when 34 then
				Result := 0x5c13d840
			when 35 then
				Result := 0x6d91b519
			when 36 then
				Result := 0x81bf1000
			when 37 then
				Result := 0x98ede0c9
			when 38 then
				Result := 0xb3773e40
			when 39 then
				Result := 0xd1bbc4d1
			when 40 then
				Result := 0xf4240000
			when 41 then
				Result := 0x06e7d349
			when 42 then
				Result := 0x07ca30a0
			when 43 then
				Result := 0x08c32bbb
			when 44 then
				Result := 0x09d46c00
			when 45 then
				Result := 0x0affacfd
			when 46 then
				Result := 0x0c46bee0
			when 47 then
				Result := 0x0dab86ef
			when 48 then
				Result := 0x0f300000
			when 49 then
				Result := 0x10d63af1
			when 50 then
				Result := 0x12a05f20
			when 51 then
				Result := 0x1490aae3
			when 52 then
				Result := 0x16a97400
			when 53 then
				Result := 0x18ed2825
			when 54 then
				Result := 0x1b5e4d60
			when 55 then
				Result := 0x1dff8297
			when 56 then
				Result := 0x20d38000
			when 57 then
				Result := 0x23dd1799
			when 58 then
				Result := 0x271f35a0
			when 59 then
				Result := 0x2a9ce10b
			when 60 then
				Result := 0x2e593c00
			when 61 then
				Result := 0x3257844d
			when 62 then
				Result := 0x369b13e0
			when 63 then
				Result := 0x3b27613f
			when 64 then
				Result := 0x00000006
			when 65 then
				Result := 0x4528a141
			when 66 then
				Result := 0x4aa51420
			when 67 then
				Result := 0x50794633
			when 68 then
				Result := 0x56a94400
			when 69 then
				Result := 0x5d393975
			when 70 then
				Result := 0x642d7260
			when 71 then
				Result := 0x6b8a5ae7
			when 72 then
				Result := 0x73548000
			when 73 then
				Result := 0x7b908fe9
			when 74 then
				Result := 0x84435aa0
			when 75 then
				Result := 0x8d71d25b
			when 76 then
				Result := 0x97210c00
			when 77 then
				Result := 0xa1563f9d
			when 78 then
				Result := 0xac16c8e0
			when 79 then
				Result := 0xb768278f
			when 80 then
				Result := 0xc3500000
			when 81 then
				Result := 0xcfd41b91
			when 82 then
				Result := 0xdcfa6920
			when 83 then
				Result := 0xeac8fd83
			when 84 then
				Result := 0xf9461400
			when 85 then
				Result := 0x031c84b1
			when 86 then
				Result := 0x0342ab10
			when 87 then
				Result := 0x036a2c21
			when 88 then
				Result := 0x03931000
			when 89 then
				Result := 0x03bd5ee1
			when 90 then
				Result := 0x03e92110
			when 91 then
				Result := 0x04165ef1
			when 92 then
				Result := 0x04452100
			when 93 then
				Result := 0x04756fd1
			when 94 then
				Result := 0x04a75410
			when 95 then
				Result := 0x04dad681
			when 96 then
				Result := 0x05100000
			when 97 then
				Result := 0x0546d981
			when 98 then
				Result := 0x057f6c10
			when 99 then
				Result := 0x05b9c0d1
			when 100 then
				Result := 0x05f5e100
			when 101 then
				Result := 0x0633d5f1
			when 102 then
				Result := 0x0673a910
			when 103 then
				Result := 0x06b563e1
			when 104 then
				Result := 0x06f91000
			when 105 then
				Result := 0x073eb721
			when 106 then
				Result := 0x07866310
			when 107 then
				Result := 0x07866310
			when 108 then
				Result := 0x081bf100
			when 109 then
				Result := 0x0869e711
			when 110 then
				Result := 0x08ba0a10
			when 111 then
				Result := 0x090c6441
			when 112 then
				Result := 0x09610000
			when 113 then
				Result := 0x09b7e7c1
			when 114 then
				Result := 0x0a112610
			when 115 then
				Result := 0x0a6cc591
			when 116 then
				Result := 0x0acad100
			when 117 then
				Result := 0x0b2b5331
			when 118 then
				Result := 0x0b8e5710
			when 119 then
				Result := 0x0bf3e7a1
			when 120 then
				Result := 0x0c5c1000
			when 121 then
				Result := 0x0cc6db61
			when 122 then
				Result := 0x0d345510
			when 123 then
				Result := 0x0da48871
			when 124 then
				Result := 0x0e178100
			when 125 then
				Result := 0x0e8d4a51
			when 126 then
				Result := 0x0f05f010
			when 127 then
				Result := 0x0f817e01
			when 128 then
				Result := 0x00000007
			when 129 then
				Result := 0x10818201
			when 130 then
				Result := 0x11061010
			when 131 then
				Result := 0x118db651
			when 132 then
				Result := 0x12188100
			when 133 then
				Result := 0x12a67c71
			when 134 then
				Result := 0x1337b510
			when 135 then
				Result := 0x13cc3761
			when 136 then
				Result := 0x14641000
			when 137 then
				Result := 0x14ff4ba1
			when 138 then
				Result := 0x159df710
			when 139 then
				Result := 0x16401f31
			when 140 then
				Result := 0x16e5d100
			when 141 then
				Result := 0x178f1991
			when 142 then
				Result := 0x183c0610
			when 143 then
				Result := 0x18eca3c1
			when 144 then
				Result := 0x19a10000
			when 145 then
				Result := 0x1a592841
			when 146 then
				Result := 0x1b152a10
			when 147 then
				Result := 0x1bd51311
			when 148 then
				Result := 0x1c98f100
			when 149 then
				Result := 0x1d60d1b1
			when 150 then
				Result := 0x1e2cc310
			when 151 then
				Result := 0x1efcd321
			when 152 then
				Result := 0x1fd11000
			when 153 then
				Result := 0x20a987e1
			when 154 then
				Result := 0x21864910
			when 155 then
				Result := 0x226761f1
			when 156 then
				Result := 0x234ce100
			when 157 then
				Result := 0x2436d4d1
			when 158 then
				Result := 0x25254c10
			when 159 then
				Result := 0x26185581
			when 160 then
				Result := 0x27100000
			when 161 then
				Result := 0x280c5a81
			when 162 then
				Result := 0x290d7410
			when 163 then
				Result := 0x2a135bd1
			when 164 then
				Result := 0x2b1e2100
			when 165 then
				Result := 0x2c2dd2f1
			when 166 then
				Result := 0x2d428110
			when 167 then
				Result := 0x2e5c3ae1
			when 168 then
				Result := 0x2f7b1000
			when 169 then
				Result := 0x309f1021
			when 170 then
				Result := 0x31c84b10
			when 171 then
				Result := 0x32f6d0b1
			when 172 then
				Result := 0x342ab100
			when 173 then
				Result := 0x3563fc11
			when 174 then
				Result := 0x36a2c210
			when 175 then
				Result := 0x37e71341
			when 176 then
				Result := 0x39310000
			when 177 then
				Result := 0x3a8098c1
			when 178 then
				Result := 0x3bd5ee10
			when 179 then
				Result := 0x3d311091
			when 180 then
				Result := 0x3e921100
			when 181 then
				Result := 0x3ff90031
			when 182 then
				Result := 0x4165ef10
			when 183 then
				Result := 0x42d8eea1
			when 184 then
				Result := 0x44521000
			when 185 then
				Result := 0x45d16461
			when 186 then
				Result := 0x4756fd10
			when 187 then
				Result := 0x48e2eb71
			when 188 then
				Result := 0x4a754100
			when 189 then
				Result := 0x4c0e0f51
			when 190 then
				Result := 0x4dad6810
			when 191 then
				Result := 0x4f535d01
			when 192 then
				Result := 0x51000000
			when 193 then
				Result := 0x52b36301
			when 194 then
				Result := 0x546d9810
			when 195 then
				Result := 0x562eb151
			when 196 then
				Result := 0x57f6c100
			when 197 then
				Result := 0x59c5d971
			when 198 then
				Result := 0x5b9c0d10
			when 199 then
				Result := 0x5d796e61
			when 200 then
				Result := 0x5f5e1000
			when 201 then
				Result := 0x614a04a1
			when 202 then
				Result := 0x633d5f10
			when 203 then
				Result := 0x65383231
			when 204 then
				Result := 0x673a9100
			when 205 then
				Result := 0x69448e91
			when 206 then
				Result := 0x6b563e10
			when 207 then
				Result := 0x6d6fb2c1
			when 208 then
				Result := 0x6f910000
			when 209 then
				Result := 0x71ba3941
			when 210 then
				Result := 0x73eb7210
			when 211 then
				Result := 0x7624be11
			when 212 then
				Result := 0x78663100
			when 213 then
				Result := 0x7aafdeb1
			when 214 then
				Result := 0x7d01db10
			when 215 then
				Result := 0x7f5c3a21
			when 216 then
				Result := 0x81bf1000
			when 217 then
				Result := 0x842a70e1
			when 218 then
				Result := 0x869e7110
			when 219 then
				Result := 0x891b24f1
			when 220 then
				Result := 0x8ba0a100
			when 221 then
				Result := 0x8e2ef9d1
			when 222 then
				Result := 0x90c64410
			when 223 then
				Result := 0x93669481
			when 224 then
				Result := 0x96100000
			when 225 then
				Result := 0x98c29b81
			when 226 then
				Result := 0x9b7e7c10
			when 227 then
				Result := 0x9e43b6d1
			when 228 then
				Result := 0xa1126100
			when 229 then
				Result := 0xa3ea8ff1
			when 230 then
				Result := 0xa6cc5910
			when 231 then
				Result := 0xa9b7d1e1
			when 232 then
				Result := 0xacad1000
			when 233 then
				Result := 0xafac2921
			when 234 then
				Result := 0xb2b53310
			when 235 then
				Result := 0xb5c843b1
			when 236 then
				Result := 0xb8e57100
			when 237 then
				Result := 0xbc0cd111
			when 238 then
				Result := 0xbf3e7a10
			when 239 then
				Result := 0xc27a8241
			when 240 then
				Result := 0xc5c10000
			when 241 then
				Result := 0xc91209c1
			when 242 then
				Result := 0xcc6db610
			when 243 then
				Result := 0xcfd41b91
			when 244 then
				Result := 0xd3455100
			when 245 then
				Result := 0xd6c16d31
			when 246 then
				Result := 0xda488710
			when 247 then
				Result := 0xdddab5a1
			when 248 then
				Result := 0xe1781000
			when 249 then
				Result := 0xe520ad61
			when 250 then
				Result := 0xe8d4a510
			when 251 then
				Result := 0xec940e71
			when 252 then
				Result := 0xf05f0100
			when 253 then
				Result := 0xf4359451
			when 254 then
				Result := 0xf817e010
			when 255 then
				Result := 0xfc05fc01
			when 256 then
				Result := 0x00000008
			end
		end

	big_base_inverted (base: INTEGER): NATURAL
		require
			base >= 2
			base <= 256
		do
			inspect base
			when 2 then
				Result := 0x00000000
			when 3 then
				Result := 0x3b563c24
			when 4 then
				Result := 0x00000000
			when 5 then
				Result := 0xc25c2684
			when 6 then
				Result := 0xf91bd1b6
			when 7 then
				Result := 0x1607a2cb
			when 8 then
				Result := 0x00000000
			when 9 then
				Result := 0x3b563c24
			when 10 then
				Result := 0x12e0be82
			when 11 then
				Result := 0xd24cde04
			when 12 then
				Result := 0x3fa39ab5
			when 13 then
				Result := 0x50f8ac5f
			when 14 then
				Result := 0x74843b1e
			when 15 then
				Result := 0xad0326c2
			when 16 then
				Result := 0x00000000
			when 17 then
				Result := 0x4ef0b6bd
			when 18 then
				Result := 0xc0fc48a1
			when 19 then
				Result := 0x33838942
			when 20 then
				Result := 0xad7f29ab
			when 21 then
				Result := 0x313c3d15
			when 22 then
				Result := 0xb8cca9e0
			when 23 then
				Result := 0x42ed6de9
			when 24 then
				Result := 0x67980e0b
			when 25 then
				Result := 0x19799812
			when 26 then
				Result := 0xbce85396
			when 27 then
				Result := 0x62c103a9
			when 28 then
				Result := 0x1d353d43
			when 29 then
				Result := 0xce1decea
			when 30 then
				Result := 0x790fc511
			when 31 then
				Result := 0x35b865a0
			when 32 then
				Result := 0x00000000
			when 33 then
				Result := 0xa9aed1b3
			when 34 then
				Result := 0x63dfc229
			when 35 then
				Result := 0x2b0fee30
			when 36 then
				Result := 0xf91bd1b6
			when 37 then
				Result := 0xac89c3a9
			when 38 then
				Result := 0x6d2c32fe
			when 39 then
				Result := 0x387907c9
			when 40 then
				Result := 0x0c6f7a0b
			when 41 then
				Result := 0x28928154
			when 42 then
				Result := 0x06e8629d
			when 43 then
				Result := 0xd373dca0
			when 44 then
				Result := 0xa0b17895
			when 45 then
				Result := 0x746811a5
			when 46 then
				Result := 0x4da6500f
			when 47 then
				Result := 0x2ba23582
			when 48 then
				Result := 0x0db20a88
			when 49 then
				Result := 0xe68d5ce4
			when 50 then
				Result := 0xb7cdfd9d
			when 51 then
				Result := 0x8e583933
			when 52 then
				Result := 0x697cc3ea
			when 53 then
				Result := 0x48a5ca6c
			when 54 then
				Result := 0x2b52db16
			when 55 then
				Result := 0x111586a6
			when 56 then
				Result := 0xf31d2b36
			when 57 then
				Result := 0xc8d76d19
			when 58 then
				Result := 0xa2cb1eb4
			when 59 then
				Result := 0x807c3ec3
			when 60 then
				Result := 0x617ec8bf
			when 61 then
				Result := 0x45746cbe
			when 62 then
				Result := 0x2c0aa273
			when 63 then
				Result := 0x14f90805
			when 64 then
				Result := 0x00000000
			when 65 then
				Result := 0xd9cf0829
			when 66 then
				Result := 0xb6fc4841
			when 67 then
				Result := 0x973054cb
			when 68 then
				Result := 0x7a1dbe4b
			when 69 then
				Result := 0x5f7fcd7f
			when 70 then
				Result := 0x47196c84
			when 71 then
				Result := 0x30b43635
			when 72 then
				Result := 0x1c1fa5f6
			when 73 then
				Result := 0x930634a
			when 74 then
				Result := 0xef7f4a3c
			when 75 then
				Result := 0xcf5552d2
			when 76 then
				Result := 0xb1a47c8e
			when 77 then
				Result := 0x9634b43e
			when 78 then
				Result := 0x7cd3817d
			when 79 then
				Result := 0x65536761
			when 80 then
				Result := 0x4f8b588e
			when 81 then
				Result := 0x3b563c24
			when 82 then
				Result := 0x28928154
			when 83 then
				Result := 0x1721bfb0
			when 84 then
				Result := 0x06e8629d
			when 85 then
				Result := 0x491cc17c
			when 86 then
				Result := 0x3a11d83b
			when 87 then
				Result := 0x2be074cd
			when 88 then
				Result := 0x1e7a02e7
			when 89 then
				Result := 0x11d10edd
			when 90 then
				Result := 0x05d92c68
			when 91 then
				Result := 0xf50dbfb2
			when 92 then
				Result := 0xdf9f1316
			when 93 then
				Result := 0xcb52a684
			when 94 then
				Result := 0xb8163e97
			when 95 then
				Result := 0xa5d8f269
			when 96 then
				Result := 0x948b0fcd
			when 97 then
				Result := 0x841e0215
			when 98 then
				Result := 0x74843b1e
			when 99 then
				Result := 0x65b11e6e
			when 100 then
				Result := 0x5798ee23
			when 101 then
				Result := 0x4a30b99b
			when 102 then
				Result := 0x3d6e4d94
			when 103 then
				Result := 0x314825b0
			when 104 then
				Result := 0x25b55f2e
			when 105 then
				Result := 0x1aadaccb
			when 106 then
				Result := 0x10294ba2
			when 107 then
				Result := 0x10294ba2
			when 108 then
				Result := 0xf91bd1b6
			when 109 then
				Result := 0xe6d37b2a
			when 110 then
				Result := 0xd55cff6e
			when 111 then
				Result := 0xc4ad2db2
			when 112 then
				Result := 0xb4b985cf
			when 113 then
				Result := 0xa5782bef
			when 114 then
				Result := 0x96dfdd2a
			when 115 then
				Result := 0x88e7e509
			when 116 then
				Result := 0x7b8813d3
			when 117 then
				Result := 0x6eb8b595
			when 118 then
				Result := 0x627289db
			when 119 then
				Result := 0x56aebc07
			when 120 then
				Result := 0x4b66dc33
			when 121 then
				Result := 0x4094d8a3
			when 122 then
				Result := 0x3632f7a5
			when 123 then
				Result := 0x2c3bd1f0
			when 124 then
				Result := 0x22aa4d5f
			when 125 then
				Result := 0x19799812
			when 126 then
				Result := 0x10a523e5
			when 127 then
				Result := 0x0828a237
			when 128 then
				Result := 0x00000000
			when 129 then
				Result := 0xf04ec452
			when 130 then
				Result := 0xe136444a
			when 131 then
				Result := 0xd2af9589
			when 132 then
				Result := 0xc4b42a83
			when 133 then
				Result := 0xb73dccf5
			when 134 then
				Result := 0xaa4698c5
			when 135 then
				Result := 0x9dc8f729
			when 136 then
				Result := 0x91bf9a30
			when 137 then
				Result := 0x86257887
			when 138 then
				Result := 0x7af5c98c
			when 139 then
				Result := 0x702c01a0
			when 140 then
				Result := 0x65c3ceb1
			when 141 then
				Result := 0x5bb91502
			when 142 then
				Result := 0x5207ec23
			when 143 then
				Result := 0x48ac9c19
			when 144 then
				Result := 0x3fa39ab5
			when 145 then
				Result := 0x36e98912
			when 146 then
				Result := 0x2e7b3140
			when 147 then
				Result := 0x2655840b
			when 148 then
				Result := 0x1e7596ea
			when 149 then
				Result := 0x16d8a20d
			when 150 then
				Result := 0x0f7bfe87
			when 151 then
				Result := 0x085d2492
			when 152 then
				Result := 0x0179a9f4
			when 153 then
				Result := 0xf59e80eb
			when 154 then
				Result := 0xe8b768db
			when 155 then
				Result := 0xdc39d6d5
			when 156 then
				Result := 0xd021c5d1
			when 157 then
				Result := 0xc46b5e37
			when 158 then
				Result := 0xb912f39c
			when 159 then
				Result := 0xae150294
			when 160 then
				Result := 0xa36e2eb1
			when 161 then
				Result := 0x991b4094
			when 162 then
				Result := 0x8f19241e
			when 163 then
				Result := 0x8564e6b7
			when 164 then
				Result := 0x7bfbb5b4
			when 165 then
				Result := 0x72dadcc8
			when 166 then
				Result := 0x69ffc498
			when 167 then
				Result := 0x6167f154
			when 168 then
				Result := 0x5911016e
			when 169 then
				Result := 0x50f8ac5f
			when 170 then
				Result := 0x491cc17c
			when 171 then
				Result := 0x417b26d8
			when 172 then
				Result := 0x3a11d83b
			when 173 then
				Result := 0x32dee622
			when 174 then
				Result := 0x2be074cd
			when 175 then
				Result := 0x2514bb58
			when 176 then
				Result := 0x1e7a02e7
			when 177 then
				Result := 0x180ea5d0
			when 178 then
				Result := 0x11d10edd
			when 179 then
				Result := 0x0bbfb88e
			when 180 then
				Result := 0x05d92c68
			when 181 then
				Result := 0x001c024c
			when 182 then
				Result := 0xf50dbfb2
			when 183 then
				Result := 0xea30efa3
			when 184 then
				Result := 0xdf9f1316
			when 185 then
				Result := 0xd555c0c9
			when 186 then
				Result := 0xcb52a684
			when 187 then
				Result := 0xc193881f
			when 188 then
				Result := 0xb8163e97
			when 189 then
				Result := 0xaed8b724
			when 190 then
				Result := 0xa5d8f269
			when 191 then
				Result := 0x9d15039d
			when 192 then
				Result := 0x948b0fcd
			when 193 then
				Result := 0x8c394d1d
			when 194 then
				Result := 0x841e0215
			when 195 then
				Result := 0x7c3784f8
			when 196 then
				Result := 0x74843b1e
			when 197 then
				Result := 0x6d02985d
			when 198 then
				Result := 0x65b11e6e
			when 199 then
				Result := 0x5e8e5c64
			when 200 then
				Result := 0x5798ee23
			when 201 then
				Result := 0x50cf7bde
			when 202 then
				Result := 0x4a30b99b
			when 203 then
				Result := 0x43bb66bd
			when 204 then
				Result := 0x3d6e4d94
			when 205 then
				Result := 0x374842ee
			when 206 then
				Result := 0x314825b0
			when 207 then
				Result := 0x2b6cde75
			when 208 then
				Result := 0x25b55f2e
			when 209 then
				Result := 0x2020a2c5
			when 210 then
				Result := 0x1aadaccb
			when 211 then
				Result := 0x155b891f
			when 212 then
				Result := 0x10294ba2
			when 213 then
				Result := 0xb160fe9
			when 214 then
				Result := 0x620f8f6
			when 215 then
				Result := 0x14930ef
			when 216 then
				Result := 0xf91bd1b6
			when 217 then
				Result := 0xefdcb0c7
			when 218 then
				Result := 0xe6d37b2a
			when 219 then
				Result := 0xddfeb94a
			when 220 then
				Result := 0xd55cff6e
			when 221 then
				Result := 0xcceced50
			when 222 then
				Result := 0xc4ad2db2
			when 223 then
				Result := 0xbc9c75f9
			when 224 then
				Result := 0xb4b985cf
			when 225 then
				Result := 0xad0326c2
			when 226 then
				Result := 0xa5782bef
			when 227 then
				Result := 0x9e1771a9
			when 228 then
				Result := 0x96dfdd2a
			when 229 then
				Result := 0x8fd05c41
			when 230 then
				Result := 0x88e7e509
			when 231 then
				Result := 0x8225759d
			when 232 then
				Result := 0x7b8813d3
			when 233 then
				Result := 0x750eccf9
			when 234 then
				Result := 0x6eb8b595
			when 235 then
				Result := 0x6884e923
			when 236 then
				Result := 0x627289db
			when 237 then
				Result := 0x5c80c07b
			when 238 then
				Result := 0x56aebc07
			when 239 then
				Result := 0x50fbb19b
			when 240 then
				Result := 0x4b66dc33
			when 241 then
				Result := 0x45ef7c7c
			when 242 then
				Result := 0x4094d8a3
			when 243 then
				Result := 0x3b563c24
			when 244 then
				Result := 0x3632f7a5
			when 245 then
				Result := 0x312a60c3
			when 246 then
				Result := 0x2c3bd1f0
			when 247 then
				Result := 0x2766aa45
			when 248 then
				Result := 0x22aa4d5f
			when 249 then
				Result := 0x1e06233c
			when 250 then
				Result := 0x19799812
			when 251 then
				Result := 0x15041c33
			when 252 then
				Result := 0x10a523e5
			when 253 then
				Result := 0x0c5c2749
			when 254 then
				Result := 0x0828a237
			when 255 then
				Result := 0x040a1423
			when 256 then
				Result := 0x00000000
			end
		end
end
