note

	description:

		"Objects that detail trace events"

	library: "Gobo Eiffel XSLT Library"
	copyright: "Copyright (c) 2004, Colin Adams and others"
	license: "MIT License"
	date: "$Date: 2012-08-22 12:54:13 -0700 (Wed, 22 Aug 2012) $"
	revision: "$Revision: 89387 $"

deferred class XM_XSLT_TRACE_DETAILS

inherit

	XM_XPATH_LOCATOR

	XM_XPATH_NAME_UTILITIES

	XM_XPATH_STANDARD_NAMESPACES

	KL_IMPORTED_STRING_ROUTINES

	KL_IMPORTED_ANY_ROUTINES
		export {NONE} all end

feature -- Access

	closing_line_number: INTEGER
			-- Line number of element end tag (or 0 if not known)
		deferred
		ensure
			non_negative_result: Result >= 0
		end

	construct_type: INTEGER
			-- Type of construct being traced
		deferred
		ensure
			positive_result: Result >= 0
		end

	trace_property (an_expanded_name: STRING): STRING
			-- Value of trace-property
		require
			name_not_empty: an_expanded_name /= Void and then an_expanded_name.count > 0
			name_is_expanded_name: is_valid_expanded_name (an_expanded_name)
			property_present: STRING_.same_string (an_expanded_name, Gexslt_name_pseudo_attribute) or else trace_properties.has (an_expanded_name)
		deferred
		ensure
			result_not_void: Result /= Void
		end

	trace_properties: DS_LIST [STRING]
			-- Names of trace-properties
		deferred
		ensure
			properties_not_void: Result /= Void
		end

end

