note

	description:

		"Event filters that can forward event to 'next' filter"

	library: "Gobo Eiffel XML Library"
	copyright: "Copyright (c) 2002, Eric Bezault and others"
	license: "MIT License"
	date: "$Date: 2012-08-22 12:54:13 -0700 (Wed, 22 Aug 2012) $"
	revision: "$Revision: 89387 $"

class XM_CALLBACKS_FILTER

inherit

	XM_CALLBACKS

	XM_CALLBACKS_SOURCE
		rename
			set_callbacks as set_next
		end

	XM_FORWARD_CALLBACKS
		-- implementation of default behaviour:
		-- forwarding to 'next' processor in chain
		rename
			callbacks as next,
			set_callbacks as set_next
		end

create

	make_null,
	set_next

feature {NONE} -- Initialization

	make_null
			-- Next is null processor.
		do
			create {XM_CALLBACKS_NULL} next.make
		end

invariant

	next_not_void: next /= Void

end
